/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.impl.cookie.DateParseException;
import ch.boye.httpclientandroidlib.impl.cookie.DateUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;

public class MozResponse {
    private static final String LOG_TAG = "MozResponse";
    private static final String HEADER_RETRY_AFTER = "retry-after";
    protected HttpResponse response;
    private String body = null;

    public HttpResponse httpResponse() {
        return this.response;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public boolean wasSuccessful() {
        return this.getStatusCode() == 200;
    }

    public boolean isInvalidAuthentication() {
        return this.getStatusCode() == 401;
    }

    public Header getContentType() {
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity == null) {
            return null;
        }
        return httpEntity.getContentType();
    }

    private static boolean missingHeader(String string2) {
        return string2 == null || string2.trim().length() == 0;
    }

    public String body() throws IllegalStateException, IOException {
        if (this.body != null) {
            return this.body;
        }
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity == null) {
            this.body = null;
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(httpEntity.getContent());
        this.body = new Scanner(inputStreamReader).useDelimiter("\\A").next();
        return this.body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedJSONObject jsonObjectBody() throws IllegalStateException, IOException, ParseException, NonObjectJSONException {
        if (this.body != null) {
            return ExtendedJSONObject.parseJSONObject(this.body);
        }
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity == null) {
            throw new IOException("no entity");
        }
        try (InputStream inputStream = httpEntity.getContent();){
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ExtendedJSONObject extendedJSONObject = ExtendedJSONObject.parseJSONObject(bufferedReader);
            return extendedJSONObject;
        }
    }

    protected boolean hasHeader(String string2) {
        return this.response.containsHeader(string2);
    }

    public MozResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    private String getNonMissingHeader(String string2) {
        if (!this.hasHeader(string2)) {
            return null;
        }
        Header header = this.response.getFirstHeader(string2);
        String string3 = header.getValue();
        if (MozResponse.missingHeader(string3)) {
            Logger.warn(LOG_TAG, string2 + " header present but empty.");
            return null;
        }
        return string3;
    }

    protected long getLongHeader(String string2) throws NumberFormatException {
        String string3 = this.getNonMissingHeader(string2);
        if (string3 == null) {
            return -1L;
        }
        return Long.parseLong(string3, 10);
    }

    protected int getIntegerHeader(String string2) throws NumberFormatException {
        String string3 = this.getNonMissingHeader(string2);
        if (string3 == null) {
            return -1;
        }
        return Integer.parseInt(string3, 10);
    }

    public int retryAfterInSeconds() throws NumberFormatException {
        String string2 = this.getNonMissingHeader(HEADER_RETRY_AFTER);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                long l = DateUtils.parseDate((String)string2).getTime();
                long l2 = System.currentTimeMillis();
                return (int)((l - l2) / 1000L);
            }
            catch (DateParseException dateParseException) {
                Logger.warn(LOG_TAG, "Retry-After header neither integer nor date: " + string2);
                return -1;
            }
        }
    }

    public int backoffInSeconds() throws NumberFormatException {
        return this.getIntegerHeader("backoff");
    }

    public void logResponseBody(String string2) {
        if (!Logger.LOG_PERSONAL_INFORMATION) {
            return;
        }
        try {
            Logger.pii(string2, "Response body: " + this.body());
        }
        catch (Throwable throwable) {
            Logger.debug(string2, "No response body.");
        }
    }
}

