/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.text.style.URLSpan;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.toolbar.SiteIdentityPopup;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;

public class DefaultDoorHanger
extends DoorHanger {
    private static final String LOGTAG = "GeckoDefaultDoorHanger";
    private static int sSpinnerTextColor = -1;
    private final TextView mMessage = (TextView)this.findViewById(R.id.doorhanger_message);
    private List<PromptInput> mInputs;
    private CheckBox mCheckBox;

    public DefaultDoorHanger(Context context, DoorhangerConfig doorhangerConfig, DoorHanger.Type type) {
        super(context, doorhangerConfig, type);
        if (sSpinnerTextColor == -1) {
            sSpinnerTextColor = this.mResources.getColor(R.color.text_color_primary_disable_only);
        }
        this.loadConfig(doorhangerConfig);
    }

    @Override
    protected void loadConfig(DoorhangerConfig doorhangerConfig) {
        DoorhangerConfig.Link link;
        JSONObject jSONObject;
        String string2 = doorhangerConfig.getMessage();
        if (string2 != null) {
            this.setMessage(string2);
        }
        if ((jSONObject = doorhangerConfig.getOptions()) != null) {
            this.setOptions(jSONObject);
        }
        if ((link = doorhangerConfig.getLink()) != null) {
            this.addLink(link.label, link.url, link.delimiter);
        }
        this.addButtonsToLayout(doorhangerConfig);
    }

    @Override
    protected int getContentResource() {
        return R.layout.default_doorhanger;
    }

    private List<PromptInput> getInputs() {
        return this.mInputs;
    }

    private CheckBox getCheckBox() {
        return this.mCheckBox;
    }

    @Override
    public void setOptions(JSONObject jSONObject) {
        String string2;
        Object object;
        super.setOptions(jSONObject);
        JSONObject jSONObject2 = jSONObject.optJSONObject("link");
        if (jSONObject2 != null) {
            try {
                object = jSONObject2.getString("label");
                string2 = jSONObject2.getString("url");
                this.addLink((String)object, string2, " ");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if ((object = jSONObject.optJSONArray("inputs")) != null) {
            this.mInputs = new ArrayList<PromptInput>();
            string2 = (ViewGroup)this.findViewById(R.id.doorhanger_inputs);
            string2.setVisibility(0);
            for (int i = 0; i < object.length(); ++i) {
                try {
                    PromptInput promptInput = PromptInput.getInput(object.getJSONObject(i));
                    this.mInputs.add(promptInput);
                    int n = this.mResources.getDimensionPixelSize(R.dimen.doorhanger_padding);
                    View view = promptInput.getView(this.getContext());
                    this.styleInput(promptInput, view);
                    view.setPadding(0, 0, 0, n);
                    string2.addView(view);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = jSONObject.optString("checkbox")))) {
            this.mCheckBox = (CheckBox)this.findViewById(R.id.doorhanger_checkbox);
            this.mCheckBox.setText((CharSequence)string2);
            this.mCheckBox.setVisibility(0);
        }
    }

    @Override
    protected View.OnClickListener makeOnButtonClickListener(final int n) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                JSONObject jSONObject = new JSONObject();
                try {
                    switch (DefaultDoorHanger.this.mType) {
                        case MIXED_CONTENT: {
                            jSONObject.put("allowContent", n == SiteIdentityPopup.ButtonType.DISABLE.ordinal());
                            jSONObject.put("contentType", (Object)"mixed");
                            break;
                        }
                        case TRACKING: {
                            jSONObject.put("allowContent", n == SiteIdentityPopup.ButtonType.DISABLE.ordinal());
                            jSONObject.put("contentType", (Object)"tracking");
                            break;
                        }
                        default: {
                            List list;
                            jSONObject.put("callback", n);
                            CheckBox checkBox = DefaultDoorHanger.this.getCheckBox();
                            if (checkBox != null) {
                                jSONObject.put("checked", checkBox.isChecked());
                            }
                            if ((list = DefaultDoorHanger.this.getInputs()) != null) {
                                JSONObject jSONObject2 = new JSONObject();
                                for (PromptInput promptInput : list) {
                                    jSONObject2.put(promptInput.getId(), promptInput.getValue());
                                }
                                jSONObject.put("inputs", (Object)jSONObject2);
                            }
                            break;
                        }
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)DefaultDoorHanger.LOGTAG, (String)"Error creating onClick response", (Throwable)jSONException);
                }
                DefaultDoorHanger.this.mOnButtonClickListener.onButtonClick(jSONObject, DefaultDoorHanger.this);
            }
        };
    }

    private void setMessage(String string2) {
        Spanned spanned = Html.fromHtml((String)string2);
        this.mMessage.setText((CharSequence)spanned);
    }

    private void addLink(String string2, String string3, String string4) {
        String string5 = this.mMessage.getText().toString();
        SpannableString spannableString = new SpannableString((CharSequence)(string5 + string4 + string2));
        URLSpan uRLSpan = new URLSpan(string3){

            public void onClick(View view) {
                Tabs.getInstance().loadUrlInTab(this.getURL());
            }
        };
        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(this.mMessage.getCurrentTextColor());
        spannableString.setSpan((Object)foregroundColorSpan, 0, string5.length(), 0);
        spannableString.setSpan((Object)uRLSpan, string5.length() + 1, spannableString.length(), 0);
        this.mMessage.setText((CharSequence)spannableString);
        this.mMessage.setMovementMethod(LinkMovementMethod.getInstance());
    }

    private void styleInput(PromptInput promptInput, View view) {
        if (promptInput instanceof PromptInput.MenulistInput) {
            this.styleDropdownInputs(promptInput, view);
        }
        view.setPadding(0, 0, 0, this.mResources.getDimensionPixelSize(R.dimen.doorhanger_padding));
    }

    private void styleDropdownInputs(PromptInput promptInput, View view) {
        PromptInput.MenulistInput menulistInput = (PromptInput.MenulistInput)promptInput;
        if (menulistInput.textView != null) {
            menulistInput.textView.setTextColor(sSpinnerTextColor);
        }
    }
}

