/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.client.cache.Resource;
import ch.boye.httpclientandroidlib.entity.AbstractHttpEntity;
import ch.boye.httpclientandroidlib.util.Args;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;

@NotThreadSafe
class CombinedEntity
extends AbstractHttpEntity {
    private final Resource resource;
    private final InputStream combinedStream;

    CombinedEntity(Resource resource, InputStream inputStream) throws IOException {
        this.resource = resource;
        this.combinedStream = new SequenceInputStream(new ResourceStream(resource.getInputStream()), inputStream);
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return this.combinedStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Args.notNull(outputStream, "Output stream");
        try (InputStream inputStream = this.getContent();){
            int n;
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
    }

    private void dispose() {
        this.resource.dispose();
    }

    class ResourceStream
    extends FilterInputStream {
        protected ResourceStream(InputStream inputStream) {
            super(inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                CombinedEntity.this.dispose();
            }
        }
    }
}

