/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.util.Log;
import android.view.View;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.AnchoredPopup;
import org.mozilla.gecko.widget.DoorHanger;
import org.mozilla.gecko.widget.DoorhangerConfig;

public class DoorHangerPopup
extends AnchoredPopup
implements GeckoEventListener,
Tabs.OnTabsChangedListener,
DoorHanger.OnButtonClickListener {
    private static final String LOGTAG = "GeckoDoorHangerPopup";
    private final HashSet<DoorHanger> mDoorHangers = new HashSet();
    private boolean mDisabled;

    public DoorHangerPopup(Context context) {
        super(context);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Doorhanger:Add", "Doorhanger:Remove");
        Tabs.registerOnTabsChangedListener(this);
    }

    void destroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Doorhanger:Add", "Doorhanger:Remove");
        Tabs.unregisterOnTabsChangedListener(this);
    }

    void disable() {
        this.mDisabled = true;
        this.updatePopup();
    }

    void enable() {
        this.mDisabled = false;
        this.updatePopup();
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Doorhanger:Add")) {
                final DoorhangerConfig doorhangerConfig = this.makeConfigFromJSON(jSONObject);
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DoorHangerPopup.this.addDoorHanger(doorhangerConfig);
                    }
                });
            } else if (string2.equals("Doorhanger:Remove")) {
                final int n = jSONObject.getInt("tabID");
                final String string3 = jSONObject.getString("value");
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DoorHanger doorHanger = DoorHangerPopup.this.getDoorHanger(n, string3);
                        if (doorHanger == null) {
                            return;
                        }
                        DoorHangerPopup.this.removeDoorHanger(doorHanger);
                        DoorHangerPopup.this.updatePopup();
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    private DoorhangerConfig makeConfigFromJSON(JSONObject jSONObject) throws JSONException {
        int n = jSONObject.getInt("tabID");
        String string2 = jSONObject.getString("value");
        String string3 = jSONObject.optString("category");
        boolean bl = DoorHanger.Type.LOGIN.toString().equals(string3);
        DoorHanger.Type type = bl ? DoorHanger.Type.LOGIN : DoorHanger.Type.DEFAULT;
        DoorhangerConfig doorhangerConfig = new DoorhangerConfig(n, string2, type, this);
        doorhangerConfig.setMessage(jSONObject.getString("message"));
        doorhangerConfig.setOptions(jSONObject.getJSONObject("options"));
        JSONArray jSONArray = jSONObject.getJSONArray("buttons");
        int n2 = jSONArray.length();
        if (n2 > 2) {
            Log.e((String)LOGTAG, (String)"Doorhanger can have a maximum of two buttons!");
            n2 = 2;
        }
        for (int i = 0; i < n2; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            boolean bl2 = jSONObject2.optBoolean("positive", false);
            doorhangerConfig.setButton(jSONObject2.getString("label"), jSONObject2.getInt("callback"), bl2);
        }
        return doorhangerConfig;
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case CLOSED: {
                HashSet<DoorHanger> hashSet = new HashSet<DoorHanger>();
                for (DoorHanger doorHanger : this.mDoorHangers) {
                    if (doorHanger.getTabId() != tab.getId()) continue;
                    hashSet.add(doorHanger);
                }
                for (DoorHanger doorHanger : hashSet) {
                    this.removeDoorHanger(doorHanger);
                }
                break;
            }
            case LOCATION_CHANGE: {
                if (!this.isShowing() || !object.equals(tab.getURL())) {
                    this.removeTransientDoorHangers(tab.getId());
                }
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updatePopup();
                break;
            }
            case SELECTED: {
                this.updatePopup();
            }
        }
    }

    void addDoorHanger(DoorhangerConfig doorhangerConfig) {
        int n = doorhangerConfig.getTabId();
        if (Tabs.getInstance().getTab(n) == null) {
            return;
        }
        DoorHanger doorHanger = this.getDoorHanger(n, doorhangerConfig.getId());
        if (doorHanger != null) {
            this.removeDoorHanger(doorHanger);
        }
        if (!this.mInflated) {
            this.init();
        }
        DoorHanger doorHanger2 = DoorHanger.Get(this.mContext, doorhangerConfig);
        this.mDoorHangers.add(doorHanger2);
        this.mContent.addView((View)doorHanger2);
        if (n == Tabs.getInstance().getSelectedTab().getId()) {
            this.updatePopup();
        }
    }

    @Override
    public void onButtonClick(JSONObject jSONObject, DoorHanger doorHanger) {
        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Doorhanger:Reply", jSONObject.toString());
        GeckoAppShell.sendEventToGecko(geckoEvent);
        this.removeDoorHanger(doorHanger);
        this.updatePopup();
    }

    DoorHanger getDoorHanger(int n, String string2) {
        for (DoorHanger doorHanger : this.mDoorHangers) {
            if (doorHanger.getTabId() != n || !doorHanger.getIdentifier().equals(string2)) continue;
            return doorHanger;
        }
        return null;
    }

    void removeDoorHanger(DoorHanger doorHanger) {
        this.mDoorHangers.remove((Object)doorHanger);
        this.mContent.removeView((View)doorHanger);
    }

    void removeTransientDoorHangers(int n) {
        HashSet<DoorHanger> hashSet = new HashSet<DoorHanger>();
        for (DoorHanger doorHanger : this.mDoorHangers) {
            if (doorHanger.getTabId() != n || !doorHanger.shouldRemove(this.isShowing())) continue;
            hashSet.add(doorHanger);
        }
        for (DoorHanger doorHanger : hashSet) {
            this.removeDoorHanger(doorHanger);
        }
    }

    void updatePopup() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null || this.mDoorHangers.size() == 0 || !this.mInflated || this.mDisabled) {
            this.dismiss();
            return;
        }
        int n = tab.getId();
        boolean bl = false;
        for (DoorHanger doorHanger : this.mDoorHangers) {
            if (doorHanger.getTabId() == n) {
                doorHanger.setVisibility(0);
                bl = true;
                continue;
            }
            doorHanger.setVisibility(8);
        }
        if (!bl) {
            this.dismiss();
            return;
        }
        this.showDividers();
        if (this.isShowing()) {
            this.show();
            return;
        }
        if (AppConstants.Versions.feature14Plus) {
            this.setFocusable(true);
        }
        this.show();
        if (AppConstants.Versions.preICS) {
            this.setFocusable(true);
        }
    }

    private void showDividers() {
        int n = this.mContent.getChildCount();
        DoorHanger doorHanger = null;
        for (int i = 0; i < n; ++i) {
            DoorHanger doorHanger2 = (DoorHanger)this.mContent.getChildAt(i);
            doorHanger2.showDivider();
            if (doorHanger2.getVisibility() != 0) continue;
            doorHanger = doorHanger2;
        }
        if (doorHanger != null) {
            doorHanger.hideDivider();
        }
    }

    @Override
    public void dismiss() {
        this.setFocusable(false);
        super.dismiss();
    }
}

