/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.SharedBrowserDatabaseProvider;

public class ReadingListProvider
extends SharedBrowserDatabaseProvider {
    private static final String LOGTAG = "GeckoRLProvider";
    static final String TABLE_READING_LIST = "reading_list";
    static final int ITEMS = 101;
    static final int ITEMS_ID = 102;
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    public static final String PLACEHOLDER_THIS_DEVICE = "$local";
    private static final ContentValues DELETED_VALUES;

    public int updateOrInsertItem(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        if (!contentValues.containsKey("client_last_modified")) {
            contentValues.put("client_last_modified", Long.valueOf(System.currentTimeMillis()));
        }
        if (ReadingListProvider.isCallerSync(uri)) {
            int n = this.updateItemsWithFlags(uri, contentValues, null, string2, stringArray);
            if (n > 0) {
                return n;
            }
            return this.insertItem(uri, contentValues) != -1L ? 1 : 0;
        }
        ContentValues contentValues2 = this.processChangeValues(contentValues);
        int n = this.updateItemsWithFlags(uri, contentValues, contentValues2, string2, stringArray);
        if (n <= 0) {
            contentValues.put("sync_status", Integer.valueOf(1));
            contentValues.put("sync_change_flags", Integer.valueOf(0));
            n = this.insertItem(uri, contentValues) != -1L ? 1 : 0;
        }
        return n;
    }

    private ContentValues processChangeValues(ContentValues contentValues) {
        if (contentValues == null || contentValues.size() == 0) {
            return null;
        }
        ContentValues contentValues2 = new ContentValues();
        int n = 0;
        if (contentValues.containsKey("marked_read_by") || contentValues.containsKey("marked_read_on") || contentValues.containsKey("is_unread")) {
            n |= 1;
        }
        if (contentValues.containsKey("is_favorite")) {
            n |= 2;
        }
        if (contentValues.containsKey("resolved_url") || contentValues.containsKey("resolved_title") || contentValues.containsKey("excerpt")) {
            n |= 4;
        }
        if (n == 0) {
            return null;
        }
        contentValues2.put("sync_change_flags", Integer.valueOf(n));
        return contentValues2;
    }

    public int updateItemsWithFlags(Uri uri, ContentValues contentValues, ContentValues contentValues2, String string2, String[] stringArray) {
        ReadingListProvider.trace("Updating ReadingListItems on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (!contentValues.containsKey("client_last_modified")) {
            contentValues.put("client_last_modified", Long.valueOf(System.currentTimeMillis()));
        }
        if (contentValues2 == null) {
            return sQLiteDatabase.update(TABLE_READING_LIST, contentValues, string2, stringArray);
        }
        ContentValues contentValues3 = new ContentValues();
        contentValues3.put("sync_status", "CASE sync_status WHEN 0 THEN 3 ELSE sync_status END");
        ContentValues[] contentValuesArray = new ContentValues[]{contentValues, contentValues2, contentValues3};
        DBUtils.UpdateOperation[] updateOperationArray = new DBUtils.UpdateOperation[]{DBUtils.UpdateOperation.ASSIGN, DBUtils.UpdateOperation.BITWISE_OR, DBUtils.UpdateOperation.EXPRESSION};
        return DBUtils.updateArrays(sQLiteDatabase, TABLE_READING_LIST, contentValuesArray, updateOperationArray, string2, stringArray);
    }

    private long insertItem(Uri uri, ContentValues contentValues) {
        if (!contentValues.containsKey("client_last_modified")) {
            contentValues.put("client_last_modified", Long.valueOf(System.currentTimeMillis()));
        }
        if (!ReadingListProvider.isCallerSync(uri)) {
            contentValues.put("sync_status", Integer.valueOf(1));
            if (!contentValues.containsKey("added_on")) {
                contentValues.put("added_on", Long.valueOf(System.currentTimeMillis()));
            }
            if (!contentValues.containsKey("added_by")) {
                contentValues.put("added_by", PLACEHOLDER_THIS_DEVICE);
            }
        }
        String string2 = contentValues.getAsString("url");
        ReadingListProvider.debug("Inserting item in database with URL: " + string2);
        try {
            return this.getWritableDatabase(uri).insertOrThrow(TABLE_READING_LIST, null, contentValues);
        }
        catch (SQLException sQLException) {
            Log.e((String)LOGTAG, (String)"Insert failed.", (Throwable)sQLException);
            throw sQLException;
        }
    }

    int deleteItems(Uri uri, String string2, String[] stringArray) {
        ReadingListProvider.debug("Deleting item entry for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (ReadingListProvider.isCallerSync(uri)) {
            ReadingListProvider.debug("Directly deleting from reading list.");
            return sQLiteDatabase.delete(TABLE_READING_LIST, string2, stringArray);
        }
        int n = 0;
        String string3 = DBUtils.concatenateWhere(string2, "guid IS NULL");
        String string4 = DBUtils.concatenateWhere(string2, "guid IS NOT NULL");
        n += sQLiteDatabase.delete(TABLE_READING_LIST, string3, stringArray);
        return n += this.updateItemsWithFlags(uri, DELETED_VALUES, null, string4, stringArray);
    }

    int deleteItemByID(Uri uri, long l) {
        ReadingListProvider.debug("Deleting item entry for ID: " + l);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (ReadingListProvider.isCallerSync(uri)) {
            ReadingListProvider.debug("Directly deleting from reading list.");
            String string2 = "_id = " + l;
            return sQLiteDatabase.delete(TABLE_READING_LIST, string2, null);
        }
        String string3 = "_id = " + l + " AND " + "guid" + " IS NULL";
        int n = sQLiteDatabase.delete(TABLE_READING_LIST, string3, null);
        if (n > 0) {
            return n;
        }
        String string4 = "_id = " + l + " AND " + "guid" + " IS NOT NULL";
        ContentValues contentValues = new ContentValues(DELETED_VALUES);
        contentValues.put("client_last_modified", Long.valueOf(System.currentTimeMillis()));
        return this.updateItemsWithFlags(uri, contentValues, null, string4, null);
    }

    @Override
    public int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        ReadingListProvider.trace("Calling update in transaction on URI: " + uri);
        int n = 0;
        int n2 = URI_MATCHER.match(uri);
        switch (n2) {
            case 102: {
                ReadingListProvider.debug("Update on ITEMS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "reading_list._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 101: {
                ReadingListProvider.debug("Updating ITEMS: " + uri);
                if (ReadingListProvider.shouldUpdateOrInsert(uri)) {
                    n = this.updateOrInsertItem(uri, contentValues, string2, stringArray);
                    break;
                }
                ContentValues contentValues2 = ReadingListProvider.isCallerSync(uri) ? null : this.processChangeValues(contentValues);
                n = this.updateItemsWithFlags(uri, contentValues, contentValues2, string2, stringArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        ReadingListProvider.debug("Updated " + n + " rows for URI: " + uri);
        return n;
    }

    @Override
    public int deleteInTransaction(Uri uri, String string2, String[] stringArray) {
        ReadingListProvider.trace("Calling delete in transaction on URI: " + uri);
        this.cleanUpSomeDeletedRecords(uri, TABLE_READING_LIST);
        int n = 0;
        int n2 = URI_MATCHER.match(uri);
        switch (n2) {
            case 102: {
                ReadingListProvider.debug("Deleting on ITEMS_ID: " + uri);
                n = this.deleteItemByID(uri, ContentUris.parseId((Uri)uri));
                break;
            }
            case 101: {
                ReadingListProvider.debug("Deleting ITEMS: " + uri);
                n = this.deleteItems(uri, string2, stringArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        ReadingListProvider.debug("Deleted " + n + " rows for URI: " + uri);
        return n;
    }

    @Override
    public Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        ReadingListProvider.trace("Calling insert in transaction on URI: " + uri);
        long l = -1L;
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                ReadingListProvider.trace("Insert on ITEMS: " + uri);
                l = this.insertItem(uri, contentValues);
                break;
            }
            default: {
                Log.e((String)LOGTAG, (String)("Unknown insert URI " + uri));
                throw new UnsupportedOperationException("Unknown insert URI " + uri);
            }
        }
        ReadingListProvider.debug("Inserted ID in database: " + l);
        if (l >= 0L) {
            return ContentUris.withAppendedId((Uri)uri, (long)l);
        }
        Log.e((String)LOGTAG, (String)"Got to end of insertInTransaction without returning an id!");
        return null;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        String string4 = null;
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(uri);
        SQLiteQueryBuilder sQLiteQueryBuilder = new SQLiteQueryBuilder();
        String string5 = uri.getQueryParameter("limit");
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 102: {
                ReadingListProvider.trace("Query on ITEMS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 101: {
                ReadingListProvider.trace("Query on ITEMS: " + uri);
                if (ReadingListProvider.shouldShowDeleted(uri)) break;
                string2 = DBUtils.concatenateWhere("is_deleted = 0", string2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri);
            }
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = "client_last_modified DESC";
        }
        ReadingListProvider.trace("Running built query.");
        sQLiteQueryBuilder.setTables(TABLE_READING_LIST);
        Cursor cursor = sQLiteQueryBuilder.query(sQLiteDatabase, stringArray, string2, stringArray2, string4, null, string3, string5);
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    public String getType(Uri uri) {
        ReadingListProvider.trace("Getting URI type: " + uri);
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                ReadingListProvider.trace("URI is ITEMS: " + uri);
                return "vnd.android.cursor.dir/readinglistitem";
            }
            case 102: {
                ReadingListProvider.trace("URI is ITEMS_ID: " + uri);
                return "vnd.android.cursor.item/readinglistitem";
            }
        }
        ReadingListProvider.debug("URI has unrecognized type: " + uri);
        return null;
    }

    @Override
    protected String getDeletedItemSelection(long l) {
        if (l == -1L) {
            return "is_deleted = 1";
        }
        return "is_deleted = 1 AND client_last_modified <= " + l;
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.readinglist", "items", 101);
        URI_MATCHER.addURI("org.mozilla.fennec.db.readinglist", "items/#", 102);
        ContentValues contentValues = new ContentValues();
        contentValues.put("is_deleted", Integer.valueOf(1));
        contentValues.put("url", "");
        contentValues.putNull("resolved_url");
        contentValues.putNull("resolved_title");
        contentValues.putNull("title");
        contentValues.putNull("excerpt");
        contentValues.putNull("added_by");
        contentValues.putNull("marked_read_by");
        contentValues.put("sync_status", Integer.valueOf(2));
        contentValues.put("sync_change_flags", Integer.valueOf(0));
        DELETED_VALUES = contentValues;
    }
}

