/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.firstrun;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;
import java.util.List;
import org.mozilla.gecko.animation.TransitionsTracker;
import org.mozilla.gecko.firstrun.FirstrunPagerConfig;
import org.mozilla.gecko.firstrun.FirstrunPane;
import org.mozilla.gecko.firstrun.FirstrunPanel;

public class FirstrunPager
extends ViewPager {
    private Context context;
    protected FirstrunPane.OnFinishListener listener;

    public FirstrunPager(Context context) {
        this(context, null);
    }

    public FirstrunPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context;
    }

    public void load(FragmentManager fragmentManager, FirstrunPane.OnFinishListener onFinishListener) {
        this.setAdapter((PagerAdapter)new ViewPagerAdapter(fragmentManager, FirstrunPagerConfig.getDefault()));
        this.listener = onFinishListener;
        this.animateLoad();
    }

    public void hide() {
        this.setAdapter(null);
    }

    private void animateLoad() {
        ViewHelper.setTranslationY((View)this, (float)500.0f);
        ViewHelper.setAlpha((View)this, (float)0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setStartDelay(200L);
        objectAnimator2.setDuration(600L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator2, objectAnimator});
        animatorSet.setStartDelay(400L);
        TransitionsTracker.track((Animator)animatorSet);
        animatorSet.start();
    }

    private class ViewPagerAdapter
    extends FragmentPagerAdapter {
        private List<FirstrunPagerConfig.FirstrunPanel> panels;

        public ViewPagerAdapter(FragmentManager fragmentManager, List<FirstrunPagerConfig.FirstrunPanel> list) {
            super(fragmentManager);
            this.panels = list;
        }

        public Fragment getItem(int n) {
            Fragment fragment = Fragment.instantiate((Context)FirstrunPager.this.context, (String)this.panels.get(n).getClassname());
            ((FirstrunPanel)fragment).setOnFinishListener(FirstrunPager.this.listener);
            return fragment;
        }

        public int getCount() {
            return this.panels.size();
        }

        public CharSequence getPageTitle(int n) {
            return FirstrunPager.this.context.getString(this.panels.get(n).getTitleRes()).toUpperCase();
        }
    }
}

