/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.menu.MenuItemActionView;
import org.mozilla.gecko.prompts.IntentChooserPrompt;
import org.mozilla.gecko.prompts.IntentHandler;
import org.mozilla.gecko.prompts.PromptListItem;
import org.mozilla.gecko.widget.GeckoActionProvider;

public class PromptListAdapter
extends ArrayAdapter<PromptListItem> {
    private static final int VIEW_TYPE_ITEM = 0;
    private static final int VIEW_TYPE_GROUP = 1;
    private static final int VIEW_TYPE_ACTIONS = 2;
    private static final int VIEW_TYPE_COUNT = 3;
    private static final String LOGTAG = "GeckoPromptListAdapter";
    private final int mResourceId;
    private Drawable mBlankDrawable;
    private Drawable mMoreDrawable;
    private static int mGroupPaddingSize;
    private static int mLeftRightTextWithIconPadding;
    private static int mTopBottomTextWithIconPadding;
    private static int mIconSize;
    private static int mMinRowSize;
    private static int mIconTextPadding;
    private static float mTextSize;
    private static boolean mInitialized;

    PromptListAdapter(Context context, int n, PromptListItem[] promptListItemArray) {
        super(context, n, (Object[])promptListItemArray);
        this.mResourceId = n;
        this.init();
    }

    private void init() {
        if (!mInitialized) {
            Resources resources = this.getContext().getResources();
            mGroupPaddingSize = (int)resources.getDimension(R.dimen.prompt_service_group_padding_size);
            mLeftRightTextWithIconPadding = (int)resources.getDimension(R.dimen.prompt_service_left_right_text_with_icon_padding);
            mTopBottomTextWithIconPadding = (int)resources.getDimension(R.dimen.prompt_service_top_bottom_text_with_icon_padding);
            mIconTextPadding = (int)resources.getDimension(R.dimen.prompt_service_icon_text_padding);
            mIconSize = (int)resources.getDimension(R.dimen.prompt_service_icon_size);
            mMinRowSize = (int)resources.getDimension(R.dimen.menu_item_row_height);
            mTextSize = resources.getDimension(R.dimen.menu_item_textsize);
            mInitialized = true;
        }
    }

    public int getItemViewType(int n) {
        PromptListItem promptListItem = (PromptListItem)this.getItem(n);
        if (promptListItem.isGroup) {
            return 1;
        }
        if (promptListItem.showAsActions) {
            return 2;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 3;
    }

    private Drawable getMoreDrawable(Resources resources) {
        if (this.mMoreDrawable == null) {
            this.mMoreDrawable = resources.getDrawable(R.drawable.menu_item_more);
        }
        return this.mMoreDrawable;
    }

    private Drawable getBlankDrawable(Resources resources) {
        if (this.mBlankDrawable == null) {
            this.mBlankDrawable = resources.getDrawable(R.drawable.blank);
        }
        return this.mBlankDrawable;
    }

    public void toggleSelected(int n) {
        PromptListItem promptListItem;
        promptListItem.setSelected(!(promptListItem = (PromptListItem)this.getItem(n)).getSelected());
    }

    private void maybeUpdateIcon(PromptListItem promptListItem, TextView textView) {
        Bitmap bitmap;
        if (promptListItem.getIcon() == null && !promptListItem.inGroup && !promptListItem.isParent) {
            textView.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
            return;
        }
        Drawable drawable2 = null;
        Resources resources = this.getContext().getResources();
        textView.setCompoundDrawablePadding(mIconTextPadding);
        if (promptListItem.getIcon() != null) {
            bitmap = ((BitmapDrawable)promptListItem.getIcon()).getBitmap();
            drawable2 = new BitmapDrawable(resources, Bitmap.createScaledBitmap((Bitmap)bitmap, (int)mIconSize, (int)mIconSize, (boolean)true));
        } else if (promptListItem.inGroup) {
            drawable2 = this.getBlankDrawable(resources);
        }
        bitmap = null;
        if (promptListItem.isParent) {
            bitmap = this.getMoreDrawable(resources);
        }
        if (drawable2 != null || bitmap != null) {
            textView.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, (Drawable)bitmap, null);
        }
    }

    private void maybeUpdateCheckedState(ListView listView, int n, PromptListItem promptListItem, ViewHolder viewHolder) {
        viewHolder.textView.setEnabled(!promptListItem.disabled && !promptListItem.isGroup);
        viewHolder.textView.setClickable(promptListItem.isGroup || promptListItem.disabled);
        if (viewHolder.textView instanceof CheckedTextView) {
            listView.setItemChecked(n, promptListItem.getSelected());
        }
    }

    boolean isSelected(int n) {
        return ((PromptListItem)this.getItem(n)).getSelected();
    }

    ArrayList<Integer> getSelected() {
        int n = this.getCount();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (!this.isSelected(i)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    int getSelectedIndex() {
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            if (!this.isSelected(i)) continue;
            return i;
        }
        return -1;
    }

    private View getActionView(PromptListItem promptListItem, final ListView listView, final int n) {
        GeckoActionProvider geckoActionProvider = GeckoActionProvider.getForType(promptListItem.getIntent().getType(), this.getContext());
        geckoActionProvider.setIntent(promptListItem.getIntent());
        final MenuItemActionView menuItemActionView = (MenuItemActionView)geckoActionProvider.onCreateActionView(GeckoActionProvider.ActionViewType.CONTEXT_MENU);
        menuItemActionView.addActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AdapterView.OnItemClickListener onItemClickListener = listView.getOnItemClickListener();
                if (onItemClickListener != null) {
                    onItemClickListener.onItemClick((AdapterView)listView, (View)menuItemActionView, n, (long)n);
                }
            }
        });
        return menuItemActionView;
    }

    private void updateActionView(final PromptListItem promptListItem, final MenuItemActionView menuItemActionView, final ListView listView, final int n) {
        menuItemActionView.setTitle(promptListItem.label);
        menuItemActionView.setIcon(promptListItem.getIcon());
        menuItemActionView.setSubMenuIndicator(promptListItem.isParent);
        menuItemActionView.setMenuItemClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AdapterView.OnItemClickListener onItemClickListener = listView.getOnItemClickListener();
                if (onItemClickListener != null) {
                    onItemClickListener.onItemClick((AdapterView)listView, (View)menuItemActionView, n, (long)n);
                }
                final GeckoActionProvider geckoActionProvider = GeckoActionProvider.getForType(promptListItem.getIntent().getType(), PromptListAdapter.this.getContext());
                IntentChooserPrompt intentChooserPrompt = new IntentChooserPrompt(PromptListAdapter.this.getContext(), geckoActionProvider);
                intentChooserPrompt.show(promptListItem.label, PromptListAdapter.this.getContext(), new IntentHandler(){

                    @Override
                    public void onIntentSelected(Intent intent, int n) {
                        geckoActionProvider.chooseActivity(n);
                        Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST);
                    }

                    @Override
                    public void onCancelled() {
                    }
                });
            }
        });
    }

    public View getView(int n, View view, ViewGroup viewGroup) {
        PromptListItem promptListItem = (PromptListItem)this.getItem(n);
        int n2 = this.getItemViewType(n);
        ViewHolder viewHolder = null;
        if (view == null) {
            if (n2 == 2) {
                view = this.getActionView(promptListItem, (ListView)viewGroup, n);
            } else {
                int n3 = this.mResourceId;
                if (promptListItem.isGroup) {
                    n3 = R.layout.list_item_header;
                }
                LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
                view = layoutInflater.inflate(n3, null);
                view.setMinimumHeight(mMinRowSize);
                TextView textView = (TextView)view.findViewById(16908308);
                textView.setTextSize(0, mTextSize);
                viewHolder = new ViewHolder(textView, textView.getPaddingLeft(), textView.getPaddingRight(), textView.getPaddingTop(), textView.getPaddingBottom());
                view.setTag((Object)viewHolder);
            }
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        if (n2 == 2) {
            this.updateActionView(promptListItem, (MenuItemActionView)view, (ListView)viewGroup, n);
        } else {
            viewHolder.textView.setText((CharSequence)promptListItem.label);
            this.maybeUpdateCheckedState((ListView)viewGroup, n, promptListItem, viewHolder);
            this.maybeUpdateIcon(promptListItem, viewHolder.textView);
        }
        return view;
    }

    private static class ViewHolder {
        public final TextView textView;
        public final int paddingLeft;
        public final int paddingRight;
        public final int paddingTop;
        public final int paddingBottom;

        ViewHolder(TextView textView, int n, int n2, int n3, int n4) {
            this.textView = textView;
            this.paddingLeft = n;
            this.paddingRight = n2;
            this.paddingTop = n3;
            this.paddingBottom = n4;
        }
    }
}

