/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.cache.InputLimit;
import ch.boye.httpclientandroidlib.client.cache.Resource;
import ch.boye.httpclientandroidlib.client.cache.ResourceFactory;
import ch.boye.httpclientandroidlib.impl.client.cache.BasicIdGenerator;
import ch.boye.httpclientandroidlib.impl.client.cache.FileResource;
import ch.boye.httpclientandroidlib.impl.client.cache.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

@Immutable
public class FileResourceFactory
implements ResourceFactory {
    private final File cacheDir;
    private final BasicIdGenerator idgen;

    public FileResourceFactory(File file) {
        this.cacheDir = file;
        this.idgen = new BasicIdGenerator();
    }

    private File generateUniqueCacheFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.idgen.generate(stringBuilder);
        stringBuilder.append('.');
        int n = Math.min(string.length(), 100);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('-');
        }
        return new File(this.cacheDir, stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource generate(String string, InputStream inputStream, InputLimit inputLimit) throws IOException {
        File file = this.generateUniqueCacheFile(string);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[2048];
            long l = 0L;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                if (inputLimit == null || (l += (long)n) <= inputLimit.getValue()) continue;
                inputLimit.reached();
                break;
            }
        }
        return new FileResource(file);
    }

    @Override
    public Resource copy(String string, Resource resource) throws IOException {
        File file = this.generateUniqueCacheFile(string);
        if (resource instanceof FileResource) {
            File file2 = ((FileResource)resource).getFile();
            IOUtils.copyFile(file2, file);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            IOUtils.copyAndClose(resource.getInputStream(), fileOutputStream);
        }
        return new FileResource(file);
    }
}

