/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.apache.commons.codec.binary;

import org.mozilla.apache.commons.codec.BinaryDecoder;
import org.mozilla.apache.commons.codec.BinaryEncoder;
import org.mozilla.apache.commons.codec.DecoderException;
import org.mozilla.apache.commons.codec.EncoderException;
import org.mozilla.apache.commons.codec.binary.StringUtils;

public abstract class BaseNCodec
implements BinaryEncoder,
BinaryDecoder {
    public static final int MIME_CHUNK_SIZE = 76;
    public static final int PEM_CHUNK_SIZE = 64;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected final byte PAD = (byte)61;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;
    protected byte[] buffer;
    protected int pos;
    private int readPos;
    protected boolean eof;
    protected int currentLinePos;
    protected int modulus;

    protected BaseNCodec(int n, int n2, int n3, int n4) {
        this.unencodedBlockSize = n;
        this.encodedBlockSize = n2;
        this.lineLength = n3 > 0 && n4 > 0 ? n3 / n2 * n2 : 0;
        this.chunkSeparatorLength = n4;
    }

    boolean hasData() {
        return this.buffer != null;
    }

    int available() {
        return this.buffer != null ? this.pos - this.readPos : 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    private void resizeBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.getDefaultBufferSize()];
            this.pos = 0;
            this.readPos = 0;
        } else {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
    }

    protected void ensureBufferSize(int n) {
        if (this.buffer == null || this.buffer.length < this.pos + n) {
            this.resizeBuffer();
        }
    }

    int readResults(byte[] byArray, int n, int n2) {
        if (this.buffer != null) {
            int n3 = Math.min(this.available(), n2);
            System.arraycopy(this.buffer, this.readPos, byArray, n, n3);
            this.readPos += n3;
            if (this.readPos >= this.pos) {
                this.buffer = null;
            }
            return n3;
        }
        return this.eof ? -1 : 0;
    }

    protected static boolean isWhiteSpace(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private void reset() {
        this.buffer = null;
        this.pos = 0;
        this.readPos = 0;
        this.currentLinePos = 0;
        this.modulus = 0;
        this.eof = false;
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof byte[])) {
            throw new EncoderException("Parameter supplied to Base-N encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    public String encodeToString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    @Override
    public Object decode(Object object) throws DecoderException {
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Parameter supplied to Base-N decode is not a byte[] or a String");
    }

    public byte[] decode(String string) {
        return this.decode(StringUtils.getBytesUtf8(string));
    }

    @Override
    public byte[] decode(byte[] byArray) {
        this.reset();
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        this.decode(byArray, 0, byArray.length);
        this.decode(byArray, 0, -1);
        byte[] byArray2 = new byte[this.pos];
        this.readResults(byArray2, 0, byArray2.length);
        return byArray2;
    }

    @Override
    public byte[] encode(byte[] byArray) {
        this.reset();
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        this.encode(byArray, 0, byArray.length);
        this.encode(byArray, 0, -1);
        byte[] byArray2 = new byte[this.pos - this.readPos];
        this.readResults(byArray2, 0, byArray2.length);
        return byArray2;
    }

    public String encodeAsString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    abstract void encode(byte[] var1, int var2, int var3);

    abstract void decode(byte[] var1, int var2, int var3);

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] byArray, boolean bl) {
        for (int i = 0; i < byArray.length; ++i) {
            if (this.isInAlphabet(byArray[i]) || bl && (byArray[i] == 61 || BaseNCodec.isWhiteSpace(byArray[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean isInAlphabet(String string) {
        return this.isInAlphabet(StringUtils.getBytesUtf8(string), true);
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (61 != byArray[i] && !this.isInAlphabet(byArray[i])) continue;
            return true;
        }
        return false;
    }

    public long getEncodedLength(byte[] byArray) {
        long l = (long)((byArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            l += (l + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return l;
    }
}

