/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.StrictMode;
import android.support.v4.app.FragmentActivity;
import java.util.Locale;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.LocaleManager;

public class Locales {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeLocale(Context context) {
        LocaleManager localeManager = BrowserLocaleManager.getInstance();
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        StrictMode.allowThreadDiskWrites();
        try {
            localeManager.getAndApplyPersistedLocale(context);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    public static String getLanguage(Locale locale) {
        String string2 = locale.getLanguage();
        if (string2.equals("iw")) {
            return "he";
        }
        if (string2.equals("in")) {
            return "id";
        }
        if (string2.equals("ji")) {
            return "yi";
        }
        return string2;
    }

    public static String getLanguageTag(Locale locale) {
        String string2 = Locales.getLanguage(locale);
        String string3 = locale.getCountry();
        if (string3.equals("")) {
            return string2;
        }
        return string2 + "-" + string3;
    }

    public static Locale parseLocaleCode(String string2) {
        int n = string2.indexOf(45);
        if (n != -1 || (n = string2.indexOf(95)) != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            return new Locale(string3, string4);
        }
        return new Locale(string2);
    }

    public static class LocaleAwareActivity
    extends Activity {
        protected void onCreate(Bundle bundle) {
            Locales.initializeLocale(this.getApplicationContext());
            super.onCreate(bundle);
        }
    }

    public static class LocaleAwareFragmentActivity
    extends FragmentActivity {
        protected void onCreate(Bundle bundle) {
            Locales.initializeLocale(this.getApplicationContext());
            super.onCreate(bundle);
        }
    }
}

