/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa.oauth;

import ch.boye.httpclientandroidlib.HttpResponse;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class FxAccountAbstractClientException
extends Exception {
    private static final long serialVersionUID = 1953459541558266597L;

    public FxAccountAbstractClientException(String string2) {
        super(string2);
    }

    public FxAccountAbstractClientException(Exception exception) {
        super(exception);
    }

    public static class FxAccountAbstractClientMalformedResponseException
    extends FxAccountAbstractClientRemoteException {
        private static final long serialVersionUID = 1209313149952001098L;

        public FxAccountAbstractClientMalformedResponseException(HttpResponse httpResponse) {
            super(httpResponse, 0L, 999L, "Response malformed", "Response malformed", new ExtendedJSONObject());
        }
    }

    public static class FxAccountAbstractClientRemoteException
    extends FxAccountAbstractClientException {
        private static final long serialVersionUID = 1209313149952001097L;
        public final HttpResponse response;
        public final long httpStatusCode;
        public final long apiErrorNumber;
        public final String error;
        public final String message;
        public final ExtendedJSONObject body;

        public FxAccountAbstractClientRemoteException(HttpResponse httpResponse, long l, long l2, String string2, String string3, ExtendedJSONObject extendedJSONObject) {
            super(new HTTPFailureException(new SyncStorageResponse(httpResponse)));
            if (extendedJSONObject == null) {
                throw new IllegalArgumentException("body must not be null");
            }
            this.response = httpResponse;
            this.httpStatusCode = l;
            this.apiErrorNumber = l2;
            this.error = string2;
            this.message = string3;
            this.body = extendedJSONObject;
        }

        @Override
        public String toString() {
            return "<FxAccountAbstractClientRemoteException " + this.httpStatusCode + " [" + this.apiErrorNumber + "]: " + this.message + ">";
        }

        public boolean isInvalidAuthentication() {
            return this.httpStatusCode == 401L;
        }
    }
}

