/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.preference.ListPreference;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;

public class LocaleListPreference
extends ListPreference {
    private static final String LOG_TAG = "GeckoLocaleList";
    private volatile Locale entriesLocale;
    private final CharacterValidator characterValidator = new CharacterValidator(" ");

    public LocaleListPreference(Context context) {
        this(context, null);
    }

    public LocaleListPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.buildList();
    }

    private LocaleDescriptor[] getUsableLocales() {
        Collection<String> collection = BrowserLocaleManager.getPackagedLocaleTags(this.getContext());
        if (collection == null) {
            String string2 = BrowserLocaleManager.getInstance().getFallbackLocaleTag();
            return new LocaleDescriptor[]{new LocaleDescriptor(string2)};
        }
        int n = collection.size();
        HashSet<LocaleDescriptor> hashSet = new HashSet<LocaleDescriptor>(n);
        for (String objectArray2 : collection) {
            LocaleDescriptor localeDescriptor = new LocaleDescriptor(objectArray2);
            if (!localeDescriptor.isUsable(this.characterValidator)) {
                Log.w((String)LOG_TAG, (String)("Skipping locale " + objectArray2 + " on this device."));
                continue;
            }
            hashSet.add(localeDescriptor);
        }
        int n2 = hashSet.size();
        Object[] objectArray = hashSet.toArray(new LocaleDescriptor[n2]);
        Arrays.sort(objectArray, 0, n2);
        return objectArray;
    }

    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        Locale locale = this.getSelectedLocale();
        Context context = this.getContext();
        BrowserLocaleManager.getInstance().updateConfiguration(context, locale);
    }

    private Locale getSelectedLocale() {
        String string2 = this.getValue();
        if (string2 == null || string2.equals("")) {
            return Locale.getDefault();
        }
        return Locales.parseLocaleCode(string2);
    }

    public CharSequence getSummary() {
        String string2 = this.getValue();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return this.getContext().getString(R.string.locale_system_default);
        }
        return new LocaleDescriptor(string2).getDisplayName();
    }

    private void buildList() {
        Locale locale = Locale.getDefault();
        Log.d((String)LOG_TAG, (String)("Building locales list. Current locale: " + locale));
        if (locale.equals(this.entriesLocale) && this.getEntries() != null) {
            Log.v((String)LOG_TAG, (String)"No need to build list.");
            return;
        }
        LocaleDescriptor[] localeDescriptorArray = this.getUsableLocales();
        int n = localeDescriptorArray.length;
        this.entriesLocale = locale;
        CharSequence[] charSequenceArray = new String[n + 1];
        CharSequence[] charSequenceArray2 = new String[n + 1];
        charSequenceArray[0] = this.getContext().getString(R.string.locale_system_default);
        charSequenceArray2[0] = "";
        for (int i = 0; i < n; ++i) {
            String string2 = localeDescriptorArray[i].getDisplayName();
            String string3 = localeDescriptorArray[i].getTag();
            Log.v((String)LOG_TAG, (String)(string2 + " => " + string3));
            charSequenceArray[i + 1] = string2;
            charSequenceArray2[i + 1] = string3;
        }
        this.setEntries(charSequenceArray);
        this.setEntryValues(charSequenceArray2);
    }

    private static final class LocaleDescriptor
    implements Comparable<LocaleDescriptor> {
        private static final Collator COLLATOR = Collator.getInstance(Locale.US);
        public final String tag;
        private final String nativeName;

        public LocaleDescriptor(String string2) {
            this(Locales.parseLocaleCode(string2), string2);
        }

        public LocaleDescriptor(Locale locale, String string2) {
            this.tag = string2;
            String string3 = locale.getDisplayName(locale);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                Log.w((String)LocaleListPreference.LOG_TAG, (String)("Display name is empty. Using " + locale.toString()));
                this.nativeName = locale.toString();
                return;
            }
            byte by = Character.getDirectionality(string3.charAt(0));
            if (by == 0) {
                this.nativeName = string3.substring(0, 1).toUpperCase(locale) + string3.substring(1);
                return;
            }
            this.nativeName = string3;
        }

        public String getTag() {
            return this.tag;
        }

        public String getDisplayName() {
            return this.nativeName;
        }

        public String toString() {
            return this.nativeName;
        }

        @Override
        public int compareTo(LocaleDescriptor localeDescriptor) {
            return COLLATOR.compare(this.nativeName, localeDescriptor.nativeName);
        }

        public boolean isUsable(CharacterValidator characterValidator) {
            if (AppConstants.Versions.preLollipop && this.tag.matches("[a-zA-Z]{3}.*")) {
                return false;
            }
            if (this.tag.equals("bn-IN") && !this.nativeName.startsWith("\u09ac\u09be\u0982\u09b2\u09be")) {
                return false;
            }
            return !this.tag.equals("or") && !this.tag.equals("my") && !this.tag.equals("pa-IN") && !this.tag.equals("gu-IN") && !this.tag.equals("bn-IN") || !characterValidator.characterIsMissingInFont(this.nativeName.substring(0, 1));
        }
    }

    private static class CharacterValidator {
        private static final int BITMAP_WIDTH = 32;
        private static final int BITMAP_HEIGHT = 48;
        private final Paint paint = new Paint();
        private final byte[] missingCharacter;

        public CharacterValidator(String string2) {
            this.missingCharacter = CharacterValidator.getPixels(this.drawBitmap(string2));
        }

        private Bitmap drawBitmap(String string2) {
            Bitmap bitmap = Bitmap.createBitmap((int)32, (int)48, (Bitmap.Config)Bitmap.Config.ALPHA_8);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawText(string2, 0.0f, 24.0f, this.paint);
            return bitmap;
        }

        private static byte[] getPixels(Bitmap bitmap) {
            int n = AppConstants.Versions.feature19Plus ? bitmap.getAllocationByteCount() : bitmap.getRowBytes() * bitmap.getHeight();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            try {
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            }
            catch (RuntimeException runtimeException) {
                if ("Buffer not large enough for pixels".equals(runtimeException.getMessage())) {
                    return byteBuffer.array();
                }
                throw runtimeException;
            }
            return byteBuffer.array();
        }

        public boolean characterIsMissingInFont(String string2) {
            byte[] byArray = CharacterValidator.getPixels(this.drawBitmap(string2));
            return Arrays.equals(byArray, this.missingCharacter);
        }
    }
}

