/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sqlite;

import android.database.AbstractCursor;
import android.database.CursorIndexOutOfBoundsException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;

public class MatrixBlobCursor
extends AbstractCursor {
    private static final String LOGTAG = "GeckoMatrixCursor";
    private final String[] columnNames;
    private final int columnCount;
    private int rowCount;
    private Throwable allocationStack;
    Object[] data;

    @WrapElementForJNI
    public MatrixBlobCursor(String[] stringArray, int n) {
        this.columnNames = stringArray;
        this.columnCount = stringArray.length;
        if (n < 1) {
            n = 1;
        }
        this.data = new Object[this.columnCount * n];
    }

    @WrapElementForJNI
    public MatrixBlobCursor(String[] stringArray) {
        this(stringArray, 16);
    }

    public void close() {
        this.allocationStack = null;
        this.data = null;
        super.close();
    }

    protected Object get(int n) {
        if (n < 0 || n >= this.columnCount) {
            throw new CursorIndexOutOfBoundsException("Requested column: " + n + ", # of columns: " + this.columnCount);
        }
        if (this.mPos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first row.");
        }
        if (this.mPos >= this.rowCount) {
            throw new CursorIndexOutOfBoundsException("After last row.");
        }
        return this.data[this.mPos * this.columnCount + n];
    }

    public RowBuilder newRow() {
        ++this.rowCount;
        int n = this.rowCount * this.columnCount;
        this.ensureCapacity(n);
        int n2 = n - this.columnCount;
        return new RowBuilder(n2, n);
    }

    @WrapElementForJNI
    public void addRow(Object[] objectArray) {
        if (objectArray.length != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.length = " + objectArray.length);
        }
        int n = this.rowCount++ * this.columnCount;
        this.ensureCapacity(n + this.columnCount);
        System.arraycopy(objectArray, 0, this.data, n, this.columnCount);
    }

    @WrapElementForJNI
    public void addRow(Iterable<?> iterable) {
        int n = this.rowCount * this.columnCount;
        if (iterable instanceof ArrayList) {
            this.addRow((ArrayList)iterable, n);
            return;
        }
        int n2 = n + this.columnCount;
        int n3 = n;
        this.ensureCapacity(n2);
        Object[] objectArray = this.data;
        for (Object obj : iterable) {
            if (n3 == n2) {
                throw new IllegalArgumentException("columnValues.size() > columnNames.length");
            }
            objectArray[n3++] = obj;
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("columnValues.size() < columnNames.length");
        }
        ++this.rowCount;
    }

    @WrapElementForJNI
    private void addRow(ArrayList<?> arrayList, int n) {
        int n2 = arrayList.size();
        if (n2 != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.size() = " + n2);
        }
        int n3 = n + this.columnCount;
        this.ensureCapacity(n3);
        Object[] objectArray = this.data;
        for (int i = 0; i < n2; ++i) {
            objectArray[n + i] = arrayList.get(i);
        }
        ++this.rowCount;
    }

    private void ensureCapacity(int n) {
        if (n <= this.data.length) {
            return;
        }
        Object[] objectArray = this.data;
        this.data = new Object[Math.max(n, this.data.length * 2)];
        System.arraycopy(objectArray, 0, this.data, 0, objectArray.length);
    }

    public void set(int n, Object object) {
        if (n < 0 || n >= this.columnCount) {
            throw new CursorIndexOutOfBoundsException("Requested column: " + n + ", # of columns: " + this.columnCount);
        }
        if (this.mPos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first row.");
        }
        if (this.mPos >= this.rowCount) {
            throw new CursorIndexOutOfBoundsException("After last row.");
        }
        this.data[this.mPos * this.columnCount + n] = object;
    }

    public int getCount() {
        return this.rowCount;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getString(int n) {
        Object object = this.get(n);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public short getShort(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        return Short.parseShort(object.toString());
    }

    public int getInt(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return Integer.parseInt(object.toString());
    }

    public long getLong(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    public float getFloat(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return Float.parseFloat(object.toString());
    }

    public double getDouble(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.parseDouble(object.toString());
    }

    public byte[] getBlob(int n) {
        Object object = this.get(n);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            return byArray;
        }
        throw new UnsupportedOperationException("BLOB Object not of known type");
    }

    public boolean isNull(int n) {
        return this.get(n) == null;
    }

    protected void finalize() {
        super.finalize();
    }

    public class RowBuilder {
        private int index;
        private final int endIndex;

        RowBuilder(int n, int n2) {
            this.index = n;
            this.endIndex = n2;
        }

        public RowBuilder add(Object object) {
            if (this.index == this.endIndex) {
                throw new CursorIndexOutOfBoundsException("No more columns left.");
            }
            MatrixBlobCursor.this.data[this.index++] = object;
            return this;
        }
    }
}

