/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.receivers;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CredentialException;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.config.ConfigurationMigrator;
import org.mozilla.gecko.sync.setup.SyncAccounts;

public class UpgradeReceiver
extends BroadcastReceiver {
    private static final String LOG_TAG = "UpgradeReceiver";

    public void onReceive(final Context context, Intent intent) {
        Logger.debug(LOG_TAG, "Broadcast received.");
        if (!SyncAccounts.syncAccountsExist(context)) {
            Logger.info(LOG_TAG, "No Sync Accounts found; not upgrading anything.");
            return;
        }
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                Account[] accountArray;
                AccountManager accountManager = AccountManager.get((Context)context);
                for (Account account : accountArray = SyncAccounts.syncAccounts(context)) {
                    if ("1".equals(accountManager.getUserData(account, "data.enableOnUpgrade"))) {
                        SyncAccounts.setSyncAutomatically(account, true);
                        accountManager.setUserData(account, "data.enableOnUpgrade", "0");
                    }
                    if (!"1".equals(accountManager.getUserData(account, "data.shouldBeRemoved"))) continue;
                    accountManager.removeAccount(account, null, null);
                }
            }
        });
        ThreadPool.run(new Runnable(){

            @Override
            public void run() {
                Account[] accountArray;
                AccountManager accountManager = AccountManager.get((Context)context);
                for (Account account : accountArray = SyncAccounts.syncAccounts(context)) {
                    SyncAccounts.SyncAccountParameters syncAccountParameters;
                    Logger.info(UpgradeReceiver.LOG_TAG, "Migrating preferences on upgrade for Android account named " + Utils.obfuscateEmail(account.name) + ".");
                    try {
                        syncAccountParameters = SyncAccounts.blockingFromAndroidAccountV0(context, accountManager, account);
                    }
                    catch (CredentialException credentialException) {
                        Logger.warn(UpgradeReceiver.LOG_TAG, "Caught exception fetching account parameters while trying to migrate preferences; ignoring.", credentialException);
                        continue;
                    }
                    String string2 = syncAccountParameters.username;
                    String string3 = syncAccountParameters.serverURL;
                    try {
                        ConfigurationMigrator.ensurePrefsAreVersion(1L, context, accountManager, account, "org.mozilla.fennec", string2, string3, "default");
                    }
                    catch (Exception exception) {
                        Logger.warn(UpgradeReceiver.LOG_TAG, "Caught exception trying to migrate preferences; ignoring.", exception);
                    }
                }
            }
        });
    }
}

