/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.TextKeyListener;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.SynchronousQueue;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.FormAssistPopup;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEditableClient;
import org.mozilla.gecko.GeckoEditableListener;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.InputMethods;
import org.mozilla.gecko.gfx.InputConnectionHandler;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.ThreadUtils;

class GeckoInputConnection
extends BaseInputConnection
implements InputConnectionHandler,
GeckoEditableListener {
    private static final boolean DEBUG = false;
    protected static final String LOGTAG = "GeckoInputConnection";
    private static final String CUSTOM_HANDLER_TEST_METHOD = "testInputConnection";
    private static final String CUSTOM_HANDLER_TEST_CLASS = "org.mozilla.gecko.tests.components.GeckoViewComponent$TextInput";
    private static final int INLINE_IME_MIN_DISPLAY_SIZE = 480;
    private static Handler sBackgroundHandler;
    private int mIMEState;
    private String mIMETypeHint = "";
    private String mIMEModeHint = "";
    private String mIMEActionHint = "";
    private String mCurrentInputMethod = "";
    private final GeckoEditableClient mEditableClient;
    protected int mBatchEditCount;
    private ExtractedTextRequest mUpdateRequest;
    private final ExtractedText mUpdateExtract = new ExtractedText();
    private boolean mBatchSelectionChanged;
    private boolean mBatchTextChanged;
    private final InputConnection mKeyInputConnection;

    public static GeckoEditableListener create(View view, GeckoEditableClient geckoEditableClient) {
        return new GeckoInputConnection(view, geckoEditableClient);
    }

    protected GeckoInputConnection(View view, GeckoEditableClient geckoEditableClient) {
        super(view, true);
        this.mEditableClient = geckoEditableClient;
        this.mIMEState = 0;
        this.mKeyInputConnection = new BaseInputConnection(view, false);
    }

    public synchronized boolean beginBatchEdit() {
        ++this.mBatchEditCount;
        this.mEditableClient.setUpdateGecko(false);
        return true;
    }

    public synchronized boolean endBatchEdit() {
        if (this.mBatchEditCount > 0) {
            --this.mBatchEditCount;
            if (this.mBatchEditCount == 0) {
                if (this.mBatchTextChanged) {
                    this.notifyTextChange();
                    this.mBatchTextChanged = false;
                }
                if (this.mBatchSelectionChanged) {
                    Editable editable = this.getEditable();
                    this.notifySelectionChange(Selection.getSelectionStart((CharSequence)editable), Selection.getSelectionEnd((CharSequence)editable));
                    this.mBatchSelectionChanged = false;
                }
                this.mEditableClient.setUpdateGecko(true);
            }
        } else {
            Log.w((String)LOGTAG, (String)"endBatchEdit() called, but mBatchEditCount == 0?!");
        }
        return true;
    }

    public Editable getEditable() {
        return this.mEditableClient.getEditable();
    }

    public boolean performContextMenuAction(int n) {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        int n2 = Selection.getSelectionStart((CharSequence)editable);
        int n3 = Selection.getSelectionEnd((CharSequence)editable);
        switch (n) {
            case 16908319: {
                this.setSelection(0, editable.length());
                break;
            }
            case 0x1020020: {
                if (n2 == n3) {
                    Clipboard.setText((CharSequence)editable);
                    editable.clear();
                    break;
                }
                Clipboard.setText((CharSequence)editable.toString().substring(Math.min(n2, n3), Math.max(n2, n3)));
                editable.delete(n2, n3);
                break;
            }
            case 0x1020022: {
                this.commitText(Clipboard.getText(), 1);
                break;
            }
            case 0x1020021: {
                String string2 = n2 == n3 ? "" : editable.toString().substring(Math.min(n2, n3), Math.max(n2, n3));
                Clipboard.setText((CharSequence)string2);
            }
        }
        return true;
    }

    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        Editable editable;
        if (extractedTextRequest == null) {
            return null;
        }
        if ((n & 1) != 0) {
            this.mUpdateRequest = extractedTextRequest;
        }
        if ((editable = this.getEditable()) == null) {
            return null;
        }
        int n2 = Selection.getSelectionStart((CharSequence)editable);
        int n3 = Selection.getSelectionEnd((CharSequence)editable);
        ExtractedText extractedText = new ExtractedText();
        extractedText.flags = 0;
        extractedText.partialStartOffset = -1;
        extractedText.partialEndOffset = -1;
        extractedText.selectionStart = n2;
        extractedText.selectionEnd = n3;
        extractedText.startOffset = 0;
        extractedText.text = (extractedTextRequest.flags & 1) != 0 ? new SpannableString((CharSequence)editable) : editable.toString();
        return extractedText;
    }

    private static View getView() {
        return GeckoAppShell.getLayerView();
    }

    private static InputMethodManager getInputMethodManager() {
        View view = GeckoInputConnection.getView();
        if (view == null) {
            return null;
        }
        Context context = view.getContext();
        return InputMethods.getInputMethodManager(context);
    }

    private static void showSoftInput() {
        InputMethodManager inputMethodManager = GeckoInputConnection.getInputMethodManager();
        if (inputMethodManager != null) {
            View view = GeckoInputConnection.getView();
            inputMethodManager.showSoftInput(view, 0);
        }
    }

    private static void hideSoftInput() {
        InputMethodManager inputMethodManager = GeckoInputConnection.getInputMethodManager();
        if (inputMethodManager != null) {
            View view = GeckoInputConnection.getView();
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    private void restartInput() {
        InputMethodManager inputMethodManager = GeckoInputConnection.getInputMethodManager();
        if (inputMethodManager == null) {
            return;
        }
        View view = GeckoInputConnection.getView();
        if (InputMethods.needsSoftResetWorkaround(this.mCurrentInputMethod)) {
            this.notifySelectionChange(-1, -1);
        }
        inputMethodManager.restartInput(view);
    }

    private void resetInputConnection() {
        if (this.mBatchEditCount != 0) {
            Log.w((String)LOGTAG, (String)("resetting with mBatchEditCount = " + this.mBatchEditCount));
            this.mBatchEditCount = 0;
        }
        this.mBatchSelectionChanged = false;
        this.mBatchTextChanged = false;
    }

    @Override
    public void onTextChange(CharSequence charSequence, int n, int n2, int n3) {
        if (this.mUpdateRequest == null) {
            Editable editable = this.getEditable();
            if (editable != null) {
                this.onSelectionChange(Selection.getSelectionStart((CharSequence)editable), Selection.getSelectionEnd((CharSequence)editable));
            }
            return;
        }
        if (this.mBatchEditCount > 0) {
            this.mBatchTextChanged = true;
            return;
        }
        this.notifyTextChange();
    }

    private void notifyTextChange() {
        InputMethodManager inputMethodManager = GeckoInputConnection.getInputMethodManager();
        View view = GeckoInputConnection.getView();
        Editable editable = this.getEditable();
        if (inputMethodManager == null || view == null || editable == null) {
            return;
        }
        this.mUpdateExtract.flags = 0;
        this.mUpdateExtract.partialStartOffset = -1;
        this.mUpdateExtract.partialEndOffset = -1;
        this.mUpdateExtract.selectionStart = Selection.getSelectionStart((CharSequence)editable);
        this.mUpdateExtract.selectionEnd = Selection.getSelectionEnd((CharSequence)editable);
        this.mUpdateExtract.startOffset = 0;
        this.mUpdateExtract.text = (this.mUpdateRequest.flags & 1) != 0 ? new SpannableString((CharSequence)editable) : editable.toString();
        inputMethodManager.updateExtractedText(view, this.mUpdateRequest.token, this.mUpdateExtract);
    }

    @Override
    public void onSelectionChange(int n, int n2) {
        if (this.mBatchEditCount > 0) {
            this.mBatchSelectionChanged = true;
            return;
        }
        this.notifySelectionChange(n, n2);
    }

    private void notifySelectionChange(int n, int n2) {
        InputMethodManager inputMethodManager = GeckoInputConnection.getInputMethodManager();
        View view = GeckoInputConnection.getView();
        Editable editable = this.getEditable();
        if (inputMethodManager == null || view == null || editable == null) {
            return;
        }
        inputMethodManager.updateSelection(view, n, n2, GeckoInputConnection.getComposingSpanStart((Spannable)editable), GeckoInputConnection.getComposingSpanEnd((Spannable)editable));
    }

    private static synchronized Handler getBackgroundHandler() {
        if (sBackgroundHandler != null) {
            return sBackgroundHandler;
        }
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Looper.prepare();
                Class<GeckoInputConnection> clazz = GeckoInputConnection.class;
                synchronized (GeckoInputConnection.class) {
                    sBackgroundHandler = new Handler();
                    GeckoInputConnection.class.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    Looper.loop();
                    throw new IllegalThreadStateException("unreachable code");
                }
            }
        }, LOGTAG);
        thread.setDaemon(true);
        thread.start();
        while (sBackgroundHandler == null) {
            try {
                GeckoInputConnection.class.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return sBackgroundHandler;
    }

    private boolean canReturnCustomHandler() {
        if (this.mIMEState == 0) {
            return false;
        }
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if ("startInputInner".equals(stackTraceElement.getMethodName()) && "android.view.inputmethod.InputMethodManager".equals(stackTraceElement.getClassName())) {
                return true;
            }
            if (!CUSTOM_HANDLER_TEST_METHOD.equals(stackTraceElement.getMethodName()) || !CUSTOM_HANDLER_TEST_CLASS.equals(stackTraceElement.getClassName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Handler getHandler(Handler handler) {
        if (!this.canReturnCustomHandler()) {
            return handler;
        }
        Handler handler2 = GeckoInputConnection.getBackgroundHandler();
        if (this.mEditableClient.setInputConnectionHandler(handler2)) {
            return handler2;
        }
        return this.mEditableClient.getInputConnectionHandler();
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        FormAssistPopup formAssistPopup;
        if (this.mIMEState == 0) {
            return null;
        }
        editorInfo.inputType = 1;
        editorInfo.imeOptions = 1;
        editorInfo.actionLabel = null;
        if (this.mIMEState == 2 || "password".equalsIgnoreCase(this.mIMETypeHint)) {
            editorInfo.inputType |= 0x80;
        } else if (this.mIMEState == 3) {
            editorInfo.inputType = 0;
        } else if (this.mIMETypeHint.equalsIgnoreCase("url")) {
            editorInfo.inputType |= 0x10;
        } else if (this.mIMETypeHint.equalsIgnoreCase("email")) {
            editorInfo.inputType |= 0x20;
        } else if (this.mIMETypeHint.equalsIgnoreCase("tel")) {
            editorInfo.inputType = 3;
        } else if (this.mIMETypeHint.equalsIgnoreCase("number") || this.mIMETypeHint.equalsIgnoreCase("range")) {
            editorInfo.inputType = 12290;
        } else if (this.mIMETypeHint.equalsIgnoreCase("week") || this.mIMETypeHint.equalsIgnoreCase("month")) {
            editorInfo.inputType = 20;
        } else if (this.mIMEModeHint.equalsIgnoreCase("numeric")) {
            editorInfo.inputType = 12290;
        } else if (this.mIMEModeHint.equalsIgnoreCase("digit")) {
            editorInfo.inputType = 2;
        } else {
            editorInfo.inputType |= 0x48000;
            if (this.mIMETypeHint.equalsIgnoreCase("textarea") || this.mIMETypeHint.length() == 0) {
                editorInfo.inputType |= 0x20000;
            }
            if (this.mIMEModeHint.equalsIgnoreCase("uppercase")) {
                editorInfo.inputType |= 0x1000;
            } else if (this.mIMEModeHint.equalsIgnoreCase("titlecase")) {
                editorInfo.inputType |= 0x2000;
            } else if (this.mIMETypeHint.equalsIgnoreCase("text") && !this.mIMEModeHint.equalsIgnoreCase("autocapitalized")) {
                editorInfo.inputType |= 0;
            } else if (!this.mIMEModeHint.equalsIgnoreCase("lowercase")) {
                editorInfo.inputType |= 0x4000;
            }
        }
        if (this.mIMEActionHint.equalsIgnoreCase("go")) {
            editorInfo.imeOptions = 2;
        } else if (this.mIMEActionHint.equalsIgnoreCase("done")) {
            editorInfo.imeOptions = 6;
        } else if (this.mIMEActionHint.equalsIgnoreCase("next")) {
            editorInfo.imeOptions = 5;
        } else if (this.mIMEActionHint.equalsIgnoreCase("search") || this.mIMETypeHint.equalsIgnoreCase("search")) {
            editorInfo.imeOptions = 3;
        } else if (this.mIMEActionHint.equalsIgnoreCase("send")) {
            editorInfo.imeOptions = 4;
        } else if (this.mIMEActionHint.length() > 0) {
            editorInfo.actionLabel = this.mIMEActionHint;
        }
        Context context = GeckoAppShell.getContext();
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels) > 480) {
            editorInfo.imeOptions |= 0x12000000;
        }
        String string2 = this.mCurrentInputMethod;
        this.mCurrentInputMethod = InputMethods.getCurrentInputMethod(context);
        if (!this.mCurrentInputMethod.equals(string2) && GeckoAppShell.getGeckoInterface() != null && (formAssistPopup = GeckoAppShell.getGeckoInterface().getFormAssistPopup()) != null) {
            formAssistPopup.onInputMethodChanged(this.mCurrentInputMethod);
        }
        if (this.mIMEState == 3) {
            editorInfo.initialSelStart = 0;
            editorInfo.initialSelEnd = 0;
            return this.mKeyInputConnection;
        }
        formAssistPopup = this.getEditable();
        editorInfo.initialSelStart = Selection.getSelectionStart((CharSequence)((Object)formAssistPopup));
        editorInfo.initialSelEnd = Selection.getSelectionEnd((CharSequence)((Object)formAssistPopup));
        return this;
    }

    private boolean replaceComposingSpanWithSelection() {
        Editable editable = this.getEditable();
        if (editable == null) {
            return false;
        }
        int n = GeckoInputConnection.getComposingSpanStart((Spannable)editable);
        int n2 = GeckoInputConnection.getComposingSpanEnd((Spannable)editable);
        if (n != -1 && n2 != -1) {
            GeckoInputConnection.removeComposingSpans((Spannable)editable);
            Selection.setSelection((Spannable)editable, (int)n, (int)n2);
        }
        return true;
    }

    public boolean commitText(CharSequence charSequence, int n) {
        if (InputMethods.shouldCommitCharAsKey(this.mCurrentInputMethod) && charSequence.length() == 1 && n > 0) {
            return this.replaceComposingSpanWithSelection() && this.mKeyInputConnection.commitText(charSequence, n);
        }
        return super.commitText(charSequence, n);
    }

    public boolean setSelection(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return true;
        }
        return super.setSelection(n, n2);
    }

    public boolean sendKeyEvent(KeyEvent keyEvent) {
        super.sendKeyEvent(keyEvent);
        View view = GeckoInputConnection.getView();
        if (view == null) {
            return false;
        }
        Handler handler = this.mEditableClient.getInputConnectionHandler();
        Handler handler2 = view.getRootView().getHandler();
        if (handler.getLooper() != handler2.getLooper()) {
            handler2.post(new Runnable(){

                @Override
                public void run() {
                    InputThreadUtils.sInstance.endWaitForUiThread();
                }
            });
            InputThreadUtils.sInstance.waitForUiThread(handler);
        }
        return false;
    }

    @Override
    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        return false;
    }

    private boolean shouldProcessKey(int n, KeyEvent keyEvent) {
        switch (n) {
            case 4: 
            case 24: 
            case 25: 
            case 82: 
            case 84: {
                return false;
            }
        }
        return true;
    }

    private boolean shouldSkipKeyListener(int n, KeyEvent keyEvent) {
        if (this.mIMEState == 0 || this.mIMEState == 3) {
            return true;
        }
        if (n == 66 || n == 61) {
            return true;
        }
        return n == 67 || n == 112;
    }

    private KeyEvent translateKey(int n, KeyEvent keyEvent) {
        switch (n) {
            case 66: {
                if ((keyEvent.getFlags() & 0x10) == 0 || !this.mIMEActionHint.equalsIgnoreCase("next")) break;
                return new KeyEvent(keyEvent.getAction(), 61);
            }
        }
        return keyEvent;
    }

    private boolean processKey(int n, KeyEvent keyEvent, boolean bl) {
        if (GamepadUtils.isSonyXperiaGamepadKeyEvent((KeyEvent)keyEvent)) {
            keyEvent = GamepadUtils.translateSonyXperiaGamepadKeys((int)n, (KeyEvent)keyEvent);
            n = keyEvent.getKeyCode();
        }
        if (n > KeyEvent.getMaxKeyCode() || !this.shouldProcessKey(n, keyEvent)) {
            return false;
        }
        int n2 = bl ? 0 : 1;
        keyEvent = this.translateKey(n, keyEvent);
        n = keyEvent.getKeyCode();
        View view = GeckoInputConnection.getView();
        if (view == null) {
            InputThreadUtils.sInstance.sendEventFromUiThread(ThreadUtils.getUiHandler(), this.mEditableClient, GeckoEvent.createKeyEvent(keyEvent, n2, 0));
            return true;
        }
        TextKeyListener textKeyListener = TextKeyListener.getInstance();
        Handler handler = view.getRootView().getHandler();
        Editable editable = InputThreadUtils.sInstance.getEditableForUiThread(handler, this.mEditableClient);
        boolean bl2 = this.shouldSkipKeyListener(n, keyEvent);
        if (bl) {
            this.mEditableClient.setSuppressKeyUp(true);
        }
        if (bl2 || bl && !textKeyListener.onKeyDown(view, editable, n, keyEvent) || !bl && !textKeyListener.onKeyUp(view, editable, n, keyEvent)) {
            InputThreadUtils.sInstance.sendEventFromUiThread(handler, this.mEditableClient, GeckoEvent.createKeyEvent(keyEvent, n2, TextKeyListener.getMetaState((CharSequence)editable)));
            if (bl2 && bl) {
                TextKeyListener.adjustMetaAfterKeypress((Spannable)editable);
            }
        }
        if (bl) {
            this.mEditableClient.setSuppressKeyUp(false);
        }
        return true;
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.processKey(n, keyEvent, true);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.processKey(n, keyEvent, false);
    }

    private KeyEvent getCharKeyEvent(final char c) {
        long l = SystemClock.uptimeMillis();
        return new KeyEvent(l, l, 2, 0, 0){

            public int getUnicodeChar() {
                return c;
            }

            public int getUnicodeChar(int n) {
                return c;
            }
        };
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        if (n == 0) {
            String string2 = keyEvent.getCharacters();
            for (int i = 0; i < string2.length(); ++i) {
                KeyEvent keyEvent2 = this.getCharKeyEvent(string2.charAt(i));
                if (this.processKey(0, keyEvent2, true) && this.processKey(0, keyEvent2, false)) continue;
                return false;
            }
            return true;
        }
        while (n2-- != 0) {
            if (this.processKey(n, keyEvent, true) && this.processKey(n, keyEvent, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        View view = GeckoInputConnection.getView();
        switch (n) {
            case 82: {
                InputMethodManager inputMethodManager = GeckoInputConnection.getInputMethodManager();
                inputMethodManager.toggleSoftInputFromWindow(view.getWindowToken(), 2, 0);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIMEEnabled() {
        return this.mIMEState != 0;
    }

    @Override
    public void notifyIME(int n) {
        switch (n) {
            case 1: 
            case 2: {
                this.resetInputConnection();
                break;
            }
            case -2: {
                GeckoInputConnection.showSoftInput();
                break;
            }
        }
    }

    @Override
    public void notifyIMEContext(int n, String string2, String string3, String string4) {
        if (string2 != null && (string2.equalsIgnoreCase("date") || string2.equalsIgnoreCase("time") || AppConstants.Versions.feature11Plus && (string2.equalsIgnoreCase("datetime") || string2.equalsIgnoreCase("month") || string2.equalsIgnoreCase("week") || string2.equalsIgnoreCase("datetime-local")))) {
            n = 0;
        }
        this.mIMEState = n;
        this.mIMETypeHint = string2 == null ? "" : string2;
        this.mIMEModeHint = string3 == null ? "" : string3;
        this.mIMEActionHint = string4 == null ? "" : string4;
        this.mUpdateRequest = null;
        this.mCurrentInputMethod = "";
        View view = GeckoInputConnection.getView();
        if (view == null || !view.hasFocus()) {
            return;
        }
        this.restartInput();
        if (this.mIMEState == 0) {
            GeckoInputConnection.hideSoftInput();
        } else {
            GeckoInputConnection.showSoftInput();
        }
    }

    private static class InputThreadUtils {
        public static final InputThreadUtils sInstance = new InputThreadUtils();
        private Editable mUiEditable;
        private Object mUiEditableReturn;
        private Exception mUiEditableException;
        private final SynchronousQueue<Runnable> mIcRunnableSync = new SynchronousQueue();
        private final Runnable mIcSignalRunnable = new Runnable(){

            @Override
            public void run() {
            }
        };

        private InputThreadUtils() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runOnIcThread(Handler handler, final Runnable runnable) {
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    try {
                        Runnable runnable2 = (Runnable)InputThreadUtils.this.mIcRunnableSync.take();
                        runnable2.run();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            try {
                handler.post(runnable2);
                this.mIcRunnableSync.put(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                handler.removeCallbacks(runnable2);
            }
        }

        public void endWaitForUiThread() {
            try {
                this.mIcRunnableSync.put(this.mIcSignalRunnable);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void waitForUiThread(Handler handler) {
            try {
                Runnable runnable = null;
                do {
                    runnable = this.mIcRunnableSync.take();
                    runnable.run();
                } while (runnable != this.mIcSignalRunnable);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void runOnIcThread(Handler handler, GeckoEditableClient geckoEditableClient, Runnable runnable) {
            Handler handler2 = geckoEditableClient.getInputConnectionHandler();
            if (handler2.getLooper() == handler.getLooper()) {
                runnable.run();
                return;
            }
            this.runOnIcThread(handler2, runnable);
        }

        public void sendEventFromUiThread(Handler handler, final GeckoEditableClient geckoEditableClient, final GeckoEvent geckoEvent) {
            this.runOnIcThread(handler, geckoEditableClient, new Runnable(){

                @Override
                public void run() {
                    geckoEditableClient.sendEvent(geckoEvent);
                }
            });
        }

        public Editable getEditableForUiThread(final Handler handler, final GeckoEditableClient geckoEditableClient) {
            final Handler handler2 = geckoEditableClient.getInputConnectionHandler();
            if (handler2.getLooper() == handler.getLooper()) {
                return geckoEditableClient.getEditable();
            }
            if (this.mUiEditable != null) {
                return this.mUiEditable;
            }
            InvocationHandler invocationHandler = new InvocationHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object invoke(Object object, final Method method, final Object[] objectArray) throws Throwable {
                    Handler handler3 = handler2;
                    synchronized (handler3) {
                        InputThreadUtils.this.mUiEditableReturn = null;
                        InputThreadUtils.this.mUiEditableException = null;
                        InputThreadUtils.this.runOnIcThread(handler2, new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Handler handler = handler2;
                                synchronized (handler) {
                                    try {
                                        InputThreadUtils.this.mUiEditableReturn = method.invoke((Object)geckoEditableClient.getEditable(), objectArray);
                                    }
                                    catch (Exception exception) {
                                        InputThreadUtils.this.mUiEditableException = exception;
                                    }
                                    handler2.notify();
                                }
                            }
                        });
                        handler2.wait();
                        if (InputThreadUtils.this.mUiEditableException != null) {
                            throw InputThreadUtils.this.mUiEditableException;
                        }
                        return InputThreadUtils.this.mUiEditableReturn;
                    }
                }
            };
            this.mUiEditable = (Editable)Proxy.newProxyInstance(Editable.class.getClassLoader(), new Class[]{Editable.class}, invocationHandler);
            return this.mUiEditable;
        }
    }
}

