/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.util.ThreadUtils;

class GlobalHistory {
    private static final String LOGTAG = "GeckoGlobalHistory";
    private static final String TELEMETRY_HISTOGRAM_ADD = "FENNEC_GLOBALHISTORY_ADD_MS";
    private static final String TELEMETRY_HISTOGRAM_UPDATE = "FENNEC_GLOBALHISTORY_UPDATE_MS";
    private static final String TELEMETRY_HISTOGRAM_BUILD_VISITED_LINK = "FENNEC_GLOBALHISTORY_VISITED_BUILD_MS";
    private static final GlobalHistory sInstance = new GlobalHistory();
    private static final long BATCHING_DELAY_MS = 100L;
    private final Handler mHandler = ThreadUtils.getBackgroundHandler();
    final Queue<String> mPendingUris = new LinkedList<String>();
    SoftReference<Set<String>> mVisitedCache = new SoftReference<Object>(null);
    boolean mProcessing;

    static GlobalHistory getInstance() {
        return sInstance;
    }

    private GlobalHistory() {
    }

    public void addToGeckoOnly(String string2) {
        Set<String> set = this.mVisitedCache.get();
        if (set != null) {
            set.add(string2);
        }
        GeckoAppShell.notifyUriVisited(string2);
    }

    public void add(Context context, BrowserDB browserDB, String string2) {
        ThreadUtils.assertOnBackgroundThread();
        long l = SystemClock.uptimeMillis();
        browserDB.updateVisitedHistory(context.getContentResolver(), string2);
        long l2 = SystemClock.uptimeMillis();
        long l3 = l2 - l;
        Telemetry.addToHistogram(TELEMETRY_HISTOGRAM_ADD, (int)Math.min(l3, Integer.MAX_VALUE));
        this.addToGeckoOnly(string2);
    }

    public void update(ContentResolver contentResolver, BrowserDB browserDB, String string2, String string3) {
        ThreadUtils.assertOnBackgroundThread();
        long l = SystemClock.uptimeMillis();
        browserDB.updateHistoryTitle(contentResolver, string2, string3);
        long l2 = SystemClock.uptimeMillis();
        long l3 = l2 - l;
        Telemetry.addToHistogram(TELEMETRY_HISTOGRAM_UPDATE, (int)Math.min(l3, Integer.MAX_VALUE));
    }

    public void checkUriVisited(final String string2) {
        final NotifierRunnable notifierRunnable = new NotifierRunnable(GeckoAppShell.getContext());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GlobalHistory.this.mPendingUris.add(string2);
                if (GlobalHistory.this.mProcessing) {
                    return;
                }
                GlobalHistory.this.mProcessing = true;
                GlobalHistory.this.mHandler.postDelayed((Runnable)notifierRunnable, 100L);
            }
        });
    }

    private class NotifierRunnable
    implements Runnable {
        private final ContentResolver mContentResolver;
        private final BrowserDB mDB;

        public NotifierRunnable(Context context) {
            this.mContentResolver = context.getContentResolver();
            this.mDB = GeckoProfile.get(context).getDB();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string2;
            Set<String> set = GlobalHistory.this.mVisitedCache.get();
            if (set == null) {
                Log.w((String)GlobalHistory.LOGTAG, (String)"Rebuilding visited link set...");
                long l = SystemClock.uptimeMillis();
                Cursor cursor = this.mDB.getAllVisitedHistory(this.mContentResolver);
                if (cursor == null) {
                    return;
                }
                try {
                    set = new HashSet<String>();
                    if (cursor.moveToFirst()) {
                        do {
                            set.add(cursor.getString(0));
                        } while (cursor.moveToNext());
                    }
                    GlobalHistory.this.mVisitedCache = new SoftReference<Set<String>>(set);
                    long l2 = SystemClock.uptimeMillis();
                    long l3 = l2 - l;
                    Telemetry.addToHistogram(GlobalHistory.TELEMETRY_HISTOGRAM_BUILD_VISITED_LINK, (int)Math.min(l3, Integer.MAX_VALUE));
                }
                finally {
                    cursor.close();
                }
            }
            while ((string2 = GlobalHistory.this.mPendingUris.poll()) != null) {
                if (!set.contains(string2)) continue;
                GeckoAppShell.notifyUriVisited(string2);
            }
            GlobalHistory.this.mProcessing = false;
        }
    }
}

