/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.animation;

import com.nineoldandroids.animation.Animator;
import java.util.ArrayList;
import java.util.Collections;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.util.ThreadUtils;

public class TransitionsTracker {
    private static final ArrayList<Runnable> pendingActions = new ArrayList();
    private static int transitionCount;
    private static final PropertyAnimator.PropertyAnimationListener propertyAnimatorListener;
    private static final Animator.AnimatorListener animatorListener;

    private static void runPendingActions() {
        ThreadUtils.assertOnUiThread();
        int n = pendingActions.size();
        for (int i = 0; i < n; ++i) {
            pendingActions.get(i).run();
        }
        pendingActions.clear();
    }

    public static void pushTransition() {
        ThreadUtils.assertOnUiThread();
        ++transitionCount;
    }

    public static void popTransition() {
        ThreadUtils.assertOnUiThread();
        if (--transitionCount < 0) {
            throw new IllegalStateException("Invalid transition stack update");
        }
        if (transitionCount == 0) {
            TransitionsTracker.runPendingActions();
        }
    }

    public static boolean areTransitionsRunning() {
        ThreadUtils.assertOnUiThread();
        return transitionCount > 0;
    }

    public static void track(PropertyAnimator propertyAnimator) {
        ThreadUtils.assertOnUiThread();
        propertyAnimator.addPropertyAnimationListener(propertyAnimatorListener);
    }

    public static void track(Animator animator) {
        ThreadUtils.assertOnUiThread();
        animator.addListener(animatorListener);
    }

    public static boolean cancelPendingAction(Runnable runnable) {
        ThreadUtils.assertOnUiThread();
        return pendingActions.removeAll(Collections.singleton(runnable));
    }

    public static void runAfterTransitions(Runnable runnable) {
        ThreadUtils.assertOnUiThread();
        if (transitionCount == 0) {
            runnable.run();
        } else {
            pendingActions.add(runnable);
        }
    }

    static {
        propertyAnimatorListener = new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                TransitionsTracker.pushTransition();
            }

            @Override
            public void onPropertyAnimationEnd() {
                TransitionsTracker.popTransition();
            }
        };
        animatorListener = new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                TransitionsTracker.pushTransition();
            }

            public void onAnimationEnd(Animator animator) {
                TransitionsTracker.popTransition();
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        };
    }
}

