/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.SRPConstants;

public class FxAccount10CreateDelegate
implements FxAccountClient10.CreateDelegate {
    protected final String email;
    protected final String mainSalt;
    protected final String srpSalt;
    protected final BigInteger v;

    public FxAccount10CreateDelegate(String string2, byte[] byArray, String string3, String string4) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        this.email = string2;
        this.mainSalt = string3;
        this.srpSalt = string4;
        byte[] byArray2 = Utils.hex2Byte(string4, 32);
        this.v = FxAccountUtils.srpVerifierLowercaseV(string2.getBytes("UTF-8"), byArray, byArray2, SRPConstants._2048.g, SRPConstants._2048.N);
    }

    @Override
    public JSONObject getCreateBody() throws FxAccountClientException {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put((Object)"email", (Object)FxAccountUtils.bytes(this.email));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FxAccountClientException(unsupportedEncodingException);
        }
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put((Object)"type", (Object)"PBKDF2/scrypt/PBKDF2/v1");
        jSONObject2.put((Object)"PBKDF2_rounds_1", (Object)20000);
        jSONObject2.put((Object)"scrypt_N", (Object)65536);
        jSONObject2.put((Object)"scrypt_r", (Object)8);
        jSONObject2.put((Object)"scrypt_p", (Object)1);
        jSONObject2.put((Object)"PBKDF2_rounds_2", (Object)20000);
        jSONObject2.put((Object)"salt", (Object)this.mainSalt);
        jSONObject.put((Object)"passwordStretching", (Object)jSONObject2);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put((Object)"type", (Object)"SRP-6a/SHA256/2048/v1");
        jSONObject3.put((Object)"verifier", (Object)FxAccountUtils.hexModN(this.v, SRPConstants._2048.N));
        jSONObject3.put((Object)"salt", (Object)this.srpSalt);
        jSONObject.put((Object)"srp", (Object)jSONObject3);
        return jSONObject;
    }
}

