/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.View;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountAgeLockoutHelper;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.PasswordStretcher;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountNotAllowedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSignInActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.tasks.FxAccountCreateAccountTask;
import org.mozilla.gecko.sync.Utils;

public class FxAccountCreateAccountActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountCreateAccountActivity.class.getSimpleName();
    private static final int CHILD_REQUEST_CODE = 2;
    protected String[] yearItems;
    protected String[] monthItems;
    protected String[] dayItems;
    protected EditText yearEdit;
    protected EditText monthEdit;
    protected EditText dayEdit;
    protected CheckBox chooseCheckBox;
    protected View monthDaycombo;
    protected Map<String, Boolean> selectedEngines;
    protected final Map<String, Boolean> authoritiesToSyncAutomaticallyMap = new HashMap<String, Boolean>(AndroidFxAccount.DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP);

    @Override
    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_create_account);
        this.emailEdit = (AutoCompleteTextView)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.yearEdit = (EditText)this.ensureFindViewById(null, R.id.year_edit, "year edit");
        this.monthEdit = (EditText)this.ensureFindViewById(null, R.id.month_edit, "month edit");
        this.dayEdit = (EditText)this.ensureFindViewById(null, R.id.day_edit, "day edit");
        this.monthDaycombo = this.ensureFindViewById(null, R.id.month_day_combo, "month day combo");
        this.remoteErrorTextView = (TextView)this.ensureFindViewById(null, R.id.remote_error, "remote error text view");
        this.button = (Button)this.ensureFindViewById(null, R.id.button, "create account button");
        this.progressBar = (ProgressBar)this.ensureFindViewById(null, R.id.progress, "progress bar");
        this.chooseCheckBox = (CheckBox)this.ensureFindViewById(null, R.id.choose_what_to_sync_checkbox, "choose what to sync check box");
        this.selectedEngines = new HashMap<String, Boolean>();
        this.createCreateAccountButton();
        this.createYearEdit();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        this.linkifyPolicy();
        this.createChooseCheckBox();
        this.initializeMonthAndDayValues();
        View view = this.ensureFindViewById(null, R.id.sign_in_instead_link, "sign in instead link");
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Bundle bundle = FxAccountCreateAccountActivity.this.makeExtrasBundle(null, null);
                FxAccountCreateAccountActivity.this.startActivityInstead(FxAccountSignInActivity.class, 2, bundle);
            }
        });
        this.updateFromIntentExtras();
        this.maybeEnableAnimations();
    }

    protected void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        this.updateMonthAndDayFromBundle(bundle);
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        this.updateBundleWithMonthAndDay(bundle);
    }

    @Override
    protected Bundle makeExtrasBundle(String string2, String string3) {
        Bundle bundle = super.makeExtrasBundle(string2, string3);
        bundle.putString("year", this.yearEdit.getText().toString());
        this.updateBundleWithMonthAndDay(bundle);
        return bundle;
    }

    @Override
    protected void updateFromIntentExtras() {
        super.updateFromIntentExtras();
        if (this.getIntent() != null) {
            this.yearEdit.setText((CharSequence)this.getIntent().getStringExtra("year"));
            this.updateMonthAndDayFromBundle(this.getIntent().getExtras() != null ? this.getIntent().getExtras() : new Bundle());
        }
    }

    private void updateBundleWithMonthAndDay(Bundle bundle) {
        if (this.monthEdit.getTag() != null) {
            bundle.putInt("month", ((Integer)this.monthEdit.getTag()).intValue());
        }
        if (this.dayEdit.getTag() != null) {
            bundle.putInt("day", ((Integer)this.dayEdit.getTag()).intValue());
        }
    }

    private void updateMonthAndDayFromBundle(Bundle bundle) {
        Integer n = (Integer)bundle.get("month");
        Integer n2 = (Integer)bundle.get("day");
        this.maybeEnableMonthAndDayButtons();
        if (n != null) {
            this.monthEdit.setText((CharSequence)this.monthItems[n]);
            this.monthEdit.setTag((Object)n);
            this.createDayEdit(n);
            if (n2 != null && this.dayItems != null) {
                this.dayEdit.setText((CharSequence)this.dayItems[n2 - 1]);
                this.dayEdit.setTag((Object)n2);
            }
        } else {
            this.monthEdit.setText((CharSequence)"");
            this.dayEdit.setText((CharSequence)"");
        }
        this.updateButtonState();
    }

    @Override
    protected void showClientRemoteException(final FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
        if (!fxAccountClientRemoteException.isAccountAlreadyExists()) {
            super.showClientRemoteException(fxAccountClientRemoteException);
            return;
        }
        int n = fxAccountClientRemoteException.getErrorMessageStringResource();
        int n2 = R.string.fxaccount_sign_in_button_label;
        Spannable spannable = Utils.interpolateClickableSpan((Context)this, n, n2, new ClickableSpan(){

            public void onClick(View view) {
                String string2 = fxAccountClientRemoteException.body.getString("email");
                if (string2 == null) {
                    string2 = FxAccountCreateAccountActivity.this.emailEdit.getText().toString();
                }
                String string3 = FxAccountCreateAccountActivity.this.passwordEdit.getText().toString();
                Bundle bundle = FxAccountCreateAccountActivity.this.makeExtrasBundle(string2, string3);
                FxAccountCreateAccountActivity.this.startActivityInstead(FxAccountSignInActivity.class, 2, bundle);
            }
        });
        this.remoteErrorTextView.setMovementMethod(LinkMovementMethod.getInstance());
        this.remoteErrorTextView.setText((CharSequence)spannable);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        Logger.debug(LOG_TAG, "onActivityResult: " + n);
        if (n != 2 || n2 != -1) {
            super.onActivityResult(n, n2, intent);
            return;
        }
        this.setResult(n2, intent);
        this.finish();
    }

    protected String[] getYearItems() {
        int n = Calendar.getInstance().get(1);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.getResources().getString(R.string.fxaccount_create_account_1990_or_earlier));
        for (int i = 1991; i <= n - 5; ++i) {
            linkedList.add(Integer.toString(i));
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    protected void createYearEdit() {
        this.yearItems = this.getYearItems();
        this.yearEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        FxAccountCreateAccountActivity.this.yearEdit.setText((CharSequence)FxAccountCreateAccountActivity.this.yearItems[n]);
                        FxAccountCreateAccountActivity.this.maybeEnableMonthAndDayButtons();
                        FxAccountCreateAccountActivity.this.updateButtonState();
                    }
                };
                AlertDialog alertDialog = new AlertDialog.Builder((Context)FxAccountCreateAccountActivity.this).setTitle(R.string.fxaccount_create_account_year_of_birth).setItems((CharSequence[])FxAccountCreateAccountActivity.this.yearItems, onClickListener).setIcon(R.drawable.icon).create();
                alertDialog.show();
            }
        });
    }

    private void initializeMonthAndDayValues() {
        this.monthDaycombo.setVisibility(8);
        this.dayEdit.setEnabled(false);
        Calendar calendar = Calendar.getInstance();
        Map<String, Integer> map = calendar.getDisplayNames(2, 2, Locale.getDefault());
        this.monthItems = new String[map.size()];
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            this.monthItems[entry.getValue().intValue()] = entry.getKey();
        }
        this.createMonthEdit();
    }

    protected void createMonthEdit() {
        this.monthEdit.setText((CharSequence)"");
        this.monthEdit.setTag(null);
        this.monthEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        FxAccountCreateAccountActivity.this.monthEdit.setText((CharSequence)FxAccountCreateAccountActivity.this.monthItems[n]);
                        FxAccountCreateAccountActivity.this.monthEdit.setTag((Object)n);
                        FxAccountCreateAccountActivity.this.createDayEdit(n);
                        FxAccountCreateAccountActivity.this.updateButtonState();
                    }
                };
                AlertDialog alertDialog = new AlertDialog.Builder((Context)FxAccountCreateAccountActivity.this).setTitle(R.string.fxaccount_create_account_month_of_birth).setItems((CharSequence[])FxAccountCreateAccountActivity.this.monthItems, onClickListener).setIcon(R.drawable.icon).create();
                alertDialog.show();
            }
        });
    }

    protected void createDayEdit(int n) {
        Integer n2;
        this.dayEdit.setText((CharSequence)"");
        this.dayEdit.setTag(null);
        this.dayEdit.setEnabled(true);
        String string2 = this.yearEdit.getText().toString();
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.debug(LOG_TAG, "Exception while parsing year value" + numberFormatException);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n2, n, 1);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = calendar.getActualMinimum(5); i <= calendar.getActualMaximum(5); ++i) {
            linkedList.add(Integer.toString(i));
        }
        this.dayItems = linkedList.toArray(new String[linkedList.size()]);
        this.dayEdit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        FxAccountCreateAccountActivity.this.dayEdit.setText((CharSequence)FxAccountCreateAccountActivity.this.dayItems[n]);
                        FxAccountCreateAccountActivity.this.dayEdit.setTag((Object)(n + 1));
                        FxAccountCreateAccountActivity.this.updateButtonState();
                    }
                };
                AlertDialog alertDialog = new AlertDialog.Builder((Context)FxAccountCreateAccountActivity.this).setTitle(R.string.fxaccount_create_account_day_of_birth).setItems((CharSequence[])FxAccountCreateAccountActivity.this.dayItems, onClickListener).setIcon(R.drawable.icon).create();
                alertDialog.show();
            }
        });
    }

    private void maybeEnableMonthAndDayButtons() {
        Integer n = null;
        try {
            n = Integer.valueOf(this.yearEdit.getText().toString(), 10);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.debug(LOG_TAG, "Year text is not a number; assuming year is a range and that user is old enough.");
        }
        if (n == null || !FxAccountAgeLockoutHelper.isMagicYear(n)) {
            this.monthEdit.setTag((Object)11);
            this.dayEdit.setTag((Object)31);
            return;
        }
        this.yearEdit.setVisibility(8);
        this.monthDaycombo.setVisibility(0);
        this.monthEdit.setTag(null);
        this.dayEdit.setTag(null);
    }

    public void createAccount(String string2, String string3, Map<String, Boolean> map, Map<String, Boolean> map2) {
        String string4 = this.getAuthServerEndpoint();
        PasswordStretcher passwordStretcher = this.makePasswordStretcher(string3);
        FxAccountAbstractSetupActivity.AddAccountDelegate addAccountDelegate = new FxAccountAbstractSetupActivity.AddAccountDelegate(string2, passwordStretcher, string4, map, map2){

            @Override
            public void handleError(Exception exception) {
                FxAccountCreateAccountActivity.this.showRemoteError(exception, R.string.fxaccount_create_account_unknown_error);
            }

            @Override
            public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                FxAccountCreateAccountActivity.this.showRemoteError(fxAccountClientRemoteException, R.string.fxaccount_create_account_unknown_error);
            }
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            this.hideRemoteError();
            new FxAccountCreateAccountTask((Context)this, this, string2, passwordStretcher, fxAccountClient20, this.getQueryParameters(), addAccountDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            this.showRemoteError(exception, R.string.fxaccount_create_account_unknown_error);
        }
    }

    @Override
    protected boolean shouldButtonBeEnabled() {
        return super.shouldButtonBeEnabled() && this.yearEdit.length() > 0 && this.monthEdit.getTag() != null && this.dayEdit.getTag() != null;
    }

    protected void createCreateAccountButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Map<String, Boolean> map;
                if (!FxAccountCreateAccountActivity.this.updateButtonState()) {
                    return;
                }
                String string2 = FxAccountCreateAccountActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountCreateAccountActivity.this.passwordEdit.getText().toString();
                int n = (Integer)FxAccountCreateAccountActivity.this.dayEdit.getTag();
                int n2 = (Integer)FxAccountCreateAccountActivity.this.monthEdit.getTag();
                Map<String, Boolean> map2 = FxAccountCreateAccountActivity.this.chooseCheckBox.isChecked() ? FxAccountCreateAccountActivity.this.selectedEngines : null;
                Map<String, Boolean> map3 = map = FxAccountCreateAccountActivity.this.chooseCheckBox.isChecked() ? FxAccountCreateAccountActivity.this.authoritiesToSyncAutomaticallyMap : AndroidFxAccount.DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP;
                if (FxAccountAgeLockoutHelper.passesAgeCheck(n, n2, FxAccountCreateAccountActivity.this.yearEdit.getText().toString(), FxAccountCreateAccountActivity.this.yearItems)) {
                    FxAccountUtils.pii(LOG_TAG, "Passed age check.");
                    FxAccountCreateAccountActivity.this.createAccount(string2, string3, map2, map);
                } else {
                    FxAccountUtils.pii(LOG_TAG, "Failed age check!");
                    FxAccountAgeLockoutHelper.lockOut(SystemClock.elapsedRealtime());
                    FxAccountCreateAccountActivity.this.setResult(0);
                    FxAccountCreateAccountActivity.this.redirectToActivity(FxAccountCreateAccountNotAllowedActivity.class);
                }
            }
        });
    }

    protected void createChooseCheckBox() {
        final int n = 4;
        CharSequence[] charSequenceArray = new String[n];
        final boolean[] blArray = new boolean[n];
        charSequenceArray[0] = this.getResources().getString(R.string.fxaccount_status_bookmarks);
        charSequenceArray[1] = this.getResources().getString(R.string.fxaccount_status_history);
        charSequenceArray[2] = this.getResources().getString(R.string.fxaccount_status_tabs);
        charSequenceArray[3] = this.getResources().getString(R.string.fxaccount_status_passwords);
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                if (n2 != -1) {
                    Logger.debug(LOG_TAG, "onClick: not button positive, unchecking.");
                    FxAccountCreateAccountActivity.this.chooseCheckBox.setChecked(false);
                    return;
                }
                Logger.debug(LOG_TAG, "onClick: button positive, checking.");
                FxAccountCreateAccountActivity.this.chooseCheckBox.setChecked(true);
                ListView listView = ((AlertDialog)dialogInterface).getListView();
                for (int i = 0; i < n; ++i) {
                    blArray[i] = listView.isItemChecked(i);
                }
                FxAccountCreateAccountActivity.this.selectedEngines.put("bookmarks", blArray[0]);
                FxAccountCreateAccountActivity.this.selectedEngines.put("history", blArray[1]);
                FxAccountCreateAccountActivity.this.selectedEngines.put("tabs", blArray[2]);
                FxAccountCreateAccountActivity.this.selectedEngines.put("passwords", blArray[3]);
                FxAccountUtils.pii(LOG_TAG, "Updating selectedEngines: " + FxAccountCreateAccountActivity.this.selectedEngines.toString());
                FxAccountUtils.pii(LOG_TAG, "Updating authorities: " + FxAccountCreateAccountActivity.this.authoritiesToSyncAutomaticallyMap.toString());
            }
        };
        DialogInterface.OnMultiChoiceClickListener onMultiChoiceClickListener = new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialogInterface, int n, boolean bl) {
                ListView listView = ((AlertDialog)dialogInterface).getListView();
                listView.setItemChecked(n, bl);
            }
        };
        final AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setTitle(R.string.fxaccount_create_account_choose_what_to_sync).setIcon(R.drawable.icon).setMultiChoiceItems(charSequenceArray, blArray, onMultiChoiceClickListener).setPositiveButton(17039370, onClickListener).setNegativeButton(0x1040000, onClickListener).create();
        alertDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                Logger.debug(LOG_TAG, "onCancel: unchecking.");
                FxAccountCreateAccountActivity.this.chooseCheckBox.setChecked(false);
            }
        });
        this.chooseCheckBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!FxAccountCreateAccountActivity.this.chooseCheckBox.isChecked()) {
                    Logger.debug(LOG_TAG, "onClick: was checked, not showing dialog.");
                    return;
                }
                Logger.debug(LOG_TAG, "onClick: was unchecked, showing dialog.");
                alertDialog.show();
            }
        });
    }
}

