/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.delegates;

import java.util.concurrent.ExecutorService;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;

public class DeferredRepositorySessionBeginDelegate
implements RepositorySessionBeginDelegate {
    private final RepositorySessionBeginDelegate inner;
    private final ExecutorService executor;

    public DeferredRepositorySessionBeginDelegate(RepositorySessionBeginDelegate repositorySessionBeginDelegate, ExecutorService executorService) {
        this.inner = repositorySessionBeginDelegate;
        this.executor = executorService;
    }

    @Override
    public void onBeginSucceeded(final RepositorySession repositorySession) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DeferredRepositorySessionBeginDelegate.this.inner.onBeginSucceeded(repositorySession);
            }
        });
    }

    @Override
    public void onBeginFailed(final Exception exception) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DeferredRepositorySessionBeginDelegate.this.inner.onBeginFailed(exception);
            }
        });
    }

    @Override
    public RepositorySessionBeginDelegate deferredBeginDelegate(ExecutorService executorService) {
        if (executorService == this.executor) {
            return this;
        }
        throw new IllegalArgumentException("Can't re-defer this delegate.");
    }
}

