/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageButton;
import org.mozilla.gecko.R;

public class TabPanelBackButton
extends ImageButton {
    private int dividerWidth = 0;
    private final Drawable divider;
    private final int dividerPadding;

    public TabPanelBackButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabPanelBackButton);
        this.divider = typedArray.getDrawable(R.styleable.TabPanelBackButton_rightDivider);
        this.dividerPadding = (int)typedArray.getDimension(R.styleable.TabPanelBackButton_dividerVerticalPadding, 0.0f);
        typedArray.recycle();
        if (this.divider != null) {
            this.dividerWidth = this.divider.getIntrinsicWidth();
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        this.setMeasuredDimension(this.getMeasuredWidth() + this.dividerWidth, this.getMeasuredHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.divider != null) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            int n = this.getRight() - marginLayoutParams.rightMargin - this.dividerWidth;
            this.divider.setBounds(n, this.getPaddingTop() + this.dividerPadding, n + this.dividerWidth, this.getHeight() - this.getPaddingBottom() - this.dividerPadding);
            this.divider.draw(canvas);
        }
    }
}

