/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.menu.MenuItemActionView;
import org.mozilla.gecko.menu.QuickShareBarActionView;
import org.mozilla.gecko.overlays.ui.ShareDialog;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.ActivityChooserModel;

public class GeckoActionProvider {
    private static final int MAX_HISTORY_SIZE_DEFAULT = 2;
    final Context mContext;
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    public static final String DEFAULT_HISTORY_FILE_NAME = "history.xml";
    String mHistoryFileName = "history.xml";
    OnTargetSelectedListener mOnTargetListener;
    private final Callbacks mCallbacks = new Callbacks();
    private static final HashMap<String, GeckoActionProvider> mProviders = new HashMap();

    private static String getFilenameFromMimeType(String string2) {
        String[] stringArray = string2.split("/");
        if ("text".equals(stringArray[0])) {
            return DEFAULT_HISTORY_FILE_NAME;
        }
        return "history-" + stringArray[0] + ".xml";
    }

    public static GeckoActionProvider getForType(String string2, Context context) {
        if (!mProviders.keySet().contains(string2)) {
            GeckoActionProvider geckoActionProvider = new GeckoActionProvider(context);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return geckoActionProvider;
            }
            geckoActionProvider.setHistoryFileName(GeckoActionProvider.getFilenameFromMimeType(string2));
            mProviders.put(string2, geckoActionProvider);
        }
        return mProviders.get(string2);
    }

    public GeckoActionProvider(Context context) {
        this.mContext = context;
    }

    public View onCreateActionView(ActionViewType actionViewType) {
        return this.onCreateActionView(2, actionViewType);
    }

    public View onCreateActionView(int n, ActionViewType actionViewType) {
        MenuItemActionView menuItemActionView;
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        switch (actionViewType) {
            case DEFAULT: {
                menuItemActionView = new MenuItemActionView(this.mContext, null);
                break;
            }
            case QUICK_SHARE_ICON: {
                menuItemActionView = new QuickShareBarActionView(this.mContext, null);
                break;
            }
            case CONTEXT_MENU: {
                menuItemActionView = new MenuItemActionView(this.mContext, null);
                menuItemActionView.initContextMenuStyles();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown " + ActionViewType.class.getSimpleName() + ": " + (Object)((Object)actionViewType));
            }
        }
        menuItemActionView.addActionButtonClickListener(this.mCallbacks);
        PackageManager packageManager = this.mContext.getPackageManager();
        int n2 = activityChooserModel.getDistinctActivityCountInHistory();
        if (n2 > n) {
            n2 = n;
        }
        if (n2 > activityChooserModel.getActivityCount()) {
            return menuItemActionView;
        }
        for (int i = 0; i < n2; ++i) {
            menuItemActionView.addActionButton(activityChooserModel.getActivity(i).loadIcon(packageManager), activityChooserModel.getActivity(i).loadLabel(packageManager));
        }
        return menuItemActionView;
    }

    public boolean hasSubMenu() {
        return true;
    }

    public void onPrepareSubMenu(SubMenu subMenu) {
        subMenu.clear();
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        PackageManager packageManager = this.mContext.getPackageManager();
        String string2 = ShareDialog.class.getCanonicalName();
        String string3 = this.mContext.getResources().getString(R.string.overlay_share_send_other);
        int n = activityChooserModel.getActivityCount();
        for (int i = 0; i < n; ++i) {
            ResolveInfo resolveInfo = activityChooserModel.getActivity(i);
            CharSequence charSequence = resolveInfo.loadLabel(packageManager);
            int n2 = string2.equals(resolveInfo.activityInfo.name) && string3.equals(charSequence) ? 1 + i : 1 + (i | 0x30000);
            subMenu.add(0, i, n2, charSequence).setIcon(resolveInfo.loadIcon(packageManager)).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this.mCallbacks);
        }
    }

    public void setHistoryFileName(String string2) {
        this.mHistoryFileName = string2;
    }

    public Intent getIntent() {
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        return activityChooserModel.getIntent();
    }

    public void setIntent(Intent intent) {
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        activityChooserModel.setIntent(intent);
        if (this.mOnTargetListener != null) {
            this.mOnTargetListener.onTargetSelected();
        }
    }

    public void setOnTargetSelectedListener(OnTargetSelectedListener onTargetSelectedListener) {
        this.mOnTargetListener = onTargetSelectedListener;
    }

    public ArrayList<ResolveInfo> getSortedActivities() {
        ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
        ActivityChooserModel activityChooserModel = ActivityChooserModel.get(this.mContext, this.mHistoryFileName);
        int n = activityChooserModel.getActivityCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(activityChooserModel.getActivity(i));
        }
        return arrayList;
    }

    public void chooseActivity(int n) {
        this.mCallbacks.chooseActivity(n);
    }

    public static enum ActionViewType {
        DEFAULT,
        QUICK_SHARE_ICON,
        CONTEXT_MENU;

    }

    private class Callbacks
    implements MenuItem.OnMenuItemClickListener,
    View.OnClickListener {
        private Callbacks() {
        }

        void chooseActivity(int n) {
            ActivityChooserModel activityChooserModel = ActivityChooserModel.get(GeckoActionProvider.this.mContext, GeckoActionProvider.this.mHistoryFileName);
            final Intent intent = activityChooserModel.chooseActivity(n);
            if (intent != null) {
                ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String string2 = intent.getType();
                        if ("android.intent.action.SEND".equals(intent.getAction()) && string2 != null && string2.startsWith("image/")) {
                            GeckoAppShell.downloadImageForIntent(intent);
                        }
                        intent.addFlags(524288);
                        GeckoActionProvider.this.mContext.startActivity(intent);
                    }
                });
            }
            if (GeckoActionProvider.this.mOnTargetListener != null) {
                GeckoActionProvider.this.mOnTargetListener.onTargetSelected();
            }
        }

        public boolean onMenuItemClick(MenuItem menuItem) {
            this.chooseActivity(menuItem.getItemId());
            Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST);
            return true;
        }

        public void onClick(View view) {
            Integer n = (Integer)view.getTag();
            this.chooseActivity(n);
            Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.BUTTON);
        }
    }

    public static interface OnTargetSelectedListener {
        public void onTargetSelected();
    }
}

