/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuInflater;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.menu.MenuPopup;

public class GeckoPopupMenu
implements GeckoMenu.Callback,
GeckoMenu.MenuPresenter {
    private View mAnchor;
    private MenuPopup mMenuPopup;
    private MenuPanel mMenuPanel;
    private GeckoMenu mMenu;
    private GeckoMenuInflater mMenuInflater;
    private OnDismissListener mDismissListener;
    private OnMenuItemClickListener mClickListener;
    private OnMenuItemLongClickListener mLongClickListener;

    public GeckoPopupMenu(Context context) {
        this.initialize(context, null);
    }

    public GeckoPopupMenu(Context context, View view) {
        this.initialize(context, view);
    }

    private void initialize(Context context, View view) {
        this.mMenu = new GeckoMenu(context, null);
        this.mMenu.setCallback(this);
        this.mMenu.setMenuPresenter(this);
        this.mMenuInflater = new GeckoMenuInflater(context);
        this.mMenuPopup = new MenuPopup(context);
        this.mMenuPanel = new MenuPanel(context, null);
        this.mMenuPanel.addView((View)this.mMenu);
        this.mMenuPopup.setPanelView((View)this.mMenuPanel);
        this.setAnchor(view);
    }

    public Menu getMenu() {
        return this.mMenu;
    }

    public MenuInflater getMenuInflater() {
        return this.mMenuInflater;
    }

    public void inflate(int n) {
        if (n > 0) {
            this.mMenuInflater.inflate(n, this.mMenu);
        }
    }

    public void setAnchor(View view) {
        this.mAnchor = view;
        if (this.mMenuPopup.isShowing()) {
            this.mMenuPopup.dismiss();
            this.mMenuPopup.showAsDropDown(this.mAnchor);
        }
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        this.mClickListener = onMenuItemClickListener;
    }

    public void setOnMenuItemLongClickListener(OnMenuItemLongClickListener onMenuItemLongClickListener) {
        this.mLongClickListener = onMenuItemLongClickListener;
    }

    public void show() {
        if (!this.mMenuPopup.isShowing()) {
            this.mMenuPopup.showAsDropDown(this.mAnchor);
        }
    }

    public void dismiss() {
        if (this.mMenuPopup.isShowing()) {
            this.mMenuPopup.dismiss();
            if (this.mDismissListener != null) {
                this.mDismissListener.onDismiss(this.mMenu);
            }
        }
    }

    @Override
    public boolean onMenuItemClick(MenuItem menuItem) {
        if (this.mClickListener != null) {
            return this.mClickListener.onMenuItemClick(menuItem);
        }
        return false;
    }

    @Override
    public boolean onMenuItemLongClick(MenuItem menuItem) {
        if (this.mLongClickListener != null) {
            return this.mLongClickListener.onMenuItemLongClick(menuItem);
        }
        return false;
    }

    @Override
    public void openMenu() {
        this.show();
    }

    @Override
    public void showMenu(View view) {
        this.mMenuPanel.removeAllViews();
        this.mMenuPanel.addView(view);
        this.openMenu();
    }

    @Override
    public void closeMenu() {
        this.dismiss();
    }

    public static interface OnMenuItemLongClickListener {
        public boolean onMenuItemLongClick(MenuItem var1);
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }

    public static interface OnDismissListener {
        public boolean onDismiss(GeckoMenu var1);
    }
}

