/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;
import org.webrtc.videoengine.CaptureCapabilityAndroid;

public class VideoCaptureDeviceInfoAndroid {
    private static final String TAG = "WEBRTC-JC";

    private static boolean isFrontFacing(Camera.CameraInfo cameraInfo) {
        return cameraInfo.facing == 1;
    }

    private static String deviceUniqueName(int n, Camera.CameraInfo cameraInfo) {
        return "Camera " + n + ", Facing " + (VideoCaptureDeviceInfoAndroid.isFrontFacing(cameraInfo) ? "front" : "back") + ", Orientation " + cameraInfo.orientation;
    }

    @WebRTCJNITarget
    private static CaptureCapabilityAndroid[] getDeviceInfo() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 1;
        if (Build.VERSION.SDK_INT >= 9) {
            n = Camera.getNumberOfCameras();
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            String string = null;
            Camera.CameraInfo cameraInfo = null;
            if (Build.VERSION.SDK_INT >= 9) {
                cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                string = VideoCaptureDeviceInfoAndroid.deviceUniqueName(i, cameraInfo);
            } else {
                string = "Camera 0, Facing back, Orientation 90";
            }
            List list = null;
            ArrayList<Object> arrayList2 = null;
            try {
                Camera camera = null;
                camera = Build.VERSION.SDK_INT >= 9 ? Camera.open((int)i) : Camera.open();
                Camera.Parameters parameters = camera.getParameters();
                list = parameters.getSupportedPreviewSizes();
                if (Build.VERSION.SDK_INT >= 9) {
                    arrayList2 = parameters.getSupportedPreviewFpsRange();
                }
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Object>();
                    object3 = parameters.getSupportedPreviewFrameRates();
                    if (object3 != null) {
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            Integer n2 = (Integer)object2.next();
                            object = new int[]{n2 * 1000, n2 * 1000};
                            arrayList2.add(object);
                        }
                    } else {
                        Log.e((String)TAG, (String)"Camera doesn't know its own framerate, guessing 30fps.");
                        int[] nArray = new int[]{30000, 30000};
                        arrayList2.add(nArray);
                    }
                }
                camera.release();
                Log.d((String)TAG, (String)string);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)TAG, (String)("Failed to open " + string + ", skipping due to: " + runtimeException.getLocalizedMessage()));
                continue;
            }
            boolean bl = false;
            boolean bl2 = false;
            object3 = arrayList2.iterator();
            while (object3.hasNext()) {
                object2 = (int[])object3.next();
                if (object2[0] == 30000 && object2[1] == 30000) {
                    bl = true;
                }
                if (object2[0] != 15000 || object2[1] != 15000) continue;
                bl2 = true;
            }
            if (bl && !bl2) {
                Log.d((String)TAG, (String)"Adding 15 fps support");
                object3 = new int[2];
                object3[0] = 15000;
                object3[1] = 15000;
                arrayList2.add(object3);
            }
            object3 = new CaptureCapabilityAndroid();
            int n3 = list.size();
            ((CaptureCapabilityAndroid)object3).width = new int[n3];
            ((CaptureCapabilityAndroid)object3).height = new int[n3];
            int n4 = 0;
            object = list.iterator();
            while (object.hasNext()) {
                Camera.Size size = (Camera.Size)object.next();
                ((CaptureCapabilityAndroid)object3).width[n4] = size.width;
                ((CaptureCapabilityAndroid)object3).height[n4] = size.height;
                ++n4;
            }
            object = (int[])arrayList2.get(arrayList2.size() - 1);
            ((CaptureCapabilityAndroid)object3).name = string;
            if (Build.VERSION.SDK_INT >= 9) {
                ((CaptureCapabilityAndroid)object3).frontFacing = VideoCaptureDeviceInfoAndroid.isFrontFacing(cameraInfo);
                ((CaptureCapabilityAndroid)object3).orientation = cameraInfo.orientation;
                ((CaptureCapabilityAndroid)object3).minMilliFPS = object[0];
                ((CaptureCapabilityAndroid)object3).maxMilliFPS = object[1];
            } else {
                ((CaptureCapabilityAndroid)object3).frontFacing = false;
                ((CaptureCapabilityAndroid)object3).orientation = 90;
                ((CaptureCapabilityAndroid)object3).minMilliFPS = object[0];
                ((CaptureCapabilityAndroid)object3).maxMilliFPS = object[1];
            }
            arrayList.add(object3);
        }
        return arrayList.toArray(new CaptureCapabilityAndroid[0]);
    }
}

