/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.JSONUtils;
import org.mozilla.gecko.util.WebActivityMapper;

public final class IntentHelper
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoIntentHelper";
    private static final String[] EVENTS = new String[]{"Intent:GetHandlers", "Intent:Open", "Intent:OpenForResult", "Intent:OpenNoHandler", "WebActivity:Open"};
    private static String MARKET_INTENT_URI_PACKAGE_PREFIX = "market://details?id=";
    private static String EXTRA_BROWSER_FALLBACK_URL = "browser_fallback_url";
    private static IntentHelper instance;
    private final Activity activity;

    private IntentHelper(Activity activity) {
        this.activity = activity;
        EventDispatcher.getInstance().registerGeckoThreadListener(this, EVENTS);
    }

    public static IntentHelper init(Activity activity) {
        if (instance == null) {
            instance = new IntentHelper(activity);
        } else {
            Log.w((String)LOGTAG, (String)"IntentHelper.init() called twice, ignoring.");
        }
        return instance;
    }

    public static void destroy() {
        if (instance != null) {
            EventDispatcher.getInstance().unregisterGeckoThreadListener(instance, EVENTS);
            instance = null;
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Intent:GetHandlers")) {
                this.getHandlers(jSONObject);
            } else if (string2.equals("Intent:Open")) {
                this.open(jSONObject);
            } else if (string2.equals("Intent:OpenForResult")) {
                this.openForResult(jSONObject);
            } else if (string2.equals("Intent:OpenNoHandler")) {
                this.openNoHandler(jSONObject);
            } else if (string2.equals("WebActivity:Open")) {
                this.openWebActivity(jSONObject);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)jSONException);
        }
    }

    private void getHandlers(JSONObject jSONObject) throws JSONException {
        Intent intent = GeckoAppShell.getOpenURIIntent((Context)this.activity, jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("action"), jSONObject.optString("title"));
        List<String> list = Arrays.asList(GeckoAppShell.getHandlersForIntent(intent));
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("apps", (Object)new JSONArray(list));
        EventDispatcher.sendResponse(jSONObject, jSONObject2);
    }

    private void open(JSONObject jSONObject) throws JSONException {
        GeckoAppShell.openUriExternal(jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("packageName"), jSONObject.optString("className"), jSONObject.optString("action"), jSONObject.optString("title"));
    }

    private void openForResult(JSONObject jSONObject) throws JSONException {
        Intent intent = GeckoAppShell.getOpenURIIntent((Context)this.activity, jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("action"), jSONObject.optString("title"));
        intent.setClassName(jSONObject.optString("packageName"), jSONObject.optString("className"));
        intent.setFlags(0x4000000);
        ResultHandler resultHandler = new ResultHandler(jSONObject);
        try {
            ActivityHandlerHelper.startIntentForActivity(this.activity, intent, resultHandler);
        }
        catch (SecurityException securityException) {
            Log.w((String)LOGTAG, (String)"Forbidden to launch activity.", (Throwable)securityException);
        }
    }

    private void openNoHandler(JSONObject jSONObject) {
        Intent intent;
        String string2 = jSONObject.optString("uri");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.displayToastCannotOpenLink();
            Log.w((String)LOGTAG, (String)"Received empty URL. Ignoring...");
            return;
        }
        try {
            intent = Intent.parseUri((String)string2, (int)0);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.displayToastCannotOpenLink();
            Log.w((String)LOGTAG, (String)"Unable to parse Intent URI");
            return;
        }
        if (intent.getPackage() != null) {
            String string3 = MARKET_INTENT_URI_PACKAGE_PREFIX + intent.getPackage();
            Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)string3));
            intent2.addCategory("android.intent.category.BROWSABLE");
            intent2.addFlags(0x10000000);
            this.activity.startActivity(intent2);
        } else if (intent.hasExtra(EXTRA_BROWSER_FALLBACK_URL)) {
            String string4 = intent.getStringExtra(EXTRA_BROWSER_FALLBACK_URL);
            Tabs.getInstance().loadUrl(string4);
        } else {
            this.displayToastCannotOpenLink();
            Log.w((String)LOGTAG, (String)"Unable to handle URI");
        }
    }

    private void displayToastCannotOpenLink() {
        String string2 = this.activity.getResources().getString(R.string.intent_uri_cannot_open);
        Toast.makeText((Context)this.activity, (CharSequence)string2, (int)1).show();
    }

    private void openWebActivity(JSONObject jSONObject) throws JSONException {
        Intent intent = WebActivityMapper.getIntentForWebActivity((JSONObject)jSONObject.getJSONObject("activity"));
        ActivityHandlerHelper.startIntentForActivity(this.activity, intent, new ResultHandler(jSONObject));
    }

    private static class ResultHandler
    implements ActivityResultHandler {
        private final JSONObject message;

        public ResultHandler(JSONObject jSONObject) {
            this.message = jSONObject;
        }

        public void onActivityResult(int n, Intent intent) {
            JSONObject jSONObject = new JSONObject();
            try {
                if (intent != null) {
                    jSONObject.put("extras", (Object)JSONUtils.bundleToJSON((Bundle)intent.getExtras()));
                    jSONObject.put("uri", (Object)intent.getData().toString());
                }
                jSONObject.put("resultCode", n);
            }
            catch (JSONException jSONException) {
                Log.w((String)IntentHelper.LOGTAG, (String)"Error building JSON response.", (Throwable)jSONException);
            }
            EventDispatcher.sendResponse(this.message, jSONObject);
        }
    }
}

