/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.firstrun;

import android.content.Context;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ObjectAnimator;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.TransitionsTracker;
import org.mozilla.gecko.firstrun.FirstrunPager;

public class FirstrunPane
extends LinearLayout {
    public static final String PREF_FIRSTRUN_ENABLED = "startpane_enabled";
    private FirstrunPager pager;
    private boolean visible;
    private OnFinishListener onFinishListener;

    public FirstrunPane(Context context) {
        this(context, null);
    }

    public FirstrunPane(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void load(FragmentManager fragmentManager) {
        this.visible = true;
        this.pager = (FirstrunPager)this.findViewById(R.id.firstrun_pager);
        this.pager.load(fragmentManager, new OnFinishListener(){

            @Override
            public void onFinish() {
                FirstrunPane.this.hide();
            }
        });
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void hide() {
        this.visible = false;
        this.pager.hide();
        if (this.onFinishListener != null) {
            this.onFinishListener.onFinish();
        }
        this.animateHide();
    }

    private void animateHide() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f});
        objectAnimator.setDuration(150L);
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                FirstrunPane.this.setVisibility(8);
            }
        });
        TransitionsTracker.track((Animator)objectAnimator);
        objectAnimator.start();
    }

    public void registerOnFinishListener(OnFinishListener onFinishListener) {
        this.onFinishListener = onFinishListener;
    }

    public static interface OnFinishListener {
        public void onFinish();
    }
}

