/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mdns;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import android.util.Log;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.mdns.DiscoveryListener;
import org.mozilla.gecko.mdns.MulticastDNSManager;
import org.mozilla.gecko.mdns.RegistrationListener;
import org.mozilla.gecko.mdns.ResolveListener;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;

class NsdMulticastDNSManager
extends MulticastDNSManager
implements NativeEventListener {
    private final NsdManager nsdManager;
    private DiscoveryListener mDiscoveryListener = null;
    private RegistrationListener mRegistrationListener = null;

    @TargetApi(value=16)
    public NsdMulticastDNSManager(Context context) {
        this.nsdManager = (NsdManager)context.getSystemService("servicediscovery");
    }

    @Override
    public void init() {
        this.registerEvents();
    }

    @Override
    public void tearDown() {
        this.unregisterEvents();
    }

    private void registerEvents() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "NsdManager:DiscoverServices", "NsdManager:StopServiceDiscovery", "NsdManager:RegisterService", "NsdManager:UnregisterService", "NsdManager:ResolveService");
    }

    private void unregisterEvents() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "NsdManager:DiscoverServices", "NsdManager:StopServiceDiscovery", "NsdManager:RegisterService", "NsdManager:UnregisterService", "NsdManager:ResolveService");
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        Log.v((String)"GeckoMDNSManager", (String)("handleMessage: " + string2));
        switch (string2) {
            case "NsdManager:DiscoverServices": {
                if (this.mDiscoveryListener != null) {
                    this.mDiscoveryListener.stopServiceDiscovery(null);
                }
                this.mDiscoveryListener = new DiscoveryListener(this.nsdManager);
                this.mDiscoveryListener.discoverServices(nativeJSObject.getString("serviceType"), eventCallback);
                break;
            }
            case "NsdManager:StopServiceDiscovery": {
                if (this.mDiscoveryListener == null) break;
                this.mDiscoveryListener.stopServiceDiscovery(eventCallback);
                this.mDiscoveryListener = null;
                break;
            }
            case "NsdManager:RegisterService": {
                if (this.mRegistrationListener != null) {
                    this.mRegistrationListener.unregisterService(null);
                }
                this.mRegistrationListener = new RegistrationListener(this.nsdManager);
                this.mRegistrationListener.registerService(nativeJSObject.getInt("port"), nativeJSObject.optString("serviceName", Build.MODEL), nativeJSObject.getString("serviceType"), this.parseAttributes(nativeJSObject.optObjectArray("attributes", null)), eventCallback);
                break;
            }
            case "NsdManager:UnregisterService": {
                if (this.mRegistrationListener == null) break;
                this.mRegistrationListener.unregisterService(eventCallback);
                this.mRegistrationListener = null;
                break;
            }
            case "NsdManager:ResolveService": {
                new ResolveListener(this.nsdManager).resolveService(nativeJSObject.getString("serviceName"), nativeJSObject.getString("serviceType"), eventCallback);
            }
        }
    }

    private Map<String, String> parseAttributes(NativeJSObject[] nativeJSObjectArray) {
        if (nativeJSObjectArray == null || nativeJSObjectArray.length == 0 || !AppConstants.Versions.feature21Plus) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(nativeJSObjectArray.length);
        for (NativeJSObject nativeJSObject : nativeJSObjectArray) {
            hashMap.put(nativeJSObject.getString("name"), nativeJSObject.getString("value"));
        }
        return hashMap;
    }

    @TargetApi(value=16)
    public static JSONObject toJSON(NsdServiceInfo nsdServiceInfo) throws JSONException {
        String string2;
        String string3;
        int n;
        JSONObject jSONObject = new JSONObject();
        InetAddress inetAddress = nsdServiceInfo.getHost();
        if (inetAddress != null) {
            jSONObject.put("host", (Object)inetAddress.getHostName());
        }
        if ((n = nsdServiceInfo.getPort()) != 0) {
            jSONObject.put("port", n);
        }
        if ((string3 = nsdServiceInfo.getServiceName()) != null) {
            jSONObject.put("serviceName", (Object)string3);
        }
        if ((string2 = nsdServiceInfo.getServiceType()) != null) {
            jSONObject.put("serviceType", (Object)string2);
        }
        return jSONObject;
    }
}

