/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import android.os.Build;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CommandProcessor;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.NoCollectionKeysSetException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.ClientsDataDelegate;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.SyncStorageCollectionRequest;
import org.mozilla.gecko.sync.net.SyncStorageRecordRequest;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.sync.net.WBOCollectionRequestDelegate;
import org.mozilla.gecko.sync.net.WBORequestDelegate;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.ClientsDatabaseAccessor;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.ClientRecord;
import org.mozilla.gecko.sync.repositories.domain.ClientRecordFactory;
import org.mozilla.gecko.sync.stage.AbstractSessionManagingSyncStage;
import org.mozilla.gecko.sync.stage.NoSuchStageException;

public class SyncClientsEngineStage
extends AbstractSessionManagingSyncStage {
    private static final String LOG_TAG = "SyncClientsEngineStage";
    public static final String COLLECTION_NAME = "clients";
    public static final String STAGE_NAME = "clients";
    public static final int CLIENTS_TTL_REFRESH = 604800000;
    public static final int MAX_UPLOAD_FAILURE_COUNT = 5;
    protected final ClientRecordFactory factory = new ClientRecordFactory();
    protected ClientUploadDelegate clientUploadDelegate;
    protected ClientDownloadDelegate clientDownloadDelegate;
    protected ClientsDatabaseAccessor db;
    protected volatile boolean shouldWipe;
    protected volatile boolean shouldUploadLocalRecord;
    protected final AtomicInteger uploadAttemptsCount = new AtomicInteger();
    protected final List<ClientRecord> toUpload = new ArrayList<ClientRecord>();

    protected int getClientsCount() {
        return this.getClientsDatabaseAccessor().clientsCount();
    }

    protected synchronized ClientsDatabaseAccessor getClientsDatabaseAccessor() {
        if (this.db == null) {
            this.db = new ClientsDatabaseAccessor(this.session.getContext());
        }
        return this.db;
    }

    protected synchronized void closeDataAccessor() {
        if (this.db == null) {
            return;
        }
        this.db.close();
        this.db = null;
    }

    @Override
    public void execute() throws NoSuchStageException {
        boolean bl = this.session.isEngineLocallyEnabled("clients");
        if (!bl) {
            Logger.debug(LOG_TAG, "Stage clients disabled just for this sync.");
            Logger.info(LOG_TAG, "Skipping stage clients.");
            this.session.advance();
            return;
        }
        if (this.shouldDownload()) {
            this.downloadClientRecords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetLocal() {
        this.session.config.persistServerClientRecordTimestamp(0L);
        this.session.config.persistServerClientsTimestamp(0L);
        this.session.getClientsDelegate().setClientsCount(0);
        try {
            this.getClientsDatabaseAccessor().wipeDB();
        }
        finally {
            this.closeDataAccessor();
        }
    }

    @Override
    protected void wipeLocal() throws Exception {
        this.resetLocal();
    }

    @Override
    public Integer getStorageVersion() {
        return 1;
    }

    protected String getLocalClientVersion() {
        return "42.0a1";
    }

    protected JSONArray getLocalClientProtocols() {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)"1.1");
        jSONArray.add((Object)"1.5");
        return jSONArray;
    }

    protected ClientRecord newLocalClientRecord(ClientsDataDelegate clientsDataDelegate) {
        String string2 = clientsDataDelegate.getAccountGUID();
        String string3 = clientsDataDelegate.getClientName();
        ClientRecord clientRecord = new ClientRecord(string2);
        clientRecord.name = string3;
        clientRecord.version = this.getLocalClientVersion();
        clientRecord.protocols = this.getLocalClientProtocols();
        clientRecord.os = "Android";
        clientRecord.application = "Nightly";
        clientRecord.appPackage = "org.mozilla.fennec";
        clientRecord.device = Build.MODEL;
        clientRecord.formfactor = clientsDataDelegate.getFormFactor();
        return clientRecord;
    }

    protected boolean shouldDownload() {
        return true;
    }

    protected boolean shouldUpload() {
        if (this.shouldUploadLocalRecord) {
            return true;
        }
        long l = this.session.config.getPersistedServerClientRecordTimestamp();
        if (l == 0L) {
            return true;
        }
        if (this.session.getClientsDelegate().getLastModifiedTimestamp() > l) {
            return true;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        return l3 >= 604800000L;
    }

    protected void handleDownloadedLocalRecord(ClientRecord clientRecord) {
        this.session.config.persistServerClientRecordTimestamp(clientRecord.lastModified);
        if (!this.getLocalClientVersion().equals(clientRecord.version) || !this.getLocalClientProtocols().equals((Object)clientRecord.protocols)) {
            this.shouldUploadLocalRecord = true;
        }
        this.processCommands(clientRecord.commands);
    }

    protected void processCommands(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.size() == 0) {
            return;
        }
        this.shouldUploadLocalRecord = true;
        CommandProcessor commandProcessor = CommandProcessor.getProcessor();
        for (Object e : jSONArray) {
            commandProcessor.processCommand(this.session, new ExtendedJSONObject((JSONObject)e));
        }
    }

    protected void addCommands(ClientRecord clientRecord) throws NullCursorException {
        Logger.trace(LOG_TAG, "Adding commands to " + clientRecord.guid);
        List<CommandProcessor.Command> list = this.db.fetchCommandsForClient(clientRecord.guid);
        if (list == null || list.size() == 0) {
            Logger.trace(LOG_TAG, "No commands to add.");
            return;
        }
        for (CommandProcessor.Command command : list) {
            JSONObject jSONObject = command.asJSONObject();
            if (clientRecord.commands == null) {
                clientRecord.commands = new JSONArray();
            }
            clientRecord.commands.add((Object)jSONObject);
        }
        this.toUpload.add(clientRecord);
    }

    protected void uploadRemoteRecords() {
        Object object;
        Logger.trace(LOG_TAG, "In uploadRemoteRecords. Uploading " + this.toUpload.size() + " records");
        for (ClientRecord object2 : this.toUpload) {
            Logger.trace(LOG_TAG, ">> Uploading record " + object2.guid + ": " + object2.name);
        }
        if (this.toUpload.size() == 1) {
            object = this.toUpload.get(0);
            Logger.debug(LOG_TAG, "Only 1 remote record to upload.");
            Logger.debug(LOG_TAG, "Record last modified: " + object.lastModified);
            CryptoRecord cryptoRecord = this.encryptClientRecord((ClientRecord)object);
            if (cryptoRecord != null) {
                this.clientUploadDelegate.setUploadDetails(false);
                this.uploadClientRecord(cryptoRecord);
            }
            return;
        }
        object = new JSONArray();
        for (ClientRecord clientRecord : this.toUpload) {
            Logger.trace(LOG_TAG, "Record " + clientRecord.guid + " is being uploaded");
            CryptoRecord cryptoRecord = this.encryptClientRecord(clientRecord);
            object.add((Object)cryptoRecord.toJSONObject());
        }
        Logger.debug(LOG_TAG, "Uploading records: " + object.size());
        this.clientUploadDelegate.setUploadDetails(false);
        this.uploadClientRecords((JSONArray)object);
    }

    protected void checkAndUpload() {
        if (!this.shouldUpload()) {
            Logger.debug(LOG_TAG, "Not uploading client record.");
            this.session.advance();
            return;
        }
        ClientRecord clientRecord = this.newLocalClientRecord(this.session.getClientsDelegate());
        this.clientUploadDelegate.setUploadDetails(true);
        CryptoRecord cryptoRecord = this.encryptClientRecord(clientRecord);
        if (cryptoRecord != null) {
            this.uploadClientRecord(cryptoRecord);
        }
    }

    protected CryptoRecord encryptClientRecord(ClientRecord clientRecord) {
        try {
            CryptoRecord cryptoRecord = clientRecord.getEnvelope();
            cryptoRecord.keyBundle = this.clientUploadDelegate.keyBundle();
            if (cryptoRecord.keyBundle == null) {
                this.session.abort(new NoCollectionKeysSetException(), "No collection keys set.");
                return null;
            }
            return cryptoRecord.encrypt();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.session.abort(unsupportedEncodingException, "Couldn't encrypt new client record. Unsupported encoding.");
        }
        catch (CryptoException cryptoException) {
            this.session.abort(cryptoException, "Couldn't encrypt new client record.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecordsToUpload() {
        try {
            this.getClientsDatabaseAccessor().wipeCommandsTable();
            this.toUpload.clear();
        }
        finally {
            this.closeDataAccessor();
        }
    }

    protected void downloadClientRecords() {
        this.shouldWipe = true;
        this.clientDownloadDelegate = this.makeClientDownloadDelegate();
        try {
            URI uRI = this.session.config.collectionURI("clients", true);
            SyncStorageCollectionRequest syncStorageCollectionRequest = new SyncStorageCollectionRequest(uRI);
            syncStorageCollectionRequest.delegate = this.clientDownloadDelegate;
            Logger.trace(LOG_TAG, "Downloading client records.");
            syncStorageCollectionRequest.get();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.session.abort(uRISyntaxException, "Invalid URI.");
        }
    }

    protected void uploadClientRecords(JSONArray jSONArray) {
        Logger.trace(LOG_TAG, "Uploading " + jSONArray.size() + " client records.");
        try {
            URI uRI = this.session.config.collectionURI("clients", false);
            SyncStorageRecordRequest syncStorageRecordRequest = new SyncStorageRecordRequest(uRI);
            syncStorageRecordRequest.delegate = this.clientUploadDelegate;
            syncStorageRecordRequest.post(jSONArray);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.session.abort(uRISyntaxException, "Invalid URI.");
        }
        catch (Exception exception) {
            this.session.abort(exception, "Unable to parse body.");
        }
    }

    protected void uploadClientRecord(CryptoRecord cryptoRecord) {
        Logger.debug(LOG_TAG, "Uploading client record " + cryptoRecord.guid);
        try {
            URI uRI = this.session.config.collectionURI("clients");
            SyncStorageRecordRequest syncStorageRecordRequest = new SyncStorageRecordRequest(uRI);
            syncStorageRecordRequest.delegate = this.clientUploadDelegate;
            syncStorageRecordRequest.post(cryptoRecord);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.session.abort(uRISyntaxException, "Invalid URI.");
        }
    }

    protected ClientDownloadDelegate makeClientDownloadDelegate() {
        return new ClientDownloadDelegate();
    }

    protected void wipeAndStore(ClientRecord clientRecord) {
        ClientsDatabaseAccessor clientsDatabaseAccessor = this.getClientsDatabaseAccessor();
        if (this.shouldWipe) {
            clientsDatabaseAccessor.wipeClientsTable();
            this.shouldWipe = false;
        }
        if (clientRecord != null) {
            clientsDatabaseAccessor.store(clientRecord);
        }
    }

    public class ClientUploadDelegate
    extends WBORequestDelegate {
        protected static final String LOG_TAG = "ClientUploadDelegate";
        public Long currentlyUploadingRecordTimestamp;
        public boolean currentlyUploadingLocalRecord;

        @Override
        public AuthHeaderProvider getAuthHeaderProvider() {
            return SyncClientsEngineStage.this.session.getAuthHeaderProvider();
        }

        private void setUploadDetails(boolean bl) {
            this.currentlyUploadingRecordTimestamp = SyncClientsEngineStage.this.session.config.getPersistedServerClientsTimestamp();
            this.currentlyUploadingLocalRecord = bl;
        }

        @Override
        public String ifUnmodifiedSince() {
            Long l = this.currentlyUploadingRecordTimestamp;
            if (l <= 0L) {
                return null;
            }
            return Utils.millisecondsToDecimalSecondsString(l);
        }

        @Override
        public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
            Logger.debug(LOG_TAG, "Upload succeeded.");
            SyncClientsEngineStage.this.uploadAttemptsCount.set(0);
            long l = syncStorageResponse.normalizedWeaveTimestamp();
            Logger.trace(LOG_TAG, "Timestamp from header is: " + l);
            if (l == -1L) {
                SyncClientsEngineStage.this.session.abort(new RuntimeException("Response did not contain a valid timestamp."), "Response did not contain a valid timestamp.");
                return;
            }
            BaseResource.consumeEntity(syncStorageResponse);
            SyncClientsEngineStage.this.session.config.persistServerClientsTimestamp(l);
            if (!this.currentlyUploadingLocalRecord) {
                SyncClientsEngineStage.this.clearRecordsToUpload();
                SyncClientsEngineStage.this.checkAndUpload();
                return;
            }
            SyncClientsEngineStage.this.shouldUploadLocalRecord = false;
            SyncClientsEngineStage.this.session.config.persistServerClientRecordTimestamp(l);
            SyncClientsEngineStage.this.session.advance();
        }

        @Override
        public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
            int n = syncStorageResponse.getStatusCode();
            if (!SyncClientsEngineStage.this.shouldUploadLocalRecord || n == 412 || SyncClientsEngineStage.this.uploadAttemptsCount.incrementAndGet() > 5) {
                Logger.debug(LOG_TAG, "Client upload failed. Aborting sync.");
                if (!this.currentlyUploadingLocalRecord) {
                    SyncClientsEngineStage.this.toUpload.clear();
                }
                BaseResource.consumeEntity(syncStorageResponse);
                SyncClientsEngineStage.this.session.abort(new HTTPFailureException(syncStorageResponse), "Client upload failed.");
                return;
            }
            Logger.trace(LOG_TAG, "Retrying upload\u2026");
            SyncClientsEngineStage.this.checkAndUpload();
        }

        @Override
        public void handleRequestError(Exception exception) {
            Logger.info(LOG_TAG, "Client upload error. Aborting sync.");
            SyncClientsEngineStage.this.session.abort(exception, "Client upload failed.");
        }

        @Override
        public KeyBundle keyBundle() {
            try {
                return SyncClientsEngineStage.this.session.keyBundleForCollection("clients");
            }
            catch (NoCollectionKeysSetException noCollectionKeysSetException) {
                return null;
            }
        }
    }

    public class ClientDownloadDelegate
    extends WBOCollectionRequestDelegate {
        final ClientsDataDelegate clientsDelegate;
        boolean localAccountGUIDDownloaded;

        public ClientDownloadDelegate() {
            this.clientsDelegate = SyncClientsEngineStage.this.session.getClientsDelegate();
            this.localAccountGUIDDownloaded = false;
        }

        @Override
        public AuthHeaderProvider getAuthHeaderProvider() {
            return SyncClientsEngineStage.this.session.getAuthHeaderProvider();
        }

        @Override
        public String ifUnmodifiedSince() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
            int n;
            SyncClientsEngineStage.this.session.config.persistServerClientsTimestamp(syncStorageResponse.normalizedWeaveTimestamp());
            BaseResource.consumeEntity(syncStorageResponse);
            SyncClientsEngineStage.this.wipeAndStore(null);
            if (!this.localAccountGUIDDownloaded) {
                Logger.info(SyncClientsEngineStage.LOG_TAG, "Local client GUID does not exist on the server. Upload timestamp will be reset.");
                SyncClientsEngineStage.this.session.config.persistServerClientRecordTimestamp(0L);
            }
            this.localAccountGUIDDownloaded = false;
            try {
                n = SyncClientsEngineStage.this.getClientsCount();
            }
            finally {
                SyncClientsEngineStage.this.closeDataAccessor();
            }
            Logger.debug(SyncClientsEngineStage.LOG_TAG, "Database contains " + n + " clients.");
            Logger.debug(SyncClientsEngineStage.LOG_TAG, "Server response asserts " + syncStorageResponse.weaveRecords() + " records.");
            SyncClientsEngineStage.this.clientUploadDelegate = new ClientUploadDelegate();
            this.clientsDelegate.setClientsCount(n);
            if (SyncClientsEngineStage.this.toUpload.size() > 0) {
                SyncClientsEngineStage.this.uploadRemoteRecords();
                return;
            }
            SyncClientsEngineStage.this.checkAndUpload();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
            BaseResource.consumeEntity(syncStorageResponse);
            this.localAccountGUIDDownloaded = false;
            try {
                Logger.info(SyncClientsEngineStage.LOG_TAG, "Client upload failed. Aborting sync.");
                SyncClientsEngineStage.this.session.abort(new HTTPFailureException(syncStorageResponse), "Client download failed.");
            }
            finally {
                SyncClientsEngineStage.this.closeDataAccessor();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleRequestError(Exception exception) {
            this.localAccountGUIDDownloaded = false;
            try {
                Logger.info(SyncClientsEngineStage.LOG_TAG, "Client upload error. Aborting sync.");
                SyncClientsEngineStage.this.session.abort(exception, "Failure fetching client record.");
            }
            finally {
                SyncClientsEngineStage.this.closeDataAccessor();
            }
        }

        @Override
        public void handleWBO(CryptoRecord cryptoRecord) {
            try {
                ClientRecord clientRecord = (ClientRecord)SyncClientsEngineStage.this.factory.createRecord(cryptoRecord.decrypt());
                if (this.clientsDelegate.isLocalGUID(clientRecord.guid)) {
                    Logger.info(SyncClientsEngineStage.LOG_TAG, "Local client GUID exists on server and was downloaded.");
                    this.localAccountGUIDDownloaded = true;
                    SyncClientsEngineStage.this.handleDownloadedLocalRecord(clientRecord);
                } else {
                    SyncClientsEngineStage.this.wipeAndStore(clientRecord);
                    SyncClientsEngineStage.this.addCommands(clientRecord);
                }
                RepoUtils.logClient(clientRecord);
            }
            catch (Exception exception) {
                SyncClientsEngineStage.this.session.abort(exception, "Exception handling client WBO.");
                return;
            }
        }

        @Override
        public KeyBundle keyBundle() {
            try {
                return SyncClientsEngineStage.this.session.keyBundleForCollection("clients");
            }
            catch (NoCollectionKeysSetException noCollectionKeysSetException) {
                return null;
            }
        }
    }
}

