/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.PropertyValuesHolder;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.tabs.TabsLayoutAdapter;
import org.mozilla.gecko.tabs.TabsLayoutItemView;
import org.mozilla.gecko.tabs.TabsPanel;

class TabsGridLayout
extends GridView
implements TabsPanel.TabsLayout,
Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "Gecko" + TabsGridLayout.class.getSimpleName();
    public static final int ANIM_DELAY_MULTIPLE_MS = 20;
    private static final int ANIM_TIME_MS = 200;
    private static final DecelerateInterpolator ANIM_INTERPOLATOR = new DecelerateInterpolator();
    private final Context mContext;
    private final SparseArray<PointF> mTabLocations = new SparseArray();
    private final boolean mIsPrivate;
    private final TabsLayoutAdapter mTabsAdapter;
    private final int mColumnWidth;
    private TabsPanel mTabsPanel;
    private int lastSelectedTabId;

    public TabsGridLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, R.attr.tabGridLayoutViewStyle);
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabsLayout);
        this.mIsPrivate = typedArray.getInt(R.styleable.TabsLayout_tabs, 0) == 1;
        typedArray.recycle();
        this.mTabsAdapter = new TabsGridLayoutAdapter(this.mContext);
        this.setAdapter((ListAdapter)this.mTabsAdapter);
        this.setRecyclerListener(new AbsListView.RecyclerListener(){

            public void onMovedToScrapHeap(View view) {
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.setThumbnail(null);
            }
        });
        this.setClipToPadding(false);
        Resources resources = this.getResources();
        this.mColumnWidth = resources.getDimensionPixelSize(R.dimen.new_tablet_tab_panel_column_width);
        int n = resources.getDimensionPixelSize(R.dimen.new_tablet_tab_panel_grid_padding);
        int n2 = resources.getDimensionPixelSize(R.dimen.new_tablet_tab_panel_grid_padding_top);
        int n3 = n2 * 2;
        this.setPadding(n, n2, n, n3);
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                Tabs.getInstance().selectTab(tabsLayoutItemView.getTabId());
                TabsGridLayout.this.autoHidePanel();
            }
        });
        TabSwipeGestureListener tabSwipeGestureListener = new TabSwipeGestureListener();
        this.setOnTouchListener(tabSwipeGestureListener);
        this.setOnScrollListener(tabSwipeGestureListener.makeScrollListener());
    }

    private void populateTabLocations(Tab tab) {
        boolean bl;
        this.mTabLocations.clear();
        int n = this.getFirstVisiblePosition();
        int n2 = this.getLastVisiblePosition();
        int n3 = this.getNumColumns();
        int n4 = this.getChildCount();
        int n5 = this.mTabsAdapter.getPositionForTab(tab);
        int n6 = 1;
        int n7 = n5 - n + 1;
        while (n7 < n4) {
            View view = this.getChildAt(n7);
            if (view != null) {
                this.resetTransforms(view);
                this.mTabLocations.append(n6, (Object)new PointF(view.getX(), view.getY()));
            }
            ++n7;
            ++n6;
        }
        n6 = n > 0 || this.getChildAt(0).getY() < 0.0f ? 1 : 0;
        n7 = n2 - n4 == n - 1 ? 1 : 0;
        boolean bl2 = bl = n2 % n3 == 0;
        if (n6 != 0 && n7 != 0 && bl) {
            int n8 = this.getChildAt(0).getMeasuredHeight();
            int n9 = this.getResources().getDimensionPixelOffset(R.dimen.new_tablet_tab_panel_grid_vspacing);
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.getPaddingBottom() + n8 + n9, this.getPaddingBottom()});
            valueAnimator.setDuration(400L);
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    TabsGridLayout.this.setPadding(TabsGridLayout.this.getPaddingLeft(), TabsGridLayout.this.getPaddingTop(), TabsGridLayout.this.getPaddingRight(), (Integer)valueAnimator.getAnimatedValue());
                }
            });
            valueAnimator.start();
        }
    }

    @Override
    public void setTabsPanel(TabsPanel tabsPanel) {
        this.mTabsPanel = tabsPanel;
    }

    @Override
    public void show() {
        this.setVisibility(0);
        Tabs.getInstance().refreshThumbnails();
        Tabs.registerOnTabsChangedListener(this);
        this.refreshTabsData();
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (this.lastSelectedTabId != tab.getId()) {
            this.smoothScrollToPosition(this.mTabsAdapter.getPositionForTab(tab));
        }
    }

    @Override
    public void hide() {
        this.lastSelectedTabId = Tabs.getInstance().getSelectedTab().getId();
        this.setVisibility(8);
        Tabs.unregisterOnTabsChangedListener(this);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Screenshot:Cancel", ""));
        this.mTabsAdapter.clear();
    }

    @Override
    public boolean shouldExpand() {
        return true;
    }

    private void autoHidePanel() {
        this.mTabsPanel.autoHidePanel();
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case ADDED: {
                this.refreshTabsData();
                break;
            }
            case CLOSED: {
                if (this.mTabsAdapter.getCount() > 0) {
                    this.animateRemoveTab(tab);
                }
                Tabs tabs = Tabs.getInstance();
                if (!this.mTabsAdapter.removeTab(tab)) break;
                if (tab.isPrivate() == this.mIsPrivate && this.mTabsAdapter.getCount() > 0) {
                    int n = this.mTabsAdapter.getPositionForTab(tabs.getSelectedTab());
                    this.updateSelectedStyle(n);
                }
                if (tab.isPrivate()) break;
                Iterable<Tab> iterable = tabs.getTabsInOrder();
                boolean bl = true;
                for (Tab tab2 : iterable) {
                    if (tab2.isPrivate()) continue;
                    bl = false;
                    break;
                }
                if (!bl) break;
                tabs.addTab();
                break;
            }
            case SELECTED: {
                this.updateSelectedPosition();
            }
            case UNSELECTED: 
            case THUMBNAIL: 
            case TITLE: 
            case RECORDING_CHANGE: {
                View view = this.getChildAt(this.mTabsAdapter.getPositionForTab(tab) - this.getFirstVisiblePosition());
                if (view == null) {
                    return;
                }
                ((TabsLayoutItemView)view).assignValues(tab);
            }
        }
    }

    private void updateSelectedPosition() {
        int n = this.mTabsAdapter.getPositionForTab(Tabs.getInstance().getSelectedTab());
        this.updateSelectedStyle(n);
        if (n != -1) {
            this.setSelection(n);
        }
    }

    private void updateSelectedStyle(int n) {
        for (int i = 0; i < this.mTabsAdapter.getCount(); ++i) {
            this.setItemChecked(i, i == n);
        }
    }

    private void refreshTabsData() {
        ArrayList<Tab> arrayList = new ArrayList<Tab>();
        Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
        for (Tab tab : iterable) {
            if (tab.isPrivate() != this.mIsPrivate) continue;
            arrayList.add(tab);
        }
        this.mTabsAdapter.setTabs(arrayList);
        this.updateSelectedPosition();
    }

    private void resetTransforms(View view) {
        ViewHelper.setAlpha(view, 1.0f);
        ViewHelper.setTranslationX(view, 0.0f);
        ViewHelper.setTranslationY(view, 0.0f);
        ((TabsLayoutItemView)view).setCloseVisible(true);
    }

    @Override
    public void closeAll() {
        this.autoHidePanel();
        if (this.getChildCount() == 0) {
            return;
        }
        Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
        for (Tab tab : iterable) {
            if (this.mIsPrivate && !tab.isPrivate()) continue;
            Tabs.getInstance().closeTab(tab, false);
        }
    }

    private View getViewForTab(Tab tab) {
        int n = this.mTabsAdapter.getPositionForTab(tab);
        return this.getChildAt(n - this.getFirstVisiblePosition());
    }

    void closeTab(View view) {
        TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)((Object)view.getTag());
        Tab tab = Tabs.getInstance().getTab(tabsLayoutItemView.getTabId());
        Tabs.getInstance().closeTab(tab, true);
    }

    private void animateRemoveTab(Tab tab) {
        final int n = this.mTabsAdapter.getPositionForTab(tab);
        View view = this.getViewForTab(tab);
        if (view == null) {
            return;
        }
        final int n2 = view.getMeasuredHeight();
        this.populateTabLocations(tab);
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                View view;
                TabsGridLayout.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                int n7 = TabsGridLayout.this.getChildCount();
                int n22 = TabsGridLayout.this.getFirstVisiblePosition();
                int n3 = TabsGridLayout.this.getNumColumns();
                ArrayList<View> arrayList = new ArrayList<View>();
                int n4 = 0;
                int n5 = n - n22;
                while (n5 < n7) {
                    PropertyValuesHolder propertyValuesHolder;
                    View view2 = TabsGridLayout.this.getChildAt(n5);
                    if (n5 % n3 == n3 - 1) {
                        propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{-(TabsGridLayout.this.mColumnWidth * n3), 0.0f});
                        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{n2, 0.0f});
                        view = ObjectAnimator.ofPropertyValuesHolder((Object)view2, (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
                    } else {
                        propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{TabsGridLayout.this.mColumnWidth, 0.0f});
                        view = ObjectAnimator.ofPropertyValuesHolder((Object)view2, (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder});
                    }
                    view.setStartDelay((long)(n4 * 20));
                    arrayList.add(view);
                    ++n5;
                    ++n4;
                }
                AnimatorSet animatorSet = new AnimatorSet();
                animatorSet.playTogether(arrayList);
                animatorSet.setDuration(200L);
                animatorSet.setInterpolator((Interpolator)ANIM_INTERPOLATOR);
                animatorSet.start();
                n5 = 1;
                int n6 = n - n22 + 1;
                while (n6 < n7) {
                    view = TabsGridLayout.this.getChildAt(n6);
                    PointF pointF = (PointF)TabsGridLayout.this.mTabLocations.get(n5 + 1);
                    if (pointF != null) {
                        view.setX(pointF.x);
                        view.setY(pointF.y);
                    }
                    ++n6;
                    ++n5;
                }
                return true;
            }
        });
    }

    private void animateCancel(final View view) {
        PropertyAnimator propertyAnimator = new PropertyAnimator(200L);
        propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 1.0f);
        propertyAnimator.attach(view, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)view;
                tabsLayoutItemView.setCloseVisible(true);
            }
        });
        propertyAnimator.start();
    }

    private class TabSwipeGestureListener
    implements View.OnTouchListener {
        private static final float MIN_VELOCITY = 750.0f;
        private final int mSwipeThreshold;
        private final int mMinFlingVelocity;
        private final int mMaxFlingVelocity;
        private VelocityTracker mVelocityTracker;
        private int mTabWidth = 1;
        private View mSwipeView;
        private Runnable mPendingCheckForTap;
        private float mSwipeStartX;
        private boolean mSwiping;
        private boolean mEnabled = true;

        public TabSwipeGestureListener() {
            ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)TabsGridLayout.this.getContext());
            this.mSwipeThreshold = viewConfiguration.getScaledTouchSlop();
            this.mMinFlingVelocity = (int)(TabsGridLayout.this.getContext().getResources().getDisplayMetrics().density * 750.0f);
            this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        }

        public void setEnabled(boolean bl) {
            this.mEnabled = bl;
        }

        public AbsListView.OnScrollListener makeScrollListener() {
            return new AbsListView.OnScrollListener(){

                public void onScrollStateChanged(AbsListView absListView, int n) {
                    TabSwipeGestureListener.this.setEnabled(n != 1);
                }

                public void onScroll(AbsListView absListView, int n, int n2, int n3) {
                }
            };
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (!this.mEnabled) {
                return false;
            }
            switch (motionEvent.getActionMasked()) {
                case 0: {
                    this.triggerCheckForTap();
                    float f = motionEvent.getRawX();
                    float f2 = motionEvent.getRawY();
                    this.mSwipeView = this.findViewAt(f, f2);
                    if (this.mSwipeView != null) {
                        if (this.mTabWidth < 2) {
                            this.mTabWidth = this.mSwipeView.getWidth();
                        }
                        this.mSwipeStartX = motionEvent.getRawX();
                        this.mVelocityTracker = VelocityTracker.obtain();
                        this.mVelocityTracker.addMovement(motionEvent);
                    }
                    view.onTouchEvent(motionEvent);
                    return true;
                }
                case 1: {
                    if (this.mSwipeView == null) break;
                    this.cancelCheckForTap();
                    this.mSwipeView.setPressed(false);
                    if (!this.mSwiping) {
                        TabsLayoutItemView tabsLayoutItemView = (TabsLayoutItemView)this.mSwipeView;
                        Tabs.getInstance().selectTab(tabsLayoutItemView.getTabId());
                        TabsGridLayout.this.autoHidePanel();
                        this.mVelocityTracker.recycle();
                        this.mVelocityTracker = null;
                        break;
                    }
                    this.mVelocityTracker.addMovement(motionEvent);
                    this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                    float f = Math.abs(this.mVelocityTracker.getXVelocity());
                    boolean bl = false;
                    float f3 = ViewHelper.getTranslationX(this.mSwipeView);
                    if (Math.abs(f3) > (float)(this.mTabWidth / 2)) {
                        bl = true;
                    } else if ((float)this.mMinFlingVelocity <= f && f <= (float)this.mMaxFlingVelocity) {
                        boolean bl2 = bl = this.mSwiping && f3 * this.mVelocityTracker.getYVelocity() > 0.0f;
                    }
                    if (bl) {
                        TabsGridLayout.this.closeTab(this.mSwipeView.findViewById(R.id.close));
                    } else {
                        TabsGridLayout.this.animateCancel(this.mSwipeView);
                    }
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                    this.mSwipeView = null;
                    this.mSwipeStartX = 0.0f;
                    this.mSwiping = false;
                }
                case 2: {
                    boolean bl;
                    if (this.mSwipeView == null || this.mVelocityTracker == null) break;
                    this.mVelocityTracker.addMovement(motionEvent);
                    float f = motionEvent.getRawX() - this.mSwipeStartX;
                    boolean bl3 = bl = Math.abs(f) > (float)this.mSwipeThreshold;
                    if (bl) {
                        this.cancelCheckForTap();
                    }
                    if (bl3) {
                        this.mSwiping = true;
                        TabsGridLayout.this.requestDisallowInterceptTouchEvent(true);
                        ((TabsLayoutItemView)this.mSwipeView).setCloseVisible(false);
                        MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                        motionEvent2.setAction(3 | motionEvent.getActionIndex() << 8);
                        TabsGridLayout.this.onTouchEvent(motionEvent2);
                        motionEvent2.recycle();
                    }
                    if (!this.mSwiping) break;
                    ViewHelper.setTranslationX(this.mSwipeView, f);
                    ViewHelper.setAlpha(this.mSwipeView, Math.min(1.0f, 1.0f - 2.0f * Math.abs(f) / (float)this.mTabWidth));
                    return true;
                }
            }
            return false;
        }

        private View findViewAt(float f, float f2) {
            Rect rect = new Rect();
            int[] nArray = new int[2];
            TabsGridLayout.this.getLocationOnScreen(nArray);
            int n = (int)f - nArray[0];
            int n2 = (int)f2 - nArray[1];
            for (int i = 0; i < TabsGridLayout.this.getChildCount(); ++i) {
                View view = TabsGridLayout.this.getChildAt(i);
                view.getHitRect(rect);
                if (!rect.contains(n, n2)) continue;
                return view;
            }
            return null;
        }

        private void triggerCheckForTap() {
            if (this.mPendingCheckForTap == null) {
                this.mPendingCheckForTap = new CheckForTap();
            }
            TabsGridLayout.this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
        }

        private void cancelCheckForTap() {
            if (this.mPendingCheckForTap == null) {
                return;
            }
            TabsGridLayout.this.removeCallbacks(this.mPendingCheckForTap);
        }

        private class CheckForTap
        implements Runnable {
            private CheckForTap() {
            }

            @Override
            public void run() {
                if (!TabSwipeGestureListener.this.mSwiping && TabSwipeGestureListener.this.mSwipeView != null && TabSwipeGestureListener.this.mEnabled) {
                    TabSwipeGestureListener.this.mSwipeView.setPressed(true);
                }
            }
        }
    }

    private class TabsGridLayoutAdapter
    extends TabsLayoutAdapter {
        private final View.OnClickListener mCloseClickListener;

        public TabsGridLayoutAdapter(Context context) {
            super(context, R.layout.new_tablet_tabs_item_cell);
            this.mCloseClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    TabsGridLayout.this.closeTab(view);
                }
            };
        }

        @Override
        TabsLayoutItemView newView(int n, ViewGroup viewGroup) {
            TabsLayoutItemView tabsLayoutItemView = super.newView(n, viewGroup);
            tabsLayoutItemView.setCloseOnClickListener(this.mCloseClickListener);
            return tabsLayoutItemView;
        }

        @Override
        public void bindView(TabsLayoutItemView tabsLayoutItemView, Tab tab) {
            super.bindView(tabsLayoutItemView, tab);
            TabsGridLayout.this.resetTransforms((View)tabsLayoutItemView);
        }
    }
}

