/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.updater;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.updater.UpdateService;
import org.mozilla.gecko.util.GeckoJarReader;

public class UpdateServiceHelper {
    public static final String ACTION_REGISTER_FOR_UPDATES = "org.mozilla.fennec.REGISTER_FOR_UPDATES";
    public static final String ACTION_UNREGISTER_FOR_UPDATES = "org.mozilla.fennec.UNREGISTER_FOR_UPDATES";
    public static final String ACTION_CHECK_FOR_UPDATE = "org.mozilla.fennec.CHECK_FOR_UPDATE";
    public static final String ACTION_CHECK_UPDATE_RESULT = "org.mozilla.fennec.CHECK_UPDATE_RESULT";
    public static final String ACTION_DOWNLOAD_UPDATE = "org.mozilla.fennec.DOWNLOAD_UPDATE";
    public static final String ACTION_APPLY_UPDATE = "org.mozilla.fennec.APPLY_UPDATE";
    public static final String ACTION_CANCEL_DOWNLOAD = "org.mozilla.fennec.CANCEL_DOWNLOAD";
    protected static final int FLAG_FORCE_DOWNLOAD = 1;
    protected static final int FLAG_OVERWRITE_EXISTING = 2;
    protected static final int FLAG_REINSTALL = 4;
    protected static final int FLAG_RETRY = 8;
    protected static final String EXTRA_AUTODOWNLOAD_NAME = "autodownload";
    protected static final String EXTRA_UPDATE_FLAGS_NAME = "updateFlags";
    protected static final String EXTRA_PACKAGE_PATH_NAME = "packagePath";
    protected static final String EXTRA_UPDATE_URL_NAME = "updateUrl";
    private static final String LOGTAG = "UpdateServiceHelper";
    private static final String DEFAULT_UPDATE_LOCALE = "en-US";
    private static volatile boolean isEnabled = true;

    @RobocopTarget
    public static void setEnabled(boolean bl) {
        isEnabled = bl;
    }

    public static URI expandUpdateURI(Context context, String string2, boolean bl) {
        Object object;
        if (string2 == null) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        String string3 = AppConstants.MOZ_PKG_SPECIAL != null ? "-" + AppConstants.MOZ_PKG_SPECIAL : "";
        String string4 = DEFAULT_UPDATE_LOCALE;
        try {
            object = packageManager.getApplicationInfo("org.mozilla.fennec", 0);
            String string5 = "jar:jar:file://" + object.sourceDir + "!/" + "assets/omni.ja" + "!/update.locale";
            String string6 = GeckoJarReader.getText((Context)context, (String)string5);
            if (string6 != null) {
                string4 = string6.trim();
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.i((String)LOGTAG, (String)("Failed to read update locale file, falling back to " + string4));
        }
        object = string2.replace("%PRODUCT%", "Fennec").replace("%VERSION%", "42.0a1").replace("%BUILD_ID%", bl ? "0" : "20150719030219").replace("%BUILD_TARGET%", "Android_x86-gcc3" + string3).replace("%LOCALE%", string4).replace("%CHANNEL%", "nightly").replace("%OS_VERSION%", Build.VERSION.RELEASE).replace("%DISTRIBUTION%", "default").replace("%DISTRIBUTION_VERSION%", "default").replace("%MOZ_VERSION%", "42.0a1");
        try {
            return new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.e((String)LOGTAG, (String)"Failed to create update url: ", (Throwable)uRISyntaxException);
            return null;
        }
    }

    public static boolean isUpdaterEnabled() {
        return isEnabled;
    }

    public static void setUpdateUrl(Context context, String string2) {
        UpdateServiceHelper.registerForUpdates(context, null, string2);
    }

    public static void setAutoDownloadPolicy(Context context, UpdateService.AutoDownloadPolicy autoDownloadPolicy) {
        UpdateServiceHelper.registerForUpdates(context, autoDownloadPolicy, null);
    }

    public static void checkForUpdate(Context context) {
        if (context == null) {
            return;
        }
        context.startService(UpdateServiceHelper.createIntent(context, ACTION_CHECK_FOR_UPDATE));
    }

    public static void downloadUpdate(Context context) {
        if (context == null) {
            return;
        }
        context.startService(UpdateServiceHelper.createIntent(context, ACTION_DOWNLOAD_UPDATE));
    }

    public static void applyUpdate(Context context) {
        if (context == null) {
            return;
        }
        context.startService(UpdateServiceHelper.createIntent(context, ACTION_APPLY_UPDATE));
    }

    public static void registerForUpdates(final Context context) {
        if (!UpdateServiceHelper.isUpdaterEnabled()) {
            return;
        }
        final HashMap hashMap = new HashMap();
        PrefsHelper.getPrefs(Pref.names, (PrefsHelper.PrefHandler)new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, String string3) {
                hashMap.put(string2, string3);
            }

            @Override
            public void finish() {
                UpdateServiceHelper.registerForUpdates(context, UpdateService.AutoDownloadPolicy.get((String)hashMap.get(Pref.AUTO_DOWNLOAD_POLICY.toString())), (String)hashMap.get(Pref.UPDATE_URL.toString()));
            }
        });
    }

    public static void registerForUpdates(Context context, UpdateService.AutoDownloadPolicy autoDownloadPolicy, String string2) {
        if (!UpdateServiceHelper.isUpdaterEnabled()) {
            return;
        }
        Intent intent = UpdateServiceHelper.createIntent(context, ACTION_REGISTER_FOR_UPDATES);
        if (autoDownloadPolicy != null) {
            intent.putExtra(EXTRA_AUTODOWNLOAD_NAME, autoDownloadPolicy.value);
        }
        if (string2 != null) {
            intent.putExtra(EXTRA_UPDATE_URL_NAME, string2);
        }
        context.startService(intent);
    }

    private static Intent createIntent(Context context, String string2) {
        return new Intent(string2, null, context, UpdateService.class);
    }

    private static enum Pref {
        AUTO_DOWNLOAD_POLICY("app.update.autodownload"),
        UPDATE_URL("app.update.url.android");

        public final String name;
        public static final String[] names;

        private Pref(String string3) {
            this.name = string3;
        }

        public String toString() {
            return this.name;
        }

        static {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Pref pref : Pref.values()) {
                arrayList.add(pref.toString());
            }
            names = arrayList.toArray(new String[0]);
        }
    }
}

