/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.LinearLayout;
import org.mozilla.gecko.R;

public class RoundedCornerLayout
extends LinearLayout {
    private static final String LOGTAG = "Gecko" + RoundedCornerLayout.class.getSimpleName();
    private Bitmap maskBitmap;
    private Paint paint;
    private Paint maskPaint;
    private float cornerRadius;

    public RoundedCornerLayout(Context context) {
        super(context);
        this.init(context);
    }

    public RoundedCornerLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public RoundedCornerLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.cornerRadius = TypedValue.applyDimension((int)0, (float)this.getResources().getDimensionPixelSize(R.dimen.doorhanger_rounded_corner_radius), (DisplayMetrics)displayMetrics);
        this.paint = new Paint(1);
        this.maskPaint = new Paint(3);
        this.maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.setWillNotDraw(false);
    }

    public void draw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        super.draw(canvas2);
        if (this.maskBitmap == null) {
            this.maskBitmap = this.createMask(canvas.getWidth(), canvas.getHeight());
        }
        canvas2.drawBitmap(this.maskBitmap, 0.0f, 0.0f, this.maskPaint);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.paint);
    }

    private Bitmap createMask(int n, int n2) {
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint(1);
        paint.setColor(-1);
        canvas.drawRect(0.0f, 0.0f, (float)n, (float)n2, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)n, (float)n2), this.cornerRadius, this.cornerRadius, paint);
        return bitmap;
    }
}

