/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.StrictMode;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.MenuItemCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Base64OutputStream;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.Toast;
import android.widget.ViewFlipper;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ObjectAnimator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.ActionModeCompat;
import org.mozilla.gecko.ActionModeCompatView;
import org.mozilla.gecko.AndroidGamepadManager;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.DataReportingNotification;
import org.mozilla.gecko.DynamicToolbar;
import org.mozilla.gecko.EditBookmarkDialog;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.FindInPageBar;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoProfileDirectories;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.GuestSession;
import org.mozilla.gecko.LayoutInterceptor;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.MediaCastingBar;
import org.mozilla.gecko.MotionEventInterceptor;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.OrderedBroadcastHelper;
import org.mozilla.gecko.OuterLayout;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.ReadingListHelper;
import org.mozilla.gecko.RestrictedProfiles;
import org.mozilla.gecko.ServiceNotificationClient;
import org.mozilla.gecko.SharedPreferencesHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.TouchEventInterceptor;
import org.mozilla.gecko.ZoomedView;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.TransitionsTracker;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.SuggestedSites;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.decoders.IconDirectoryEntry;
import org.mozilla.gecko.firstrun.FirstrunPane;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.LayerMarginsAnimator;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.health.BrowserHealthRecorder;
import org.mozilla.gecko.health.BrowserHealthReporter;
import org.mozilla.gecko.health.HealthRecorder;
import org.mozilla.gecko.health.SessionInformation;
import org.mozilla.gecko.home.BrowserSearch;
import org.mozilla.gecko.home.HomeBanner;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.HomePanelsManager;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.javaaddons.JavaAddonManager;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuItem;
import org.mozilla.gecko.mozglue.ContextUtils;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.prompts.PromptListItem;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.android.FennecTabsRepository;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.tabqueue.TabQueueHelper;
import org.mozilla.gecko.tabqueue.TabQueuePrompt;
import org.mozilla.gecko.tabs.TabHistoryController;
import org.mozilla.gecko.tabs.TabHistoryFragment;
import org.mozilla.gecko.tabs.TabHistoryPage;
import org.mozilla.gecko.tabs.TabsPanel;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ToolbarProgressView;
import org.mozilla.gecko.trackingprotection.TrackingProtectionPrompt;
import org.mozilla.gecko.util.ActivityUtils;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.MenuUtils;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.PrefUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;
import org.mozilla.gecko.widget.AnchoredPopup;
import org.mozilla.gecko.widget.ButtonToast;
import org.mozilla.gecko.widget.GeckoActionProvider;

public class BrowserApp
extends GeckoApp
implements TabsPanel.TabsLayoutChangeListener,
PropertyAnimator.PropertyAnimationListener,
View.OnKeyListener,
LayerView.OnMetricsChangedListener,
BrowserSearch.OnSearchListener,
BrowserSearch.OnEditSuggestionListener,
HomePager.OnUrlOpenListener,
HomePager.OnUrlOpenInBackgroundListener,
ReadingListHelper.OnReadingListEventListener,
AnchoredPopup.OnVisibilityChangeListener,
ActionModeCompat.Presenter,
LayoutInflater.Factory {
    private static final String LOGTAG = "GeckoBrowserApp";
    private static final boolean ZOOMED_VIEW_ENABLED = true;
    private static final int TABS_ANIMATION_DURATION = 450;
    private static final String ADD_SHORTCUT_TOAST = "add_shortcut_toast";
    public static final String GUEST_BROWSING_ARG = "--guest";
    private static final String STATE_ABOUT_HOME_TOP_PADDING = "abouthome_top_padding";
    private static final String BROWSER_SEARCH_TAG = "browser_search";
    private static final int ACTIVITY_REQUEST_PREFERENCES = 1001;
    private static final int ACTIVITY_REQUEST_TAB_QUEUE = 2001;
    @RobocopTarget
    public static final String EXTRA_SKIP_STARTPANE = "skipstartpane";
    private BrowserSearch mBrowserSearch;
    private View mBrowserSearchContainer;
    public ViewGroup mBrowserChrome;
    public ViewFlipper mActionBarFlipper;
    public ActionModeCompatView mActionBar;
    private BrowserToolbar mBrowserToolbar;
    private View mDoorhangerOverlay;
    private Refreshable mTabStrip;
    private ToolbarProgressView mProgressView;
    private FirstrunPane mFirstrunPane;
    private HomePager mHomePager;
    private TabsPanel mTabsPanel;
    private ViewGroup mHomePagerContainer;
    private ActionModeCompat mActionMode;
    private boolean mHideDynamicToolbarOnActionModeEnd;
    private TabHistoryController tabHistoryController;
    private ZoomedView mZoomedView;
    private static final int GECKO_TOOLS_MENU = -1;
    private static final int ADDON_MENU_OFFSET = 1000;
    public static final String TAB_HISTORY_FRAGMENT_TAG = "tabHistoryFragment";
    private Vector<MenuItemInfo> mAddonMenuItemsCache;
    private PropertyAnimator mMainLayoutAnimator;
    private static final Interpolator sTabsInterpolator = new Interpolator(){

        public float getInterpolation(float f) {
            return (f -= 1.0f) * f * f * f * f + 1.0f;
        }
    };
    private FindInPageBar mFindInPageBar;
    private MediaCastingBar mMediaCastingBar;
    private static final int FEEDBACK_LAUNCH_COUNT = 15;
    private int mToolbarHeight;
    private boolean mDynamicToolbarCanScroll;
    private SharedPreferencesHelper mSharedPreferencesHelper;
    private OrderedBroadcastHelper mOrderedBroadcastHelper;
    private BrowserHealthReporter mBrowserHealthReporter;
    private ReadingListHelper mReadingListHelper;
    private Integer mTargetTabForEditingMode;
    private final BrowserToolbar.TabEditingState mLastTabEditingState = new BrowserToolbar.TabEditingState();
    private boolean mHideWebContentOnAnimationEnd;
    private final DynamicToolbar mDynamicToolbar = new DynamicToolbar();
    private DragHelper mDragHelper;

    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        BrowserToolbar browserToolbar = BrowserToolbar.class.getName().equals(string2) ? BrowserToolbar.create(context, attributeSet) : (TabsPanel.TabsLayout.class.getName().equals(string2) ? TabsPanel.createTabsLayout(context, attributeSet) : super.onCreateView(string2, context, attributeSet));
        return browserToolbar;
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (tab == null) {
            if (tabEvents != Tabs.TabEvents.RESTORED) {
                throw new IllegalArgumentException("onTabChanged:" + (Object)((Object)tabEvents) + " must specify a tab.");
            }
            return;
        }
        Log.d((String)LOGTAG, (String)("BrowserApp.onTabChanged: " + tab.getId() + ": " + (Object)((Object)tabEvents)));
        switch (tabEvents) {
            case LOCATION_CHANGE: 
            case SELECTED: {
                if (Tabs.getInstance().isSelectedTab(tab)) {
                    this.updateHomePagerForTab(tab);
                }
                this.mHideDynamicToolbarOnActionModeEnd = false;
                this.mProgressView.setPrivateMode(tab.isPrivate());
                break;
            }
            case START: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
                if (!this.mDynamicToolbar.isEnabled()) break;
                this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                break;
            }
            case LOAD_ERROR: 
            case STOP: 
            case MENU_UPDATED: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
                break;
            }
            case PAGE_SHOW: {
                tab.loadFavicon();
                break;
            }
            case BOOKMARK_ADDED: {
                this.showBookmarkAddedToast();
                break;
            }
            case BOOKMARK_REMOVED: {
                this.showBookmarkRemovedToast();
                break;
            }
            case READING_LIST_ADDED: {
                this.onAddedToReadingList(tab.getURL());
                break;
            }
            case READING_LIST_REMOVED: {
                this.onRemovedFromReadingList(tab.getURL());
                break;
            }
            case UNSELECTED: {
                if (!tab.isEditing()) break;
                tab.getEditingState().copyFrom(this.mLastTabEditingState);
            }
        }
        if (HardwareUtils.isTablet() && tabEvents == Tabs.TabEvents.SELECTED) {
            this.updateEditingModeForTab(tab);
        }
        super.onTabChanged(tab, tabEvents, object);
    }

    private void updateEditingModeForTab(Tab tab) {
        if (!Tabs.getInstance().isSelectedTab(tab)) {
            Log.w((String)LOGTAG, (String)"updateEditingModeForTab: Given tab is expected to be selected tab");
        }
        this.saveTabEditingState(this.mLastTabEditingState);
        if (tab.isEditing()) {
            this.enterEditingMode();
            this.restoreTabEditingState(tab.getEditingState());
        } else {
            this.mBrowserToolbar.cancelEdit();
        }
    }

    private void saveTabEditingState(BrowserToolbar.TabEditingState tabEditingState) {
        this.mBrowserToolbar.saveTabEditingState(tabEditingState);
        tabEditingState.setIsBrowserSearchShown(this.mBrowserSearch.getUserVisibleHint());
    }

    private void restoreTabEditingState(BrowserToolbar.TabEditingState tabEditingState) {
        this.mBrowserToolbar.restoreTabEditingState(tabEditingState);
        if (tabEditingState.isBrowserSearchShown()) {
            this.showBrowserSearch();
        } else {
            this.hideBrowserSearch();
        }
    }

    private void showBookmarkAddedToast() {
        this.getButtonToast().show(false, (CharSequence)this.getResources().getString(R.string.bookmark_added), ButtonToast.LENGTH_SHORT, (CharSequence)this.getResources().getString(R.string.bookmark_options), null, new ButtonToast.ToastListener(){

            @Override
            public void onButtonClicked() {
                BrowserApp.this.showBookmarkDialog();
            }

            @Override
            public void onToastHidden(ButtonToast.ReasonHidden reasonHidden) {
            }
        });
    }

    private void showBookmarkRemovedToast() {
        Toast.makeText((Context)this, (int)R.string.bookmark_removed, (int)0).show();
    }

    private void showSwitchToReadingListToast(String string2) {
        this.getButtonToast().show(false, (CharSequence)string2, ButtonToast.LENGTH_SHORT, (CharSequence)this.getResources().getString(R.string.switch_button_message), R.drawable.switch_button_icon, new ButtonToast.ToastListener(){

            @Override
            public void onButtonClicked() {
                String string2 = AboutPages.getURLForBuiltinPanelType(HomeConfig.PanelType.READING_LIST);
                Tabs.getInstance().loadUrlInTab(string2);
            }

            @Override
            public void onToastHidden(ButtonToast.ReasonHidden reasonHidden) {
            }
        });
    }

    @Override
    public void onAddedToReadingList(String string2) {
        this.showSwitchToReadingListToast(this.getResources().getString(R.string.reading_list_added));
    }

    @Override
    public void onAlreadyInReadingList(String string2) {
        this.showSwitchToReadingListToast(this.getResources().getString(R.string.reading_list_duplicate));
    }

    @Override
    public void onRemovedFromReadingList(String string2) {
        Toast.makeText((Context)this, (int)R.string.reading_list_removed, (int)0).show();
    }

    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        if (AndroidGamepadManager.handleKeyEvent(keyEvent)) {
            return true;
        }
        if (keyEvent.getAction() != 0) {
            return false;
        }
        if ((keyEvent.getSource() & 0x401) == 1025) {
            switch (n) {
                case 100: {
                    if (this.mBrowserChrome.getVisibility() == 0) {
                        if (this.mDynamicToolbar.isEnabled() && !this.isHomePagerVisible()) {
                            this.mDynamicToolbar.setVisible(false, DynamicToolbar.VisibilityTransition.ANIMATE);
                            if (this.mLayerView != null) {
                                this.mLayerView.requestFocus();
                            }
                        } else {
                            this.mBrowserToolbar.requestFocusFromTouch();
                        }
                    } else {
                        this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                        this.mBrowserToolbar.requestFocusFromTouch();
                    }
                    return true;
                }
                case 102: {
                    Tabs.getInstance().getSelectedTab().doBack();
                    return true;
                }
                case 103: {
                    Tabs.getInstance().getSelectedTab().doForward();
                    return true;
                }
            }
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (AppConstants.Versions.feature11Plus && tab != null && keyEvent.isCtrlPressed()) {
            switch (n) {
                case 71: {
                    tab.doBack();
                    return true;
                }
                case 72: {
                    tab.doForward();
                    return true;
                }
                case 46: {
                    tab.doReload();
                    return true;
                }
                case 56: {
                    tab.doStop();
                    return true;
                }
                case 48: {
                    this.addTab();
                    return true;
                }
                case 51: {
                    Tabs.getInstance().closeTab(tab);
                    return true;
                }
                case 34: {
                    this.mFindInPageBar.show();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.mBrowserToolbar.isEditing() && this.onKey(null, n, keyEvent)) {
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (AndroidGamepadManager.handleKeyEvent(keyEvent)) {
            return true;
        }
        return super.onKeyUp(n, keyEvent);
    }

    @Override
    public void onCreate(Bundle bundle) {
        NfcAdapter nfcAdapter;
        Intent intent = this.getIntent();
        GeckoProfile geckoProfile = GeckoProfile.get((Context)this);
        if (geckoProfile != null && !geckoProfile.inGuestMode()) {
            GeckoProfile.maybeCleanupGuestProfile((Context)this);
        }
        ((GeckoApplication)this.getApplication()).prepareLightweightTheme();
        super.onCreate(bundle);
        Context context = this.getApplicationContext();
        this.mBrowserChrome = (ViewGroup)this.findViewById(R.id.browser_chrome);
        this.mActionBarFlipper = (ViewFlipper)this.findViewById(R.id.browser_actionbar);
        this.mActionBar = (ActionModeCompatView)this.findViewById(R.id.actionbar);
        this.mBrowserToolbar = (BrowserToolbar)this.findViewById(R.id.browser_toolbar);
        this.mProgressView = (ToolbarProgressView)this.findViewById(R.id.progress);
        this.mBrowserToolbar.setProgressBar(this.mProgressView);
        this.tabHistoryController = new TabHistoryController(new TabHistoryController.OnShowTabHistory(){

            @Override
            public void onShowHistory(final List<TabHistoryPage> list, final int n) {
                BrowserApp.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        TabHistoryFragment tabHistoryFragment = TabHistoryFragment.newInstance(list, n);
                        FragmentManager fragmentManager = BrowserApp.this.getSupportFragmentManager();
                        GeckoAppShell.vibrateOnHapticFeedbackEnabled(BrowserApp.this.getResources().getIntArray(R.array.long_press_vibrate_msec));
                        tabHistoryFragment.show(R.id.tab_history_panel, fragmentManager.beginTransaction(), BrowserApp.TAB_HISTORY_FRAGMENT_TAG);
                    }
                });
            }
        });
        this.mBrowserToolbar.setTabHistoryController(this.tabHistoryController);
        String string2 = intent.getAction();
        if ("android.intent.action.VIEW".equals(string2)) {
            this.mBrowserToolbar.setTitle(intent.getDataString());
            this.showTabQueuePromptIfApplicable(intent);
        } else if ("org.mozilla.gecko.GUEST_SESSION_INPROGRESS".equals(string2)) {
            GuestSession.handleIntent(this, intent);
        } else if ("TAB_QUEUE_LOAD_URLS_ACTION".equals(string2)) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.NOTIFICATION, "tabqueue");
        }
        if (HardwareUtils.isTablet()) {
            this.mTabStrip = (Refreshable)((ViewStub)this.findViewById(R.id.new_tablet_tab_strip)).inflate();
        }
        ((GeckoApp.MainLayout)this.mMainLayout).setTouchEventInterceptor(new HideOnTouchListener());
        ((GeckoApp.MainLayout)this.mMainLayout).setMotionEventInterceptor(new MotionEventInterceptor(){

            @Override
            public boolean onInterceptMotionEvent(View view, MotionEvent motionEvent) {
                if (BrowserApp.this.mLayerView != null && !BrowserApp.this.mLayerView.hasFocus() && GamepadUtils.isPanningControl((MotionEvent)motionEvent)) {
                    if (BrowserApp.this.mHomePager == null) {
                        return false;
                    }
                    if (BrowserApp.this.isHomePagerVisible()) {
                        BrowserApp.this.mLayerView.requestFocus();
                    } else {
                        BrowserApp.this.mHomePager.requestFocus();
                    }
                }
                return false;
            }
        });
        this.mHomePagerContainer = (ViewGroup)this.findViewById(R.id.home_pager_container);
        this.mBrowserSearchContainer = this.findViewById(R.id.search_container);
        this.mBrowserSearch = (BrowserSearch)this.getSupportFragmentManager().findFragmentByTag(BROWSER_SEARCH_TAG);
        if (this.mBrowserSearch == null) {
            this.mBrowserSearch = BrowserSearch.newInstance();
            this.mBrowserSearch.setUserVisibleHint(false);
        }
        this.setBrowserToolbarListeners();
        this.mFindInPageBar = (FindInPageBar)this.findViewById(R.id.find_in_page);
        this.mMediaCastingBar = (MediaCastingBar)this.findViewById(R.id.media_casting);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Menu:Open", "Menu:Update", "LightweightTheme:Update", "Search:Keyword", "Prompt:ShowTop", "Accounts:Exist"});
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Accounts:Create", "Accounts:CreateFirefoxAccountFromJSON", "CharEncoding:Data", "CharEncoding:State", "Favicon:CacheLoad", "Feedback:LastUrl", "Feedback:MaybeLater", "Feedback:OpenPlayStore", "Menu:Add", "Menu:Remove", "Reader:Share", "Sanitize:ClearHistory", "Sanitize:ClearSyncedTabs", "Settings:Show", "Telemetry:Gather", "Updater:Launch"});
        Distribution distribution = Distribution.init((Context)this);
        SuggestedSites suggestedSites = new SuggestedSites(context, distribution);
        BrowserDB browserDB = this.getProfile().getDB();
        browserDB.setSuggestedSites(suggestedSites);
        JavaAddonManager.getInstance().init(context);
        this.mSharedPreferencesHelper = new SharedPreferencesHelper(context);
        this.mOrderedBroadcastHelper = new OrderedBroadcastHelper(context);
        this.mBrowserHealthReporter = new BrowserHealthReporter();
        this.mReadingListHelper = new ReadingListHelper(context, this.getProfile(), this);
        if (AppConstants.MOZ_ANDROID_BEAM && (nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this)) != null) {
            nfcAdapter.setNdefPushMessageCallback(new NfcAdapter.CreateNdefMessageCallback(){

                public NdefMessage createNdefMessage(NfcEvent nfcEvent) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab == null || tab.isPrivate()) {
                        return null;
                    }
                    return new NdefMessage(new NdefRecord[]{NdefRecord.createUri((String)tab.getURL())});
                }
            }, (Activity)this, new Activity[0]);
        }
        if (bundle != null) {
            this.mDynamicToolbar.onRestoreInstanceState(bundle);
            this.mHomePagerContainer.setPadding(0, bundle.getInt(STATE_ABOUT_HOME_TOP_PADDING), 0, 0);
        }
        this.mDynamicToolbar.setEnabledChangedListener(new DynamicToolbar.OnEnabledChangedListener(){

            @Override
            public void onEnabledChanged(boolean bl) {
                BrowserApp.this.setDynamicToolbarEnabled(bl);
            }
        });
        this.mDragHelper = new DragHelper();
        this.mRootLayout.setDraggableCallback(this.mDragHelper);
        IconDirectoryEntry.setMaxBPP(GeckoAppShell.getScreenDepth());
        nfcAdapter = (ViewStub)this.findViewById(R.id.zoomed_view_stub);
        this.mZoomedView = (ZoomedView)nfcAdapter.inflate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFirstrun(Context context, ContextUtils.SafeIntent safeIntent) {
        if (safeIntent.getBooleanExtra(EXTRA_SKIP_STARTPANE, false)) {
            return;
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile((Context)this);
            if (sharedPreferences.getBoolean("startpane_enabled", false)) {
                if (!"android.intent.action.VIEW".equals(safeIntent.getAction())) {
                    this.showFirstrunPager();
                }
                sharedPreferences.edit().putBoolean("startpane_enabled", false).apply();
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private Class<?> getMediaPlayerManager() {
        try {
            return Class.forName("org.mozilla.gecko.MediaPlayerManager");
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"No native casting support", (Throwable)exception);
            return null;
        }
    }

    @Override
    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            super.onBackPressed();
            return;
        }
        if (this.mBrowserToolbar.onBackPressed()) {
            return;
        }
        if (this.mActionMode != null) {
            this.endActionModeCompat();
            return;
        }
        if (this.hideFirstrunPager()) {
            Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.BACK, "firstrun-pane");
            return;
        }
        super.onBackPressed();
    }

    public void onAttachedToWindow() {
        if (!AppConstants.Versions.preHC) {
            this.mDoorhangerOverlay = this.findViewById(R.id.doorhanger_overlay);
            this.mDoorhangerOverlay.setVisibility(0);
        }
        this.checkFirstrun((Context)this, new ContextUtils.SafeIntent(this.getIntent()));
    }

    @Override
    protected void processTabQueue() {
        if (this.mInitialized) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TabQueueHelper.shouldOpenTabQueueUrls((Context)BrowserApp.this)) {
                        BrowserApp.this.openQueuedTabs();
                    }
                }
            });
        }
    }

    @Override
    protected void openQueuedTabs() {
        ThreadUtils.assertNotOnUiThread();
        int n = TabQueueHelper.getTabQueueLength((Context)this);
        Telemetry.addToHistogram("FENNEC_TABQUEUE_QUEUESIZE", n);
        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.INTENT, "tabqueue-delayed");
        TabQueueHelper.openQueuedUrls((Context)this, this.mProfile, "tab_queue_url_list.json", false);
        if (n > 1) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.showNormalTabs();
                }
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        String string2 = ContextUtils.getStringExtra((Intent)this.getIntent(), (String)"args");
        boolean bl = GuestSession.shouldUse((Context)this, string2);
        boolean bl2 = GeckoProfile.get((Context)this).inGuestMode();
        if (bl != bl2) {
            this.doRestart(this.getIntent());
            return;
        }
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Prompt:ShowTop"});
        this.processTabQueue();
    }

    @Override
    public void onPause() {
        super.onPause();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, new String[]{"Prompt:ShowTop"});
    }

    public void onStart() {
        super.onStart();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserApp.this.getProfile().inGuestMode()) {
                    GuestSession.showNotification((Context)BrowserApp.this);
                } else {
                    GuestSession.hideNotification((Context)BrowserApp.this);
                }
            }
        });
    }

    public void onStop() {
        super.onStop();
        GuestSession.hideNotification((Context)this);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (this.mInitialized && bl && AppConstants.Versions.preHC && this.isHomePagerVisible() && this.mLayerView.getVisibility() != 0) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.mLayerView.showSurface();
                }
            });
        }
        if (bl) {
            this.mBrowserToolbar.onParentFocus();
        }
    }

    private void setBrowserToolbarListeners() {
        this.mBrowserToolbar.setOnActivateListener(new BrowserToolbar.OnActivateListener(){

            @Override
            public void onActivate() {
                BrowserApp.this.enterEditingMode();
            }
        });
        this.mBrowserToolbar.setOnCommitListener(new BrowserToolbar.OnCommitListener(){

            @Override
            public void onCommit() {
                BrowserApp.this.commitEditingMode();
            }
        });
        this.mBrowserToolbar.setOnDismissListener(new BrowserToolbar.OnDismissListener(){

            @Override
            public void onDismiss() {
                BrowserApp.this.mBrowserToolbar.cancelEdit();
            }
        });
        this.mBrowserToolbar.setOnFilterListener(new BrowserToolbar.OnFilterListener(){

            @Override
            public void onFilter(String string2, AutocompleteHandler autocompleteHandler) {
                BrowserApp.this.filterEditingMode(string2, autocompleteHandler);
            }
        });
        this.mBrowserToolbar.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (BrowserApp.this.isHomePagerVisible()) {
                    BrowserApp.this.mHomePager.onToolbarFocusChange(bl);
                }
            }
        });
        this.mBrowserToolbar.setOnStartEditingListener(new BrowserToolbar.OnStartEditingListener(){

            @Override
            public void onStartEditing() {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.setIsEditing(true);
                }
                if (BrowserApp.this.mDoorHangerPopup != null) {
                    BrowserApp.this.mDoorHangerPopup.disable();
                }
            }
        });
        this.mBrowserToolbar.setOnStopEditingListener(new BrowserToolbar.OnStopEditingListener(){

            @Override
            public void onStopEditing() {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.setIsEditing(false);
                }
                BrowserApp.this.selectTargetTabForEditingMode();
                BrowserApp.this.hideBrowserSearch();
                BrowserApp.this.hideHomePager();
                if (BrowserApp.this.mDoorHangerPopup != null) {
                    BrowserApp.this.mDoorHangerPopup.enable();
                }
            }
        });
        this.mBrowserToolbar.setOnKeyListener(this);
    }

    private void showBookmarkDialog() {
        final Tab tab = Tabs.getInstance().getSelectedTab();
        Prompt prompt = new Prompt((Context)this, new Prompt.PromptCallback(){

            @Override
            public void onPromptFinished(String string2) {
                int n = -1;
                try {
                    n = new JSONObject(string2).getInt("button");
                }
                catch (JSONException jSONException) {
                    Log.e((String)BrowserApp.LOGTAG, (String)"Exception reading bookmark prompt result", (Throwable)jSONException);
                }
                if (tab == null) {
                    return;
                }
                if (n == 0) {
                    new EditBookmarkDialog((Context)BrowserApp.this).show(tab.getURL());
                } else if (n == 1) {
                    String string3 = tab.getURL();
                    String string4 = tab.getDisplayTitle();
                    Bitmap bitmap = tab.getFavicon();
                    if (string3 != null && string4 != null) {
                        GeckoAppShell.createShortcut(string4, string3, bitmap);
                    }
                }
            }
        });
        PromptListItem[] promptListItemArray = new PromptListItem[2];
        Resources resources = this.getResources();
        promptListItemArray[0] = new PromptListItem(resources.getString(R.string.contextmenu_edit_bookmark));
        promptListItemArray[1] = new PromptListItem(resources.getString(R.string.contextmenu_add_to_launcher));
        prompt.show("", "", promptListItemArray, 0);
    }

    private void setDynamicToolbarEnabled(boolean bl) {
        ThreadUtils.assertOnUiThread();
        if (bl) {
            if (this.mLayerView != null) {
                this.mLayerView.setOnMetricsChangedDynamicToolbarViewportListener(this);
            }
            this.setToolbarMargin(0);
            this.mHomePagerContainer.setPadding(0, this.mBrowserChrome.getHeight(), 0, 0);
        } else {
            if (this.mLayerView != null) {
                this.mLayerView.setOnMetricsChangedDynamicToolbarViewportListener(null);
            }
            this.mHomePagerContainer.setPadding(0, 0, 0, 0);
            if (this.mBrowserChrome != null) {
                ViewHelper.setTranslationY((View)this.mBrowserChrome, 0.0f);
            }
        }
        this.refreshToolbarHeight();
    }

    private static boolean isAboutHome(Tab tab) {
        return AboutPages.isAboutHome(tab.getURL());
    }

    public boolean onSearchRequested() {
        this.enterEditingMode();
        return true;
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        int n = menuItem.getItemId();
        if (n == R.id.pasteandgo) {
            String string2 = Clipboard.getText();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                this.loadUrlOrKeywordSearch(string2);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.CONTEXT_MENU);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "pasteandgo");
            }
            return true;
        }
        if (n == R.id.site_settings) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Permissions:Get", null));
            if (AppConstants.Versions.preHC) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "site_settings");
            }
            return true;
        }
        if (n == R.id.paste) {
            String string3 = Clipboard.getText();
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                this.enterEditingMode(string3);
                this.showBrowserSearch();
                this.mBrowserSearch.filter(string3, null);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "paste");
            }
            return true;
        }
        if (n == R.id.subscribe) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && tab.hasFeeds()) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("tabId", tab.getId());
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"error building json arguments", (Throwable)jSONException);
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Feeds:Subscribe", jSONObject.toString()));
                if (AppConstants.Versions.preHC) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "subscribe");
                }
            }
            return true;
        }
        if (n == R.id.add_search_engine) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && tab.hasOpenSearch()) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("tabId", tab.getId());
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"error building json arguments", (Throwable)jSONException);
                    return true;
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SearchEngines:Add", jSONObject.toString()));
                if (AppConstants.Versions.preHC) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "add_search_engine");
                }
            }
            return true;
        }
        if (n == R.id.copyurl) {
            String string4;
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && (string4 = ReaderModeUtils.stripAboutReaderUrl(tab.getURL())) != null) {
                Clipboard.setText((CharSequence)string4);
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.CONTEXT_MENU, "copyurl");
            }
            return true;
        }
        if (n == R.id.add_to_launcher) {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab == null) {
                return true;
            }
            String string5 = tab.getURL();
            String string6 = tab.getDisplayTitle();
            if (string5 == null || string6 == null) {
                return true;
            }
            GeckoAppShell.CreateShortcutFaviconLoadedListener createShortcutFaviconLoadedListener = new GeckoAppShell.CreateShortcutFaviconLoadedListener(string5, string6);
            Favicons.getSizedFavicon(this.getContext(), string5, tab.getFaviconURL(), Integer.MAX_VALUE, 1, createShortcutFaviconLoadedListener);
            return true;
        }
        return false;
    }

    @Override
    public void setAccessibilityEnabled(boolean bl) {
        this.mDynamicToolbar.setAccessibilityEnabled(bl);
    }

    @Override
    public void onDestroy() {
        NfcAdapter nfcAdapter;
        this.mDynamicToolbar.destroy();
        if (this.mBrowserToolbar != null) {
            this.mBrowserToolbar.onDestroy();
        }
        if (this.mFindInPageBar != null) {
            this.mFindInPageBar.onDestroy();
            this.mFindInPageBar = null;
        }
        if (this.mMediaCastingBar != null) {
            this.mMediaCastingBar.onDestroy();
            this.mMediaCastingBar = null;
        }
        if (this.mSharedPreferencesHelper != null) {
            this.mSharedPreferencesHelper.uninit();
            this.mSharedPreferencesHelper = null;
        }
        if (this.mOrderedBroadcastHelper != null) {
            this.mOrderedBroadcastHelper.uninit();
            this.mOrderedBroadcastHelper = null;
        }
        if (this.mBrowserHealthReporter != null) {
            this.mBrowserHealthReporter.uninit();
            this.mBrowserHealthReporter = null;
        }
        if (this.mReadingListHelper != null) {
            this.mReadingListHelper.uninit();
            this.mReadingListHelper = null;
        }
        if (this.mZoomedView != null) {
            this.mZoomedView.destroy();
        }
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Menu:Open", "Menu:Update", "LightweightTheme:Update", "Search:Keyword", "Prompt:ShowTop", "Accounts:Exist"});
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, new String[]{"Accounts:Create", "Accounts:CreateFirefoxAccountFromJSON", "CharEncoding:Data", "CharEncoding:State", "Favicon:CacheLoad", "Feedback:LastUrl", "Feedback:MaybeLater", "Feedback:OpenPlayStore", "Menu:Add", "Menu:Remove", "Reader:Share", "Sanitize:ClearHistory", "Sanitize:ClearSyncedTabs", "Settings:Show", "Telemetry:Gather", "Updater:Launch"});
        if (AppConstants.MOZ_ANDROID_BEAM && (nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this)) != null) {
            nfcAdapter.setNdefPushMessageCallback(null, (Activity)this, new Activity[0]);
        }
        super.onDestroy();
    }

    @Override
    protected void initializeChrome() {
        super.initializeChrome();
        this.mDoorHangerPopup.setAnchor(this.mBrowserToolbar.getDoorHangerAnchor());
        this.mDoorHangerPopup.setOnVisibilityChangeListener(this);
        this.mDynamicToolbar.setLayerView(this.mLayerView);
        this.setDynamicToolbarEnabled(this.mDynamicToolbar.isEnabled());
        this.mLayerView.setOnKeyListener(this);
        if (HardwareUtils.isTablet()) {
            this.onCreatePanelMenu(0, null);
            this.invalidateOptionsMenu();
        }
    }

    @Override
    public void onDoorHangerShow() {
        this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
        if (AppConstants.Versions.preHC) {
            return;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mDoorhangerOverlay, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator.setDuration(250L);
        TransitionsTracker.track((Animator)objectAnimator);
        objectAnimator.start();
    }

    @Override
    public void onDoorHangerHide() {
        if (AppConstants.Versions.preHC) {
            return;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mDoorhangerOverlay, (String)"alpha", (float[])new float[]{0.0f});
        objectAnimator.setDuration(200L);
        TransitionsTracker.track((Animator)objectAnimator);
        objectAnimator.start();
    }

    private void handleClearHistory(final boolean bl) {
        final BrowserDB browserDB = this.getProfile().getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                browserDB.clearHistory(BrowserApp.this.getContentResolver(), bl);
            }
        });
    }

    private void handleClearSyncedTabs() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FennecTabsRepository.deleteNonLocalClientsAndTabs(BrowserApp.this.getContext());
            }
        });
    }

    private void shareCurrentUrl() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null) {
            return;
        }
        String string2 = tab.getURL();
        if (string2 == null) {
            return;
        }
        if (AboutPages.isAboutReader(string2)) {
            string2 = ReaderModeUtils.getUrlFromAboutReader(string2);
        }
        GeckoAppShell.openUriExternal(string2, "text/plain", "", "", "android.intent.action.SEND", tab.getDisplayTitle());
        Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.LIST);
    }

    private void setToolbarMargin(int n) {
        ((RelativeLayout.LayoutParams)this.mGeckoLayout.getLayoutParams()).topMargin = n;
        this.mGeckoLayout.requestLayout();
    }

    @Override
    public void onMetricsChanged(ImmutableViewportMetrics immutableViewportMetrics) {
        if (this.isHomePagerVisible() || this.mBrowserChrome == null) {
            return;
        }
        if (immutableViewportMetrics.getPageHeight() <= immutableViewportMetrics.getHeight()) {
            if (this.mDynamicToolbarCanScroll) {
                this.mDynamicToolbarCanScroll = false;
                if (this.mBrowserChrome.getVisibility() != 0) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserApp.this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                        }
                    });
                }
            }
        } else {
            this.mDynamicToolbarCanScroll = true;
        }
        ViewGroup viewGroup = this.mBrowserChrome;
        ToolbarProgressView toolbarProgressView = this.mProgressView;
        final int n = Math.round(immutableViewportMetrics.marginTop);
        ThreadUtils.postToUiThread((Runnable)new Runnable((View)viewGroup, toolbarProgressView){
            final /* synthetic */ View val$browserChrome;
            final /* synthetic */ ToolbarProgressView val$progressView;
            {
                this.val$browserChrome = view;
                this.val$progressView = toolbarProgressView;
            }

            @Override
            public void run() {
                float f = n - this.val$browserChrome.getHeight();
                ViewHelper.setTranslationY(this.val$browserChrome, f);
                float f2 = BrowserApp.this.getResources().getDimensionPixelOffset(R.dimen.progress_bar_scroll_offset);
                float f3 = Math.max((float)(n - this.val$browserChrome.getHeight()), f2 - (float)this.val$browserChrome.getHeight());
                ViewHelper.setTranslationY((View)this.val$progressView, f3);
            }
        });
        if (this.mFormAssistPopup != null) {
            this.mFormAssistPopup.onMetricsChanged(immutableViewportMetrics);
        }
    }

    @Override
    public void onPanZoomStopped() {
        if (!this.mDynamicToolbar.isEnabled() || this.isHomePagerVisible()) {
            return;
        }
        ImmutableViewportMetrics immutableViewportMetrics = this.mLayerView.getViewportMetrics();
        float f = immutableViewportMetrics.viewportRectBottom - immutableViewportMetrics.viewportRectTop;
        if (immutableViewportMetrics.getPageHeight() < immutableViewportMetrics.getHeight() || immutableViewportMetrics.marginTop >= (float)(this.mToolbarHeight / 2) || immutableViewportMetrics.pageRectBottom == immutableViewportMetrics.viewportRectBottom && immutableViewportMetrics.pageRectBottom > 2.0f * f) {
            this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
        } else {
            this.mDynamicToolbar.setVisible(false, DynamicToolbar.VisibilityTransition.ANIMATE);
        }
    }

    public void refreshToolbarHeight() {
        ThreadUtils.assertOnUiThread();
        int n = 0;
        if (this.mBrowserChrome != null) {
            n = this.mBrowserChrome.getHeight();
        }
        if (!this.mDynamicToolbar.isEnabled() || this.isHomePagerVisible()) {
            if (this.mDynamicToolbar.isEnabled()) {
                this.mHomePagerContainer.setPadding(0, n, 0, 0);
            } else {
                this.setToolbarMargin(n);
                n = 0;
            }
        } else {
            this.setToolbarMargin(0);
        }
        if (this.mLayerView != null && n != this.mToolbarHeight) {
            this.mToolbarHeight = n;
            this.mLayerView.getLayerMarginsAnimator().setMaxMargins(0.0f, n, 0.0f, 0.0f);
            this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.IMMEDIATE);
        }
    }

    @Override
    void toggleChrome(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    BrowserApp.this.mBrowserChrome.setVisibility(0);
                } else {
                    BrowserApp.this.mBrowserChrome.setVisibility(8);
                }
            }
        });
        super.toggleChrome(bl);
    }

    @Override
    void focusChrome() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserApp.this.mBrowserChrome.setVisibility(0);
                BrowserApp.this.mActionBarFlipper.requestFocusFromTouch();
            }
        });
    }

    @Override
    public void refreshChrome() {
        this.invalidateOptionsMenu();
        if (this.mTabsPanel != null) {
            this.mRootLayout.reset();
            this.mTabsPanel.refresh();
        }
        if (this.mTabStrip != null) {
            this.mTabStrip.refresh();
        }
        this.mBrowserToolbar.refresh();
    }

    @Override
    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        if ("Accounts:CreateFirefoxAccountFromJSON".equals(string2)) {
            AndroidFxAccount androidFxAccount;
            block39: {
                androidFxAccount = null;
                try {
                    NativeJSObject nativeJSObject2 = nativeJSObject.getObject("json");
                    String string3 = nativeJSObject2.getString("email");
                    String string4 = nativeJSObject2.getString("uid");
                    boolean bl = nativeJSObject2.optBoolean("verified", false);
                    byte[] byArray = Utils.hex2Byte(nativeJSObject2.getString("unwrapBKey"));
                    byte[] byArray2 = Utils.hex2Byte(nativeJSObject2.getString("sessionToken"));
                    byte[] byArray3 = Utils.hex2Byte(nativeJSObject2.getString("keyFetchToken"));
                    String string5 = nativeJSObject2.optString("authServerEndpoint", "https://api.accounts.firefox.com/v1");
                    String string6 = nativeJSObject2.optString("tokenServerEndpoint", "https://token.services.mozilla.com/1.0/sync/1.5");
                    String string7 = nativeJSObject2.optString("profileServerEndpoint", "https://profile.accounts.firefox.com/v1");
                    Engaged engaged = new Engaged(string3, string4, bl, byArray, byArray2, byArray3);
                    androidFxAccount = AndroidFxAccount.addAndroidAccount((Context)this, string3, this.getProfile().getName(), string5, string6, string7, engaged, AndroidFxAccount.DEFAULT_AUTHORITIES_TO_SYNC_AUTOMATICALLY_MAP);
                }
                catch (Exception exception) {
                    Log.w((String)LOGTAG, (String)"Got exception creating Firefox Account from JSON; ignoring.", (Throwable)exception);
                    if (eventCallback != null) break block39;
                    eventCallback.sendError((Object)("Could not create Firefox Account from JSON: " + exception.toString()));
                }
            }
            if (eventCallback != null) {
                eventCallback.sendSuccess((Object)(androidFxAccount != null ? 1 : 0));
            }
        } else if ("Accounts:Create".equals(string2)) {
            Intent intent = new Intent(this.getContext(), FxAccountGetStartedActivity.class);
            intent.setFlags(0x10000000);
            NativeJSObject nativeJSObject3 = nativeJSObject.optObject("extras", null);
            if (nativeJSObject3 != null) {
                intent.putExtra("extras", nativeJSObject3.toString());
            }
            this.getContext().startActivity(intent);
        } else if ("CharEncoding:Data".equals(string2)) {
            NativeJSObject[] nativeJSObjectArray = nativeJSObject.getObjectArray("charsets");
            int n = nativeJSObject.getInt("selected");
            CharSequence[] charSequenceArray = new String[nativeJSObjectArray.length];
            final String[] stringArray = new String[nativeJSObjectArray.length];
            for (int i = 0; i < nativeJSObjectArray.length; ++i) {
                NativeJSObject nativeJSObject4 = nativeJSObjectArray[i];
                charSequenceArray[i] = nativeJSObject4.getString("title");
                stringArray[i] = nativeJSObject4.getString("code");
            }
            final AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setSingleChoiceItems(charSequenceArray, n, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("CharEncoding:Set", stringArray[n]));
                    dialogInterface.dismiss();
                }
            });
            builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    dialogInterface.dismiss();
                }
            });
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    builder.show();
                }
            });
        } else if ("CharEncoding:State".equals(string2)) {
            final boolean bl = nativeJSObject.getString("visible").equals("true");
            GeckoPreferences.setCharEncodingState(bl);
            final Menu menu2 = this.mMenu;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (menu2 != null) {
                        menu2.findItem(R.id.char_encoding).setVisible(bl);
                    }
                }
            });
        } else if ("Favicon:CacheLoad".equals(string2)) {
            String string8 = nativeJSObject.getString("url");
            this.getFaviconFromCache(eventCallback, string8);
        } else if ("Feedback:LastUrl".equals(string2)) {
            this.getLastUrl(eventCallback);
        } else if ("Feedback:MaybeLater".equals(string2)) {
            this.resetFeedbackLaunchCount();
        } else if ("Feedback:OpenPlayStore".equals(string2)) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)("market://details?id=" + this.getPackageName())));
            this.startActivity(intent);
        } else if ("Menu:Add".equals(string2)) {
            MenuItemInfo menuItemInfo = new MenuItemInfo();
            menuItemInfo.label = nativeJSObject.getString("name");
            menuItemInfo.id = nativeJSObject.getInt("id") + 1000;
            menuItemInfo.icon = nativeJSObject.optString("icon", null);
            menuItemInfo.checked = nativeJSObject.optBoolean("checked", false);
            menuItemInfo.enabled = nativeJSObject.optBoolean("enabled", true);
            menuItemInfo.visible = nativeJSObject.optBoolean("visible", true);
            menuItemInfo.checkable = nativeJSObject.optBoolean("checkable", false);
            int n = nativeJSObject.optInt("parent", 0);
            menuItemInfo.parent = n <= 0 ? n : n + 1000;
            final MenuItemInfo menuItemInfo2 = menuItemInfo;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.addAddonMenuItem(menuItemInfo2);
                }
            });
        } else if ("Menu:Remove".equals(string2)) {
            final int n = nativeJSObject.getInt("id") + 1000;
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.removeAddonMenuItem(n);
                }
            });
        } else if ("Reader:Share".equals(string2)) {
            String string9 = nativeJSObject.getString("title");
            String string10 = nativeJSObject.getString("url");
            GeckoAppShell.openUriExternal(string10, "text/plain", "", "", "android.intent.action.SEND", string9);
        } else if ("Sanitize:ClearHistory".equals(string2)) {
            this.handleClearHistory(nativeJSObject.optBoolean("clearSearchHistory", false));
            eventCallback.sendSuccess((Object)true);
        } else if ("Sanitize:ClearSyncedTabs".equals(string2)) {
            this.handleClearSyncedTabs();
            eventCallback.sendSuccess((Object)true);
        } else if ("Settings:Show".equals(string2)) {
            String string11 = nativeJSObject.optString("resource", null);
            Intent intent = new Intent((Context)this, GeckoPreferences.class);
            GeckoPreferences.setResourceToOpen(intent, string11);
            this.startActivityForResult(intent, 1001);
            if (HardwareUtils.IS_KINDLE_DEVICE) {
                this.overridePendingTransition(0, 0);
            }
        } else if ("Telemetry:Gather".equals(string2)) {
            BrowserDB browserDB = this.getProfile().getDB();
            ContentResolver contentResolver = this.getContentResolver();
            Telemetry.addToHistogram("PLACES_PAGES_COUNT", browserDB.getCount(contentResolver, "history"));
            Telemetry.addToHistogram("PLACES_BOOKMARKS_COUNT", browserDB.getCount(contentResolver, "bookmarks"));
            Telemetry.addToHistogram("FENNEC_FAVICONS_COUNT", browserDB.getCount(contentResolver, "favicons"));
            Telemetry.addToHistogram("FENNEC_THUMBNAILS_COUNT", browserDB.getCount(contentResolver, "thumbnails"));
            Telemetry.addToHistogram("FENNEC_READING_LIST_COUNT", browserDB.getReadingListAccessor().getCount(contentResolver));
            Telemetry.addToHistogram("BROWSER_IS_USER_DEFAULT", this.isDefaultBrowser("android.intent.action.VIEW") ? 1 : 0);
            Telemetry.addToHistogram("FENNEC_TABQUEUE_ENABLED", TabQueueHelper.isTabQueueEnabled((Context)this) ? 1 : 0);
            if (AppConstants.Versions.feature16Plus) {
                Telemetry.addToHistogram("BROWSER_IS_ASSIST_DEFAULT", this.isDefaultBrowser("android.intent.action.ASSIST") ? 1 : 0);
            }
        } else if ("Updater:Launch".equals(string2)) {
            this.handleUpdaterLaunch();
        } else {
            super.handleMessage(string2, nativeJSObject, eventCallback);
        }
    }

    private void getFaviconFromCache(final EventCallback eventCallback, String string2) {
        OnFaviconLoadedListener onFaviconLoadedListener = new OnFaviconLoadedListener(){

            @Override
            public void onFaviconLoaded(String string2, String string3, final Bitmap bitmap) {
                ThreadUtils.assertOnUiThread();
                ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ByteArrayOutputStream byteArrayOutputStream = null;
                        Base64OutputStream base64OutputStream = null;
                        if (bitmap == null) {
                            eventCallback.sendError((Object)"Failed to get favicon from cache");
                        } else {
                            try {
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                byteArrayOutputStream.write("data:image/png;base64,".getBytes());
                                base64OutputStream = new Base64OutputStream((OutputStream)byteArrayOutputStream, 2);
                                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)base64OutputStream);
                                eventCallback.sendSuccess((Object)new String(byteArrayOutputStream.toByteArray()));
                            }
                            catch (IOException iOException) {
                                Log.w((String)BrowserApp.LOGTAG, (String)"Failed to convert to base64 data URI");
                                eventCallback.sendError((Object)"Failed to convert favicon to a base64 data URI");
                            }
                            finally {
                                try {
                                    if (byteArrayOutputStream != null) {
                                        byteArrayOutputStream.close();
                                    }
                                    if (base64OutputStream != null) {
                                        base64OutputStream.close();
                                    }
                                }
                                catch (IOException iOException) {
                                    Log.w((String)BrowserApp.LOGTAG, (String)"Failed to close the streams");
                                }
                            }
                        }
                    }
                });
            }
        };
        Favicons.getSizedFaviconForPageFromLocal(this.getContext(), string2, onFaviconLoadedListener);
    }

    private boolean isDefaultBrowser(String string2) {
        Intent intent = new Intent(string2, Uri.parse((String)"http://www.mozilla.org"));
        ResolveInfo resolveInfo = this.getPackageManager().resolveActivity(intent, 65536);
        if (resolveInfo == null) {
            return false;
        }
        String string3 = resolveInfo.activityInfo.packageName;
        return TextUtils.equals((CharSequence)string3, (CharSequence)this.getPackageName());
    }

    @Override
    public void handleMessage(String string2, JSONObject jSONObject) {
        block26: {
            try {
                if (string2.equals("Menu:Open")) {
                    if (this.mBrowserToolbar.isEditing()) {
                        this.mBrowserToolbar.cancelEdit();
                    }
                    this.openOptionsMenu();
                    break block26;
                }
                if (string2.equals("Menu:Update")) {
                    final int n = jSONObject.getInt("id") + 1000;
                    final JSONObject jSONObject2 = jSONObject.getJSONObject("options");
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserApp.this.updateAddonMenuItem(n, jSONObject2);
                        }
                    });
                    break block26;
                }
                if (string2.equals("Gecko:DelayedStartup")) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserApp.this.ensureTabsPanelExists();
                        }
                    });
                    Class<?> clazz = this.getMediaPlayerManager();
                    if (clazz != null) {
                        try {
                            clazz.getDeclaredField("MEDIA_PLAYER_TAG").get("");
                            Log.i((String)LOGTAG, (String)"Found tag ");
                            Fragment fragment = this.getSupportFragmentManager().findFragmentByTag("");
                            if (fragment == null) {
                                Method method = clazz.getMethod("newInstance", null);
                                Fragment fragment2 = (Fragment)method.invoke(null, new Object[0]);
                                this.getSupportFragmentManager().beginTransaction().disallowAddToBackStack().add(fragment2, "").commit();
                            }
                        }
                        catch (Exception exception) {
                            Log.e((String)LOGTAG, (String)"Error initializing media manager", (Throwable)exception);
                        }
                    }
                    ThreadUtils.getBackgroundHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            GeckoPreferences.broadcastStumblerPref((Context)BrowserApp.this);
                        }
                    }, 1000L);
                    super.handleMessage(string2, jSONObject);
                    break block26;
                }
                if (string2.equals("Gecko:Ready")) {
                    super.handleMessage(string2, jSONObject);
                    final Menu menu2 = this.mMenu;
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (menu2 != null) {
                                menu2.findItem(R.id.settings).setEnabled(true);
                                menu2.findItem(R.id.help).setEnabled(true);
                            }
                        }
                    });
                    DataReportingNotification.checkAndNotifyPolicy(GeckoAppShell.getContext());
                } else if (string2.equals("Search:Keyword")) {
                    this.storeSearchQuery(jSONObject.getString("query"));
                } else if (string2.equals("LightweightTheme:Update")) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BrowserApp.this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                        }
                    });
                } else if (string2.equals("Prompt:ShowTop")) {
                    Intent intent = new Intent();
                    intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
                    intent.setFlags(131072);
                    this.startActivity(intent);
                } else if (string2.equals("Accounts:Exist")) {
                    String string3 = jSONObject.getString("kind");
                    JSONObject jSONObject3 = new JSONObject();
                    if ("any".equals(string3)) {
                        jSONObject3.put("exists", SyncAccounts.syncAccountsExist(this.getContext()) || FirefoxAccounts.firefoxAccountsExist(this.getContext()));
                        EventDispatcher.sendResponse(jSONObject, jSONObject3);
                    } else if ("fxa".equals(string3)) {
                        jSONObject3.put("exists", FirefoxAccounts.firefoxAccountsExist(this.getContext()));
                        EventDispatcher.sendResponse(jSONObject, jSONObject3);
                    } else if ("sync11".equals(string3)) {
                        jSONObject3.put("exists", SyncAccounts.syncAccountsExist(this.getContext()));
                        EventDispatcher.sendResponse(jSONObject, jSONObject3);
                    } else {
                        jSONObject3.put("error", (Object)"Unknown kind");
                        EventDispatcher.sendError(jSONObject, jSONObject3);
                    }
                } else {
                    super.handleMessage(string2, jSONObject);
                }
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
            }
        }
    }

    @Override
    public void addTab() {
        Tabs.getInstance().addTab();
    }

    @Override
    public void addPrivateTab() {
        Tabs.getInstance().addPrivateTab();
        this.showTrackingProtectionPromptIfApplicable();
    }

    private void showTrackingProtectionPromptIfApplicable() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        boolean bl = sharedPreferences.getBoolean("android.not_a_preference.trackingProtectionPromptShown", false);
        if (bl) {
            return;
        }
        sharedPreferences.edit().putBoolean("android.not_a_preference.trackingProtectionPromptShown", true).apply();
        this.startActivity(new Intent((Context)this, TrackingProtectionPrompt.class));
    }

    @Override
    public void showNormalTabs() {
        this.showTabs(TabsPanel.Panel.NORMAL_TABS);
    }

    @Override
    public void showPrivateTabs() {
        this.showTabs(TabsPanel.Panel.PRIVATE_TABS);
    }

    private boolean ensureTabsPanelExists() {
        if (this.mTabsPanel != null) {
            return false;
        }
        ViewStub viewStub = (ViewStub)this.findViewById(R.id.tabs_panel);
        this.mTabsPanel = (TabsPanel)viewStub.inflate();
        this.mTabsPanel.setTabsLayoutChangeListener(this);
        return true;
    }

    private void showTabs(final TabsPanel.Panel panel) {
        if (Tabs.getInstance().getDisplayCount() == 0) {
            return;
        }
        if (this.ensureTabsPanelExists()) {
            ViewTreeObserver viewTreeObserver = this.mTabsPanel.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        BrowserApp.this.mTabsPanel.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        BrowserApp.this.showTabs(panel);
                    }
                });
            }
        } else {
            if (this.mDoorHangerPopup != null) {
                this.mDoorHangerPopup.disable();
            }
            this.mTabsPanel.show(panel);
            this.mFindInPageBar.hide();
        }
    }

    @Override
    public void hideTabs() {
        this.mTabsPanel.hide();
        if (this.mDoorHangerPopup != null) {
            this.mDoorHangerPopup.enable();
        }
    }

    @Override
    public boolean autoHideTabs() {
        if (this.areTabsShown()) {
            this.hideTabs();
            return true;
        }
        return false;
    }

    @Override
    public boolean areTabsShown() {
        return this.mTabsPanel != null && this.mTabsPanel.isShown();
    }

    @Override
    public void onTabsLayoutChange(int n, int n2) {
        int n3 = 450;
        if (this.mMainLayoutAnimator != null) {
            n3 = Math.max(1, n3 - (int)this.mMainLayoutAnimator.getRemainingTime());
            this.mMainLayoutAnimator.stop(false);
        }
        if (this.areTabsShown()) {
            this.mTabsPanel.setDescendantFocusability(262144);
            if (AppConstants.Versions.feature16Plus) {
                this.mLayerView.setImportantForAccessibility(2);
            }
        } else if (AppConstants.Versions.feature16Plus) {
            this.mLayerView.setImportantForAccessibility(1);
        }
        this.mMainLayoutAnimator = new PropertyAnimator(n3, sTabsInterpolator);
        this.mMainLayoutAnimator.addPropertyAnimationListener(this);
        this.mMainLayoutAnimator.attach((View)this.mMainLayout, PropertyAnimator.Property.SCROLL_Y, -n2);
        this.mTabsPanel.prepareTabsAnimation(this.mMainLayoutAnimator);
        this.mBrowserToolbar.triggerTabsPanelTransition(this.mMainLayoutAnimator, this.areTabsShown());
        if (this.mDynamicToolbar.isEnabled()) {
            if (n > 0 && n2 > 0) {
                this.mDynamicToolbar.setPinned(true, DynamicToolbar.PinReason.RELAYOUT);
                this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
            } else {
                this.mDynamicToolbar.setPinned(false, DynamicToolbar.PinReason.RELAYOUT);
            }
        }
        this.mMainLayoutAnimator.start();
    }

    @Override
    public void onPropertyAnimationStart() {
    }

    @Override
    public void onPropertyAnimationEnd() {
        if (!this.areTabsShown()) {
            this.mTabsPanel.setVisibility(4);
            this.mTabsPanel.setDescendantFocusability(393216);
            this.mRootLayout.setClosed();
            this.mBrowserToolbar.setContextMenuEnabled(true);
        } else {
            this.mBrowserToolbar.cancelEdit();
            this.mRootLayout.setOpen();
        }
        this.mTabsPanel.finishTabsAnimation();
        this.mMainLayoutAnimator = null;
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        this.mDynamicToolbar.onSaveInstanceState(bundle);
        bundle.putInt(STATE_ABOUT_HOME_TOP_PADDING, this.mHomePagerContainer.getPaddingTop());
    }

    private boolean maybeSwitchToTab(String string2, EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet) {
        if (!enumSet.contains((Object)HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB)) {
            return false;
        }
        Tabs tabs = Tabs.getInstance();
        Tab tab = AboutPages.isAboutReader(string2) ? tabs.getFirstReaderTabForUrl(string2, tabs.getSelectedTab().isPrivate()) : tabs.getFirstTabForUrl(string2, tabs.getSelectedTab().isPrivate());
        if (tab == null) {
            return false;
        }
        return this.maybeSwitchToTab(tab.getId());
    }

    private boolean maybeSwitchToTab(int n) {
        Tabs tabs = Tabs.getInstance();
        Tab tab = tabs.getTab(n);
        if (tab == null) {
            return false;
        }
        Tab tab2 = tabs.getSelectedTab();
        if (tab2 != null) {
            tab2.setIsEditing(false);
        }
        this.mTargetTabForEditingMode = null;
        tabs.selectTab(tab.getId());
        this.mBrowserToolbar.cancelEdit();
        return true;
    }

    private void openUrlAndStopEditing(String string2) {
        this.openUrlAndStopEditing(string2, null, false);
    }

    private void openUrlAndStopEditing(String string2, boolean bl) {
        this.openUrlAndStopEditing(string2, null, bl);
    }

    private void openUrlAndStopEditing(String string2, String string3) {
        this.openUrlAndStopEditing(string2, string3, false);
    }

    private void openUrlAndStopEditing(String string2, String string3, boolean bl) {
        int n = 0;
        if (bl) {
            n |= 1;
            if (Tabs.getInstance().getSelectedTab().isPrivate()) {
                n |= 4;
            }
        }
        Tabs.getInstance().loadUrl(string2, string3, -1, n);
        this.mBrowserToolbar.cancelEdit();
    }

    private boolean isHomePagerVisible() {
        return this.mHomePager != null && this.mHomePager.isVisible() && this.mHomePagerContainer != null && this.mHomePagerContainer.getVisibility() == 0;
    }

    private boolean isFirstrunVisible() {
        return this.mFirstrunPane != null && this.mFirstrunPane.isVisible() && this.mHomePagerContainer != null && this.mHomePagerContainer.getVisibility() == 0;
    }

    private void enterEditingMode() {
        if (this.hideFirstrunPager()) {
            Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.ACTIONBAR, "firstrun-pane");
        }
        String string2 = "";
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            String string3 = tab.getUserRequested();
            string2 = TextUtils.isEmpty((CharSequence)string3) ? tab.getURL() : string3;
        }
        this.enterEditingMode(string2);
    }

    private void enterEditingMode(String string2) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if (this.mBrowserToolbar.isEditing() || this.mBrowserToolbar.isAnimating()) {
            return;
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.mTargetTabForEditingMode = tab.getId();
            string3 = tab.getMostRecentHomePanel();
        } else {
            this.mTargetTabForEditingMode = null;
            string3 = null;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.setUseHardwareLayer(false);
        TransitionsTracker.track(propertyAnimator);
        this.mBrowserToolbar.startEditing(string2, propertyAnimator);
        this.showHomePagerWithAnimator(string3, propertyAnimator);
        propertyAnimator.start();
        Telemetry.startUISession(TelemetryContract.Session.AWESOMESCREEN);
    }

    private void commitEditingMode() {
        if (!this.mBrowserToolbar.isEditing()) {
            return;
        }
        Telemetry.stopUISession(TelemetryContract.Session.AWESOMESCREEN, TelemetryContract.Reason.COMMIT);
        String string2 = this.mBrowserToolbar.commitEdit();
        this.hideHomePager(string2);
        this.loadUrlOrKeywordSearch(string2);
        this.clearSelectedTabApplicationId();
    }

    private void clearSelectedTabApplicationId() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            tab.setApplicationId(null);
        }
    }

    private void loadUrlOrKeywordSearch(final String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (!StringUtils.isSearchQuery((String)string2, (boolean)true)) {
            Tabs.getInstance().loadUrl(string2, 2);
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.ACTIONBAR, "user");
            return;
        }
        final BrowserDB browserDB = this.getProfile().getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string22;
                String string3;
                int n = string2.indexOf(" ");
                if (n == -1) {
                    string3 = string2;
                    string22 = "";
                } else {
                    string3 = string2.substring(0, n);
                    string22 = string2.substring(n + 1);
                }
                String string4 = browserDB.getUrlForKeyword(BrowserApp.this.getContentResolver(), string3);
                if (TextUtils.isEmpty((CharSequence)string4)) {
                    Tabs.getInstance().loadUrl(string2, 2);
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.ACTIONBAR, "user");
                    return;
                }
                BrowserApp.recordSearch(null, "barkeyword");
                String string5 = string4.replace("%s", URLEncoder.encode(string22)).replace("%S", string22);
                Tabs.getInstance().loadUrl(string5, 2);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.ACTIONBAR, "keyword");
            }
        });
    }

    private static void recordSearch(SearchEngine searchEngine, String string2) {
        try {
            String string3 = searchEngine == null ? "other" : searchEngine.getEngineIdentifier();
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("type", (Object)"Search:Event");
            jSONObject.put("location", (Object)string2);
            jSONObject.put("identifier", (Object)string3);
            EventDispatcher.getInstance().dispatchEvent(jSONObject, null);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error recording search.", (Throwable)exception);
        }
    }

    private void storeSearchQuery(final String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        GeckoProfile geckoProfile = this.getProfile();
        if (geckoProfile.inGuestMode()) {
            return;
        }
        final BrowserDB browserDB = geckoProfile.getDB();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                browserDB.getSearches().insert(BrowserApp.this.getContentResolver(), string2);
            }
        });
    }

    void filterEditingMode(String string2, AutocompleteHandler autocompleteHandler) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.hideBrowserSearch();
        } else {
            this.showBrowserSearch();
            this.mBrowserSearch.filter(string2, autocompleteHandler);
        }
    }

    private void selectTargetTabForEditingMode() {
        if (HardwareUtils.isTablet()) {
            return;
        }
        if (this.mTargetTabForEditingMode != null) {
            Tabs.getInstance().selectTab(this.mTargetTabForEditingMode);
        }
        this.mTargetTabForEditingMode = null;
    }

    private void updateHomePagerForTab(Tab tab) {
        if (this.mBrowserToolbar.isEditing()) {
            return;
        }
        if (BrowserApp.isAboutHome(tab)) {
            String string2 = AboutPages.getPanelIdFromAboutHomeUrl(tab.getURL());
            if (string2 == null) {
                string2 = tab.getMostRecentHomePanel();
            }
            this.showHomePager(string2);
            if (this.mDynamicToolbar.isEnabled()) {
                this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
            }
        } else {
            this.hideHomePager();
        }
    }

    @Override
    public void onLocaleReady(String string2) {
        Log.d((String)LOGTAG, (String)("onLocaleReady: " + string2));
        super.onLocaleReady(string2);
        HomePanelsManager.getInstance().onLocaleReady(string2);
        if (this.mMenu != null) {
            this.mMenu.clear();
            this.onCreateOptionsMenu(this.mMenu);
        }
    }

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
        Log.d((String)LOGTAG, (String)("onActivityResult: " + n + ", " + n2 + ", " + intent));
        switch (n) {
            case 1001: {
                if (n2 != 7) {
                    Log.d((String)LOGTAG, (String)"No locale change returning from preferences; nothing to do.");
                    return;
                }
                ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LocaleManager localeManager = BrowserLocaleManager.getInstance();
                        Locale locale = localeManager.getCurrentLocale(BrowserApp.this.getApplicationContext());
                        Log.d((String)BrowserApp.LOGTAG, (String)("Read persisted locale " + locale));
                        if (locale == null) {
                            return;
                        }
                        BrowserApp.this.onLocaleChanged(Locales.getLanguageTag(locale));
                    }
                });
                break;
            }
            case 2001: {
                TabQueueHelper.processTabQueuePromptResponse(n2, (Context)this);
                break;
            }
            default: {
                super.onActivityResult(n, n2, intent);
            }
        }
    }

    private void showFirstrunPager() {
        if (this.mFirstrunPane == null) {
            ViewStub viewStub = (ViewStub)this.findViewById(R.id.firstrun_pager_stub);
            this.mFirstrunPane = (FirstrunPane)viewStub.inflate();
            this.mFirstrunPane.load(this.getSupportFragmentManager());
            this.mFirstrunPane.registerOnFinishListener(new FirstrunPane.OnFinishListener(){

                @Override
                public void onFinish() {
                    BrowserApp.this.mFirstrunPane = null;
                }
            });
        }
        this.mHomePagerContainer.setVisibility(0);
    }

    private void showHomePager(String string2) {
        this.showHomePagerWithAnimator(string2, null);
    }

    private void showHomePagerWithAnimator(String string2, PropertyAnimator propertyAnimator) {
        if (this.isHomePagerVisible()) {
            this.mHomePager.showPanel(string2);
            return;
        }
        this.mFormAssistPopup.hide();
        this.mFindInPageBar.hide();
        this.refreshToolbarHeight();
        if (this.mDynamicToolbar.isEnabled()) {
            this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.IMMEDIATE);
        }
        if (this.mHomePager == null) {
            ViewStub viewStub = (ViewStub)this.findViewById(R.id.home_pager_stub);
            this.mHomePager = (HomePager)viewStub.inflate();
            this.mHomePager.setOnPanelChangeListener(new HomePager.OnPanelChangeListener(){

                @Override
                public void onPanelSelected(String string2) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab != null) {
                        tab.setMostRecentHomePanel(string2);
                    }
                }
            });
            if (!this.getProfile().inGuestMode()) {
                ViewStub viewStub2 = (ViewStub)this.findViewById(R.id.home_banner_stub);
                final HomeBanner homeBanner = (HomeBanner)viewStub2.inflate();
                this.mHomePager.setBanner(homeBanner);
                homeBanner.setOnDismissListener(new HomeBanner.OnDismissListener(){

                    @Override
                    public void onDismiss() {
                        BrowserApp.this.mHomePager.setBanner(null);
                        BrowserApp.this.mHomePagerContainer.removeView((View)homeBanner);
                    }
                });
            }
        }
        this.mHomePagerContainer.setVisibility(0);
        this.mHomePager.load(this.getSupportLoaderManager(), this.getSupportFragmentManager(), string2, propertyAnimator);
        this.hideWebContentOnPropertyAnimationEnd(propertyAnimator);
    }

    private void hideWebContentOnPropertyAnimationEnd(PropertyAnimator propertyAnimator) {
        if (propertyAnimator == null) {
            this.hideWebContent();
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
                BrowserApp.this.mHideWebContentOnAnimationEnd = true;
            }

            @Override
            public void onPropertyAnimationEnd() {
                if (BrowserApp.this.mHideWebContentOnAnimationEnd) {
                    BrowserApp.this.hideWebContent();
                }
            }
        });
    }

    private void hideWebContent() {
        this.mLayerView.setVisibility(4);
    }

    public boolean hideFirstrunPager() {
        if (!this.isFirstrunVisible()) {
            return false;
        }
        this.mFirstrunPane.hide();
        return true;
    }

    private void hideHomePager() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        String string2 = tab != null ? tab.getURL() : null;
        this.hideHomePager(string2);
    }

    private void hideHomePager(String string2) {
        if (!this.isHomePagerVisible() || AboutPages.isAboutHome(string2)) {
            return;
        }
        this.mHideWebContentOnAnimationEnd = false;
        this.mLayerView.setVisibility(0);
        this.mHomePagerContainer.setVisibility(8);
        if (this.mHomePager != null) {
            this.mHomePager.unload();
        }
        this.mBrowserToolbar.setNextFocusDownId(R.id.layer_view);
        this.refreshToolbarHeight();
    }

    private void showBrowserSearch() {
        if (this.mBrowserSearch.getUserVisibleHint()) {
            return;
        }
        this.mBrowserSearchContainer.setVisibility(0);
        this.mHomePagerContainer.setVisibility(4);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.executePendingTransactions();
        fragmentManager.beginTransaction().add(R.id.search_container, (Fragment)this.mBrowserSearch, BROWSER_SEARCH_TAG).commitAllowingStateLoss();
        this.mBrowserSearch.setUserVisibleHint(true);
        this.getActivity().getWindow().setBackgroundDrawableResource(17170443);
    }

    private void hideBrowserSearch() {
        if (!this.mBrowserSearch.getUserVisibleHint()) {
            return;
        }
        this.mHomePagerContainer.setVisibility(0);
        this.mBrowserSearchContainer.setVisibility(4);
        this.getSupportFragmentManager().beginTransaction().remove((Fragment)this.mBrowserSearch).commitAllowingStateLoss();
        this.mBrowserSearch.setUserVisibleHint(false);
        this.getWindow().setBackgroundDrawable(null);
    }

    private static Menu findParentMenu(Menu menu2, MenuItem menuItem) {
        int n = menuItem.getItemId();
        int n2 = menu2 != null ? menu2.size() : 0;
        for (int i = 0; i < n2; ++i) {
            Menu menu3;
            MenuItem menuItem2 = menu2.getItem(i);
            if (menuItem2.getItemId() == n) {
                return menu2;
            }
            if (!menuItem2.hasSubMenu() || (menu3 = BrowserApp.findParentMenu((Menu)menuItem2.getSubMenu(), menuItem)) == null) continue;
            return menu3;
        }
        return null;
    }

    private void addAddonMenuItemToMenu(Menu menu2, final MenuItemInfo menuItemInfo) {
        MenuItem menuItem;
        Object object;
        menuItemInfo.added = true;
        if (menuItemInfo.parent == 0) {
            object = menu2;
        } else if (menuItemInfo.parent == -1) {
            object = AppConstants.Versions.feature11Plus ? ((menuItem = menu2.findItem(R.id.tools)) != null ? menuItem.getSubMenu() : menu2) : menu2;
        } else {
            menuItem = menu2.findItem(menuItemInfo.parent);
            if (menuItem == null) {
                return;
            }
            Menu menu3 = BrowserApp.findParentMenu(menu2, menuItem);
            if (!menuItem.hasSubMenu()) {
                menu3.removeItem(menuItem.getItemId());
                object = menu3.addSubMenu(0, menuItem.getItemId(), 0, menuItem.getTitle());
                if (menuItem.getIcon() != null) {
                    ((SubMenu)object).getItem().setIcon(menuItem.getIcon());
                }
            } else {
                object = menuItem.getSubMenu();
            }
        }
        menuItem = object.add(0, menuItemInfo.id, 0, (CharSequence)menuItemInfo.label);
        menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Menu:Clicked", Integer.toString(menuItemInfo.id - 1000)));
                return true;
            }
        });
        if (menuItemInfo.icon == null) {
            menuItem.setIcon(R.drawable.ic_menu_addons_filler);
        } else {
            int n = menuItemInfo.id;
            BitmapUtils.getDrawable((Context)this, menuItemInfo.icon, new BitmapUtils.BitmapLoader((Menu)object, n){
                final /* synthetic */ Menu val$destination;
                final /* synthetic */ int val$id;
                {
                    this.val$destination = menu2;
                    this.val$id = n;
                }

                @Override
                public void onBitmapFound(Drawable drawable2) {
                    MenuItem menuItem = this.val$destination.findItem(this.val$id);
                    if (menuItem == null) {
                        return;
                    }
                    if (drawable2 == null) {
                        menuItem.setIcon(R.drawable.ic_menu_addons_filler);
                        return;
                    }
                    menuItem.setIcon(drawable2);
                }
            });
        }
        menuItem.setCheckable(menuItemInfo.checkable);
        menuItem.setChecked(menuItemInfo.checked);
        menuItem.setEnabled(menuItemInfo.enabled);
        menuItem.setVisible(menuItemInfo.visible);
    }

    private void addAddonMenuItem(MenuItemInfo menuItemInfo) {
        if (this.mAddonMenuItemsCache == null) {
            this.mAddonMenuItemsCache = new Vector();
        }
        menuItemInfo.added = this.mMenu != null;
        this.mAddonMenuItemsCache.add(menuItemInfo);
        if (this.mMenu == null) {
            return;
        }
        this.addAddonMenuItemToMenu(this.mMenu, menuItemInfo);
    }

    private void removeAddonMenuItem(int n) {
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo menuItemInfo : this.mAddonMenuItemsCache) {
                if (menuItemInfo.id != n) continue;
                this.mAddonMenuItemsCache.remove(menuItemInfo);
                break;
            }
        }
        if (this.mMenu == null) {
            return;
        }
        MenuItem menuItem = this.mMenu.findItem(n);
        if (menuItem != null) {
            this.mMenu.removeItem(n);
        }
    }

    private void updateAddonMenuItem(int n, JSONObject jSONObject) {
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo menuItemInfo : this.mAddonMenuItemsCache) {
                if (menuItemInfo.id != n) continue;
                menuItemInfo.label = jSONObject.optString("name", menuItemInfo.label);
                menuItemInfo.checkable = jSONObject.optBoolean("checkable", menuItemInfo.checkable);
                menuItemInfo.checked = jSONObject.optBoolean("checked", menuItemInfo.checked);
                menuItemInfo.enabled = jSONObject.optBoolean("enabled", menuItemInfo.enabled);
                menuItemInfo.visible = jSONObject.optBoolean("visible", menuItemInfo.visible);
                menuItemInfo.added = this.mMenu != null;
                break;
            }
        }
        if (this.mMenu == null) {
            return;
        }
        MenuItem menuItem = this.mMenu.findItem(n);
        if (menuItem != null) {
            menuItem.setTitle((CharSequence)jSONObject.optString("name", menuItem.getTitle().toString()));
            menuItem.setCheckable(jSONObject.optBoolean("checkable", menuItem.isCheckable()));
            menuItem.setChecked(jSONObject.optBoolean("checked", menuItem.isChecked()));
            menuItem.setEnabled(jSONObject.optBoolean("enabled", menuItem.isEnabled()));
            menuItem.setVisible(jSONObject.optBoolean("visible", menuItem.isVisible()));
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        if (menu2 instanceof GeckoMenu && HardwareUtils.isTablet()) {
            ((GeckoMenu)menu2).setActionItemBarPresenter(this.mBrowserToolbar);
        }
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.browser_app_menu, this.mMenu);
        if (this.mAddonMenuItemsCache != null && !this.mAddonMenuItemsCache.isEmpty()) {
            for (MenuItemInfo object : this.mAddonMenuItemsCache) {
                this.addAddonMenuItemToMenu(this.mMenu, object);
            }
        }
        if (AppConstants.Versions.feature14Plus) {
            GeckoMenuItem geckoMenuItem = (GeckoMenuItem)this.mMenu.findItem(R.id.share);
            GeckoMenuItem geckoMenuItem2 = (GeckoMenuItem)this.mMenu.findItem(R.id.quickshare);
            GeckoActionProvider geckoActionProvider = GeckoActionProvider.getForType("text/plain", (Context)this);
            geckoMenuItem.setActionProvider(geckoActionProvider);
            geckoMenuItem2.setActionProvider(geckoActionProvider);
        }
        return true;
    }

    public void openOptionsMenu() {
        if (this.mBrowserToolbar.isEditing() && !HardwareUtils.isTablet()) {
            return;
        }
        if (ActivityUtils.isFullScreen((Activity)this)) {
            return;
        }
        if (this.areTabsShown()) {
            this.mTabsPanel.showMenu();
            return;
        }
        if (this.mMenuPanel != null) {
            this.mMenuPanel.scrollTo(0, 0);
        }
        if (this.mMenu instanceof GeckoMenu) {
            ((GeckoMenu)this.mMenu).setSelection(0);
        }
        if (!this.mBrowserToolbar.openOptionsMenu()) {
            super.openOptionsMenu();
        }
        if (this.mDynamicToolbar.isEnabled()) {
            this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
        }
    }

    public void closeOptionsMenu() {
        if (!this.mBrowserToolbar.closeOptionsMenu()) {
            super.closeOptionsMenu();
        }
    }

    @Override
    public void setFullScreen(final boolean bl) {
        super.setFullScreen(bl);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    BrowserApp.this.mBrowserChrome.setVisibility(8);
                    if (BrowserApp.this.mDynamicToolbar.isEnabled()) {
                        BrowserApp.this.mDynamicToolbar.setVisible(false, DynamicToolbar.VisibilityTransition.IMMEDIATE);
                        BrowserApp.this.mLayerView.getLayerMarginsAnimator().setMaxMargins(0.0f, 0.0f, 0.0f, 0.0f);
                    } else {
                        BrowserApp.this.setToolbarMargin(0);
                    }
                } else {
                    BrowserApp.this.mBrowserChrome.setVisibility(0);
                    if (BrowserApp.this.mDynamicToolbar.isEnabled()) {
                        BrowserApp.this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.IMMEDIATE);
                        BrowserApp.this.mLayerView.getLayerMarginsAnimator().setMaxMargins(0.0f, BrowserApp.this.mToolbarHeight, 0.0f, 0.0f);
                    }
                }
            }
        });
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        String string2;
        String string3;
        View view;
        if (menu2 == null) {
            return false;
        }
        TabHistoryFragment tabHistoryFragment = (TabHistoryFragment)this.getSupportFragmentManager().findFragmentByTag(TAB_HISTORY_FRAGMENT_TAG);
        if (tabHistoryFragment != null) {
            tabHistoryFragment.dismiss();
        }
        if (!GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            menu2.findItem(R.id.settings).setEnabled(false);
            menu2.findItem(R.id.help).setEnabled(false);
        }
        Tab tab = Tabs.getInstance().getSelectedTab();
        MenuItem menuItem = menu2.findItem(R.id.bookmark);
        MenuItem menuItem2 = menu2.findItem(R.id.reading_list);
        MenuItem menuItem3 = menu2.findItem(R.id.back);
        MenuItem menuItem4 = menu2.findItem(R.id.forward);
        MenuItem menuItem5 = menu2.findItem(R.id.share);
        MenuItem menuItem6 = menu2.findItem(R.id.quickshare);
        MenuItem menuItem7 = menu2.findItem(R.id.save_as_pdf);
        MenuItem menuItem8 = menu2.findItem(R.id.char_encoding);
        MenuItem menuItem9 = menu2.findItem(R.id.find_in_page);
        MenuItem menuItem10 = menu2.findItem(R.id.desktop_mode);
        MenuItem menuItem11 = menu2.findItem(R.id.new_guest_session);
        MenuItem menuItem12 = menu2.findItem(R.id.exit_guest_session);
        boolean bl = AppConstants.Versions.preICS || HardwareUtils.isTelevision() || !PrefUtils.getStringSet((SharedPreferences)GeckoSharedPrefs.forProfile((Context)this), (String)"android.not_a_preference.history.clear_on_exit", new HashSet()).isEmpty();
        menu2.findItem(R.id.quit).setVisible(bl);
        menu2.findItem(R.id.logins).setVisible(true);
        if (tab == null || tab.getURL() == null) {
            menuItem.setEnabled(false);
            menuItem2.setEnabled(false);
            menuItem3.setEnabled(false);
            menuItem4.setEnabled(false);
            menuItem5.setEnabled(false);
            menuItem6.setEnabled(false);
            menuItem7.setEnabled(false);
            menuItem9.setEnabled(false);
            if (AppConstants.Versions.feature11Plus) {
                MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.page, (boolean)false);
            }
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.subscribe, (boolean)false);
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.add_search_engine, (boolean)false);
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.site_settings, (boolean)false);
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.add_to_launcher, (boolean)false);
            return true;
        }
        boolean bl2 = GeckoProfile.get((Context)this).inGuestMode();
        boolean bl3 = AboutPages.isAboutReader(tab.getURL());
        menuItem.setEnabled(!bl3);
        menuItem.setVisible(!bl2);
        menuItem.setCheckable(true);
        menuItem.setChecked(tab.isBookmark());
        menuItem.setIcon(this.resolveBookmarkIconID(tab.isBookmark()));
        menuItem.setTitle(this.resolveBookmarkTitleID(tab.isBookmark()));
        menuItem2.setEnabled(bl3 || !AboutPages.isAboutPage(tab.getURL()));
        menuItem2.setVisible(!bl2);
        menuItem2.setCheckable(true);
        boolean bl4 = tab.isInReadingList();
        menuItem2.setChecked(bl4);
        menuItem2.setIcon(this.resolveReadingListIconID(bl4));
        menuItem2.setTitle(this.resolveReadingListTitleID(bl4));
        menuItem3.setEnabled(tab.canDoBack());
        menuItem4.setEnabled(tab.canDoForward());
        menuItem10.setChecked(tab.getDesktopMode());
        menuItem10.setIcon(tab.getDesktopMode() ? R.drawable.ic_menu_desktop_mode_on : R.drawable.ic_menu_desktop_mode_off);
        View view2 = MenuItemCompat.getActionView((MenuItem)menuItem3);
        if (view2 != null) {
            view2.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab != null) {
                        BrowserApp.this.closeOptionsMenu();
                        return BrowserApp.this.tabHistoryController.showTabHistory(tab, TabHistoryController.HistoryAction.BACK);
                    }
                    return false;
                }
            });
        }
        if ((view = MenuItemCompat.getActionView((MenuItem)menuItem4)) != null) {
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab != null) {
                        BrowserApp.this.closeOptionsMenu();
                        return BrowserApp.this.tabHistoryController.showTabHistory(tab, TabHistoryController.HistoryAction.FORWARD);
                    }
                    return false;
                }
            });
        }
        if (AboutPages.isAboutReader(string3 = tab.getURL()) && (string2 = ReaderModeUtils.getUrlFromAboutReader(string3)) != null) {
            string3 = string2;
        }
        boolean bl5 = RestrictedProfiles.isAllowed((Context)this, RestrictedProfiles.Restriction.DISALLOW_SHARE);
        menuItem5.setVisible(bl5);
        boolean bl6 = StringUtils.isShareableUrl((String)string3) && bl5;
        menuItem5.setEnabled(bl6);
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.addons, (boolean)RestrictedProfiles.isAllowed((Context)this, RestrictedProfiles.Restriction.DISALLOW_INSTALL_EXTENSION));
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.downloads, (boolean)RestrictedProfiles.isAllowed((Context)this, RestrictedProfiles.Restriction.DISALLOW_DOWNLOADS));
        if (AppConstants.Versions.feature11Plus) {
            MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.page, (!BrowserApp.isAboutHome(tab) ? 1 : 0) != 0);
        }
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.subscribe, (boolean)tab.hasFeeds());
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.add_search_engine, (boolean)tab.hasOpenSearch());
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.site_settings, (!BrowserApp.isAboutHome(tab) ? 1 : 0) != 0);
        MenuUtils.safeSetEnabled((Menu)menu2, (int)R.id.add_to_launcher, (!BrowserApp.isAboutHome(tab) ? 1 : 0) != 0);
        if (AppConstants.Versions.feature14Plus) {
            menuItem6.setVisible(bl5);
            menuItem6.setEnabled(bl6);
            GeckoActionProvider geckoActionProvider = ((GeckoMenuItem)menuItem5).getGeckoActionProvider();
            if (geckoActionProvider != null) {
                Intent intent = geckoActionProvider.getIntent();
                if (intent == null) {
                    intent = new Intent("android.intent.action.SEND");
                    intent.setType("text/plain");
                    geckoActionProvider.setIntent(intent);
                }
                intent.putExtra("android.intent.extra.TEXT", string3);
                intent.putExtra("android.intent.extra.SUBJECT", tab.getDisplayTitle());
                intent.putExtra("android.intent.extra.TITLE", tab.getDisplayTitle());
                intent.putExtra("org.mozilla.fennec.intent.extra.DEVICES_ONLY", true);
                intent.removeExtra("share_screenshot_uri");
                BitmapDrawable bitmapDrawable = tab.getThumbnail();
                if (bitmapDrawable != null) {
                    File file;
                    Bitmap bitmap = bitmapDrawable.getBitmap();
                    if (Build.MANUFACTURER.equals("Kobo") && bitmap != null && (file = this.getExternalCacheDir()) != null) {
                        File file2 = new File(file, "thumbnail.png");
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file2);
                            bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)fileOutputStream);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Log.e((String)LOGTAG, (String)"File not found", (Throwable)fileNotFoundException);
                        }
                        intent.putExtra("share_screenshot_uri", (Parcelable)Uri.parse((String)file2.getPath()));
                    }
                }
            }
        }
        boolean bl7 = RestrictedProfiles.isAllowed((Context)this, RestrictedProfiles.Restriction.DISALLOW_TOOLS_MENU);
        MenuUtils.safeSetVisible((Menu)menu2, (int)R.id.tools, (boolean)bl7);
        menuItem7.setEnabled(!BrowserApp.isAboutHome(tab) && !tab.getContentType().equals("application/vnd.mozilla.xul+xml") && !tab.getContentType().startsWith("video/"));
        menuItem9.setEnabled(!BrowserApp.isAboutHome(tab));
        menuItem8.setVisible(GeckoPreferences.getCharEncodingState());
        if (this.mProfile.inGuestMode()) {
            menuItem12.setVisible(true);
        } else {
            menuItem11.setVisible(true);
        }
        return true;
    }

    private int resolveBookmarkIconID(boolean bl) {
        if (bl) {
            return R.drawable.ic_menu_bookmark_remove;
        }
        return R.drawable.ic_menu_bookmark_add;
    }

    private int resolveBookmarkTitleID(boolean bl) {
        return bl ? R.string.bookmark_remove : R.string.bookmark;
    }

    private int resolveReadingListIconID(boolean bl) {
        return bl ? R.drawable.ic_menu_reader_remove : R.drawable.ic_menu_reader_add;
    }

    private int resolveReadingListTitleID(boolean bl) {
        return bl ? R.string.reading_list_remove : R.string.overlay_share_reading_list_btn_label;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        Tab tab = null;
        Intent intent = null;
        int n = menuItem.getItemId();
        Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.MENU, this.getResources().getResourceEntryName(n));
        this.mBrowserToolbar.cancelEdit();
        if (n == R.id.bookmark) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (menuItem.isChecked()) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.UNSAVE, TelemetryContract.Method.MENU, "bookmark");
                    tab.removeBookmark();
                    menuItem.setIcon(this.resolveBookmarkIconID(false));
                    menuItem.setTitle(this.resolveBookmarkTitleID(false));
                } else {
                    Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.MENU, "bookmark");
                    tab.addBookmark();
                    menuItem.setIcon(this.resolveBookmarkIconID(true));
                    menuItem.setTitle(this.resolveBookmarkTitleID(true));
                }
            }
            return true;
        }
        if (n == R.id.reading_list) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (menuItem.isChecked()) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.UNSAVE, TelemetryContract.Method.MENU, "reading_list");
                    tab.removeFromReadingList();
                    menuItem.setIcon(this.resolveReadingListIconID(false));
                    menuItem.setTitle(this.resolveReadingListTitleID(false));
                } else {
                    Telemetry.sendUIEvent(TelemetryContract.Event.SAVE, TelemetryContract.Method.MENU, "reading_list");
                    tab.addToReadingList();
                    menuItem.setIcon(this.resolveReadingListIconID(true));
                    menuItem.setTitle(this.resolveReadingListTitleID(true));
                }
            }
            return true;
        }
        if (n == R.id.share) {
            this.shareCurrentUrl();
            return true;
        }
        if (n == R.id.reload) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doReload();
            }
            return true;
        }
        if (n == R.id.back) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doBack();
            }
            return true;
        }
        if (n == R.id.forward) {
            tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                tab.doForward();
            }
            return true;
        }
        if (n == R.id.save_as_pdf) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SaveAs:PDF", null));
            return true;
        }
        if (n == R.id.settings) {
            intent = new Intent((Context)this, GeckoPreferences.class);
            this.startActivityForResult(intent, 1001);
            return true;
        }
        if (n == R.id.help) {
            String string2 = Locales.getLanguageTag(Locale.getDefault());
            String string3 = this.getResources().getString(R.string.help_link, new Object[]{"42.0a1", "Android", string2});
            Tabs.getInstance().loadUrlInTab(string3);
            return true;
        }
        if (n == R.id.addons) {
            Tabs.getInstance().loadUrlInTab("about:addons");
            return true;
        }
        if (n == R.id.logins) {
            Tabs.getInstance().loadUrlInTab("about:logins");
            return true;
        }
        if (n == R.id.downloads) {
            Tabs.getInstance().loadUrlInTab("about:downloads");
            return true;
        }
        if (n == R.id.char_encoding) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("CharEncoding:Get", null));
            return true;
        }
        if (n == R.id.find_in_page) {
            this.mFindInPageBar.show();
            return true;
        }
        if (n == R.id.desktop_mode) {
            Tab tab2 = Tabs.getInstance().getSelectedTab();
            if (tab2 == null) {
                return true;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("desktopMode", !menuItem.isChecked());
                jSONObject.put("tabId", tab2.getId());
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"error building json arguments", (Throwable)jSONException);
            }
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("DesktopMode:Change", jSONObject.toString()));
            return true;
        }
        if (n == R.id.new_tab) {
            this.addTab();
            return true;
        }
        if (n == R.id.new_private_tab) {
            this.addPrivateTab();
            return true;
        }
        if (n == R.id.new_guest_session) {
            this.showGuestModeDialog(GuestModeDialog.ENTERING);
            return true;
        }
        if (n == R.id.exit_guest_session) {
            this.showGuestModeDialog(GuestModeDialog.LEAVING);
            return true;
        }
        if (this.onContextItemSelected(menuItem)) {
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void showGuestModeDialog(final GuestModeDialog guestModeDialog) {
        Prompt prompt = new Prompt((Context)this, new Prompt.PromptCallback(){

            @Override
            public void onPromptFinished(String string2) {
                try {
                    int n = new JSONObject(string2).getInt("button");
                    if (n == 0) {
                        String string3 = "";
                        if (guestModeDialog == GuestModeDialog.ENTERING) {
                            string3 = BrowserApp.GUEST_BROWSING_ARG;
                        } else {
                            GeckoProfile.leaveGuestSession((Context)BrowserApp.this);
                            GuestSession.hideNotification((Context)BrowserApp.this);
                        }
                        BrowserApp.this.doRestart(string3);
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)BrowserApp.LOGTAG, (String)"Exception reading guest mode prompt result", (Throwable)jSONException);
                }
            }
        });
        Resources resources = this.getResources();
        prompt.setButtons(new String[]{resources.getString(R.string.guest_session_dialog_continue), resources.getString(R.string.guest_session_dialog_cancel)});
        int n = 0;
        int n2 = 0;
        if (guestModeDialog == GuestModeDialog.ENTERING) {
            n = R.string.new_guest_session_title;
            n2 = R.string.new_guest_session_text;
        } else {
            n = R.string.exit_guest_session_title;
            n2 = R.string.exit_guest_session_text;
        }
        prompt.show(resources.getString(n), resources.getString(n2), null, 0);
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        if (n == 4) {
            TabHistoryFragment tabHistoryFragment = (TabHistoryFragment)this.getSupportFragmentManager().findFragmentByTag(TAB_HISTORY_FRAGMENT_TAG);
            if (tabHistoryFragment != null) {
                return false;
            }
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null && !tab.isEditing()) {
                return this.tabHistoryController.showTabHistory(tab, TabHistoryController.HistoryAction.ALL);
            }
        }
        return super.onKeyLongPress(n, keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onNewIntent(Intent intent) {
        String string2;
        String string3 = intent.getAction();
        boolean bl = "android.intent.action.VIEW".equals(string3);
        boolean bl2 = "org.mozilla.gecko.BOOKMARK".equals(string3);
        boolean bl3 = "TAB_QUEUE_LOAD_URLS_ACTION".equals(string3);
        if (this.mInitialized && (bl || bl2)) {
            this.mBrowserToolbar.cancelEdit();
            this.hideFirstrunPager();
            if (bl2) {
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.HOMESCREEN);
            }
        }
        this.showTabQueuePromptIfApplicable(intent);
        super.onNewIntent(intent);
        if (AppConstants.MOZ_ANDROID_BEAM && "android.nfc.action.NDEF_DISCOVERED".equals(string3)) {
            string2 = intent.getDataString();
            GeckoAppShell.sendEventToGecko(GeckoEvent.createURILoadEvent(string2));
        }
        if ("org.mozilla.gecko.GUEST_SESSION_INPROGRESS".equals(string3)) {
            GuestSession.handleIntent(this, intent);
        }
        if (this.mInitialized && bl3) {
            Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.NOTIFICATION, "tabqueue");
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserApp.this.openQueuedTabs();
                }
            });
        }
        if (!this.mInitialized || !"android.intent.action.MAIN".equals(string3)) {
            return;
        }
        string2 = this.getPackageName() + ".feedback_launch_count";
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            SharedPreferences sharedPreferences = this.getPreferences(0);
            int n = sharedPreferences.getInt(string2, 0);
            if (n < 15) {
                sharedPreferences.edit().putInt(string2, ++n).apply();
                if (n == 15) {
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Feedback:Show", null));
                }
            }
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private void showTabQueuePromptIfApplicable(final Intent intent) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BrowserApp.this.mInitialized && "android.intent.action.VIEW".equals(intent.getAction()) && TabQueueHelper.shouldShowTabQueuePrompt((Context)BrowserApp.this)) {
                    Intent intent2 = new Intent((Context)BrowserApp.this, TabQueuePrompt.class);
                    BrowserApp.this.startActivityForResult(intent2, 2001);
                }
            }
        });
    }

    @Override
    protected NotificationClient makeNotificationClient() {
        return new ServiceNotificationClient(this.getApplicationContext());
    }

    private void resetFeedbackLaunchCount() {
        SharedPreferences sharedPreferences = this.getPreferences(0);
        sharedPreferences.edit().putInt(this.getPackageName() + ".feedback_launch_count", 0).apply();
    }

    private void getLastUrl(final EventCallback eventCallback) {
        final BrowserDB browserDB = this.getProfile().getDB();
        new UIAsyncTask.WithoutParams<String>(ThreadUtils.getBackgroundHandler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized String doInBackground() {
                Cursor cursor = browserDB.getRecentHistory(BrowserApp.this.getContentResolver(), 1);
                if (cursor == null) {
                    return "";
                }
                try {
                    if (cursor.moveToFirst()) {
                        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                        return string2;
                    }
                    String string3 = "";
                    return string3;
                }
                finally {
                    cursor.close();
                }
            }

            public void onPostExecute(String string2) {
                eventCallback.sendSuccess((Object)string2);
            }
        }.execute();
    }

    @Override
    public void onUrlOpen(String string2, EnumSet<HomePager.OnUrlOpenListener.Flags> enumSet) {
        if (enumSet.contains((Object)HomePager.OnUrlOpenListener.Flags.OPEN_WITH_INTENT)) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
            this.startActivity(intent);
        } else if (!this.maybeSwitchToTab(string2, enumSet)) {
            this.openUrlAndStopEditing(string2);
            this.clearSelectedTabApplicationId();
        }
    }

    @Override
    public void onUrlOpenInBackground(String string2, EnumSet<HomePager.OnUrlOpenInBackgroundListener.Flags> enumSet) {
        if (string2 == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        if (enumSet == null) {
            throw new IllegalArgumentException("flags must not be null");
        }
        boolean bl = enumSet.contains((Object)HomePager.OnUrlOpenInBackgroundListener.Flags.PRIVATE);
        int n = 65;
        if (bl) {
            n |= 4;
        }
        Tab tab = Tabs.getInstance().loadUrl(string2, n);
        final int n2 = tab.getId();
        ButtonToast.ToastListener toastListener = new ButtonToast.ToastListener(){

            @Override
            public void onButtonClicked() {
                BrowserApp.this.maybeSwitchToTab(n2);
            }

            @Override
            public void onToastHidden(ButtonToast.ReasonHidden reasonHidden) {
            }
        };
        String string3 = bl ? this.getResources().getString(R.string.new_private_tab_opened) : this.getResources().getString(R.string.new_tab_opened);
        String string4 = this.getResources().getString(R.string.switch_button_message);
        this.getButtonToast().show(false, (CharSequence)string3, ButtonToast.LENGTH_SHORT, (CharSequence)string4, R.drawable.switch_button_icon, toastListener);
    }

    @Override
    public void onSearch(SearchEngine searchEngine, String string2) {
        if (!Tabs.getInstance().getSelectedTab().isPrivate()) {
            this.storeSearchQuery(string2);
        }
        BrowserApp.recordSearch(searchEngine, "barsuggest");
        this.openUrlAndStopEditing(string2, searchEngine.name);
    }

    @Override
    public void onEditSuggestion(String string2) {
        this.mBrowserToolbar.onEditSuggestion(string2);
    }

    @Override
    public int getLayout() {
        return R.layout.gecko_app;
    }

    @Override
    protected String getDefaultProfileName() throws GeckoProfileDirectories.NoMozillaDirectoryException {
        return GeckoProfile.getDefaultProfileName((Context)this);
    }

    @RobocopTarget
    public ReadingListHelper getReadingListHelper() {
        return this.mReadingListHelper;
    }

    protected boolean handleUpdaterLaunch() {
        Tabs.getInstance().loadUrlInTab("about:");
        return true;
    }

    @Override
    public void startActionModeCompat(ActionModeCompat.Callback callback) {
        if (this.mActionMode == null) {
            this.mActionBarFlipper.showNext();
            LayerMarginsAnimator layerMarginsAnimator = this.mLayerView.getLayerMarginsAnimator();
            if (this.mDynamicToolbar.isEnabled() && !layerMarginsAnimator.areMarginsShown()) {
                layerMarginsAnimator.setMaxMargins(0.0f, this.mBrowserChrome.getHeight(), 0.0f, 0.0f);
                this.mDynamicToolbar.setVisible(true, DynamicToolbar.VisibilityTransition.ANIMATE);
                this.mHideDynamicToolbarOnActionModeEnd = true;
            } else {
                this.mActionBar.animateIn();
                this.mHideDynamicToolbarOnActionModeEnd = false;
            }
            this.mDynamicToolbar.setPinned(true, DynamicToolbar.PinReason.ACTION_MODE);
        } else {
            this.mActionMode.finish();
        }
        this.mActionMode = new ActionModeCompat(this, callback, this.mActionBar);
        if (callback.onCreateActionMode(this.mActionMode, this.mActionMode.getMenu())) {
            this.mActionMode.invalidate();
        }
    }

    @Override
    public void endActionModeCompat() {
        if (this.mActionMode == null) {
            return;
        }
        this.mActionMode.finish();
        this.mActionMode = null;
        this.mDynamicToolbar.setPinned(false, DynamicToolbar.PinReason.ACTION_MODE);
        this.mActionBarFlipper.showPrevious();
        if (this.mHideDynamicToolbarOnActionModeEnd) {
            this.mDynamicToolbar.setVisible(false, DynamicToolbar.VisibilityTransition.IMMEDIATE);
        }
    }

    @Override
    protected HealthRecorder createHealthRecorder(Context context, String string2, EventDispatcher eventDispatcher, String string3, String string4, SessionInformation sessionInformation) {
        return new BrowserHealthRecorder(context, GeckoSharedPrefs.forApp(context), string2, eventDispatcher, string3, string4, sessionInformation);
    }

    @Override
    protected GeckoApp.StartupAction getStartupAction(String string2) {
        boolean bl = GeckoProfile.get((Context)this).inGuestMode();
        if (bl) {
            return GeckoApp.StartupAction.GUEST;
        }
        return string2 == null ? GeckoApp.StartupAction.NORMAL : GeckoApp.StartupAction.URL;
    }

    public static interface Refreshable {
        public void refresh();
    }

    private class HideOnTouchListener
    implements TouchEventInterceptor {
        private boolean mIsHidingTabs;
        private final Rect mTempRect = new Rect();

        private HideOnTouchListener() {
        }

        @Override
        public boolean onInterceptTouchEvent(View view, MotionEvent motionEvent) {
            if (BrowserApp.this.mToast != null) {
                BrowserApp.this.mToast.hide(false, ButtonToast.ReasonHidden.TOUCH_OUTSIDE);
            }
            if (view.getScrollX() != 0 || view.getScrollY() != 0) {
                view.getHitRect(this.mTempRect);
                this.mTempRect.offset(-view.getScrollX(), -view.getScrollY());
                int[] nArray = new int[2];
                view.getLocationOnScreen(nArray);
                int n = (int)motionEvent.getRawX() - nArray[0];
                int n2 = (int)motionEvent.getRawY() - nArray[1];
                if (!this.mTempRect.contains(n, n2)) {
                    return false;
                }
            }
            if (motionEvent.getActionMasked() == 0 && BrowserApp.this.autoHideTabs()) {
                this.mIsHidingTabs = true;
                return true;
            }
            return false;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (this.mIsHidingTabs) {
                int n = motionEvent.getActionMasked();
                if (n == 1 || n == 3) {
                    this.mIsHidingTabs = false;
                }
                return true;
            }
            return false;
        }
    }

    private class DragHelper
    implements OuterLayout.DragCallback {
        private int[] mToolbarLocation = new int[2];
        private int mStatusBarHeight;

        public DragHelper() {
            ((GeckoApp.MainLayout)BrowserApp.this.mMainLayout).setLayoutInterceptor(new LayoutInterceptor(){

                @Override
                public void onLayout() {
                    if (BrowserApp.this.mRootLayout.isMoving()) {
                        BrowserApp.this.mRootLayout.restoreTargetViewPosition();
                    }
                }
            });
        }

        @Override
        public void onDragProgress(float f) {
            BrowserApp.this.mBrowserToolbar.setToolBarButtonsAlpha(1.0f - f);
            BrowserApp.this.mTabsPanel.translateInRange(f);
        }

        @Override
        public View getViewToDrag() {
            return BrowserApp.this.mMainLayout;
        }

        @Override
        public void startDrag(boolean bl) {
            if (bl) {
                BrowserApp.this.mTabsPanel.setHWLayerEnabled(true);
                BrowserApp.this.mMainLayout.offsetTopAndBottom(this.getDragRange());
                BrowserApp.this.mMainLayout.scrollTo(0, 0);
            } else {
                this.prepareTabsToShow();
                BrowserApp.this.mBrowserToolbar.hideVirtualKeyboard();
            }
            BrowserApp.this.mBrowserToolbar.setContextMenuEnabled(false);
        }

        @Override
        public void stopDrag(boolean bl) {
            if (bl) {
                BrowserApp.this.mTabsPanel.setHWLayerEnabled(false);
                BrowserApp.this.mMainLayout.offsetTopAndBottom(-this.getDragRange());
                BrowserApp.this.mMainLayout.scrollTo(0, -this.getDragRange());
            } else {
                BrowserApp.this.mTabsPanel.hideImmediately();
                BrowserApp.this.mTabsPanel.setHWLayerEnabled(false);
            }
            if (bl) {
                BrowserApp.this.mBrowserToolbar.setContextMenuEnabled(false);
            } else {
                BrowserApp.this.mBrowserToolbar.setContextMenuEnabled(true);
            }
        }

        @Override
        public int getDragRange() {
            return BrowserApp.this.mTabsPanel.getVerticalPanelHeight();
        }

        @Override
        public int getOrderedChildIndex(int n) {
            int n2 = BrowserApp.this.mRootLayout.indexOfChild((View)BrowserApp.this.mMainLayout);
            if (!(n <= n2 || BrowserApp.this.mToast != null && BrowserApp.this.mToast.isVisible())) {
                return n2;
            }
            return n;
        }

        @Override
        public boolean canDrag(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean canInterceptEventWhileOpen(MotionEvent motionEvent) {
            if (motionEvent.getActionMasked() != 0) {
                return false;
            }
            return BrowserApp.this.mRootLayout.findTopChildUnder(motionEvent) == BrowserApp.this.mMainLayout && this.isInToolbarBounds((int)motionEvent.getRawY());
        }

        private boolean isInToolbarBounds(int n) {
            BrowserApp.this.mBrowserToolbar.getLocationOnScreen(this.mToolbarLocation);
            int n2 = this.mToolbarLocation[1] + BrowserApp.this.mBrowserToolbar.getMeasuredHeight();
            int n3 = this.mToolbarLocation[1];
            return n > n3 && n < n2;
        }

        public void prepareTabsToShow() {
            if (BrowserApp.this.ensureTabsPanelExists()) {
                ViewTreeObserver viewTreeObserver = BrowserApp.this.mTabsPanel.getViewTreeObserver();
                if (viewTreeObserver.isAlive()) {
                    viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                        public void onGlobalLayout() {
                            BrowserApp.this.mTabsPanel.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                            DragHelper.this.prepareTabsToShow();
                        }
                    });
                }
            } else {
                BrowserApp.this.mTabsPanel.prepareToDrag();
            }
        }

        @Override
        public int getLowerLimit() {
            return this.getStatusBarHeight();
        }

        private int getStatusBarHeight() {
            if (this.mStatusBarHeight != 0) {
                return this.mStatusBarHeight;
            }
            int n = BrowserApp.this.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (n > 0) {
                this.mStatusBarHeight = BrowserApp.this.getResources().getDimensionPixelSize(n);
                return this.mStatusBarHeight;
            }
            Log.e((String)BrowserApp.LOGTAG, (String)"Unable to find statusbar height");
            return 0;
        }
    }

    public static enum GuestModeDialog {
        ENTERING,
        LEAVING;

    }

    private static class MenuItemInfo {
        public int id;
        public String label;
        public String icon;
        public boolean checkable;
        public boolean checked;
        public boolean enabled = true;
        public boolean visible = true;
        public int parent;
        public boolean added;

        private MenuItemInfo() {
        }
    }
}

