/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.animation;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;

public class Rotate3DAnimation
extends Animation {
    private final float mFromDegrees;
    private final float mToDegrees;
    private final float mCenterX;
    private final float mCenterY;
    private final float mDepthZ;
    private final boolean mReverse;
    private Camera mCamera;
    private int mWidth = 1;
    private int mHeight = 1;

    public Rotate3DAnimation(float f, float f2, float f3, float f4, float f5, boolean bl) {
        this.mFromDegrees = f;
        this.mToDegrees = f2;
        this.mCenterX = f3;
        this.mCenterY = f4;
        this.mDepthZ = f5;
        this.mReverse = bl;
    }

    public void initialize(int n, int n2, int n3, int n4) {
        super.initialize(n, n2, n3, n4);
        this.mCamera = new Camera();
        this.mWidth = n;
        this.mHeight = n2;
    }

    protected void applyTransformation(float f, Transformation transformation) {
        float f2 = this.mFromDegrees;
        float f3 = f2 + (this.mToDegrees - f2) * f;
        Camera camera = this.mCamera;
        Matrix matrix = transformation.getMatrix();
        camera.save();
        if (this.mReverse) {
            camera.translate(0.0f, 0.0f, this.mDepthZ * f);
        } else {
            camera.translate(0.0f, 0.0f, this.mDepthZ * (1.0f - f));
        }
        camera.rotateX(f3);
        camera.getMatrix(matrix);
        camera.restore();
        matrix.preTranslate(-this.mCenterX * (float)this.mWidth, -this.mCenterY * (float)this.mHeight);
        matrix.postTranslate(this.mCenterX * (float)this.mWidth, this.mCenterY * (float)this.mHeight);
    }
}

