/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.DSACryptoImplementation;
import org.mozilla.gecko.browserid.JSONWebTokenUtils;
import org.mozilla.gecko.browserid.SigningPrivateKey;
import org.mozilla.gecko.browserid.VerifyingPublicKey;

public class MockMyIDTokenFactory {
    public static final BigInteger MOCKMYID_x = new BigInteger("385cb3509f086e110c5e24bdd395a84b335a09ae", 16);
    public static final BigInteger MOCKMYID_y = new BigInteger("738ec929b559b604a232a9b55a5295afc368063bb9c20fac4e53a74970a4db7956d48e4c7ed523405f629b4cc83062f13029c4d615bbacb8b97f5e56f0c7ac9bc1d4e23809889fa061425c984061fca1826040c399715ce7ed385c4dd0d402256912451e03452d3c961614eb458f188e3e8d2782916c43dbe2e571251ce38262", 16);
    public static final BigInteger MOCKMYID_p = new BigInteger("ff600483db6abfc5b45eab78594b3533d550d9f1bf2a992a7a8daa6dc34f8045ad4e6e0c429d334eeeaaefd7e23d4810be00e4cc1492cba325ba81ff2d5a5b305a8d17eb3bf4a06a349d392e00d329744a5179380344e82a18c47933438f891e22aeef812d69c8f75e326cb70ea000c3f776dfdbd604638c2ef717fc26d02e17", 16);
    public static final BigInteger MOCKMYID_q = new BigInteger("e21e04f911d1ed7991008ecaab3bf775984309c3", 16);
    public static final BigInteger MOCKMYID_g = new BigInteger("c52a4a0ff3b7e61fdf1867ce84138369a6154f4afa92966e3c827e25cfa6cf508b90e5de419e1337e07a2e9e2a3cd5dea704d175f8ebf6af397d69e110b96afb17c7a03259329e4829b0d03bbc7896b15b4ade53e130858cc34d96269aa89041f409136c7242a38895c9d5bccad4f389af1d7a4bd1398bd072dffa896233397a", 16);
    protected static SigningPrivateKey cachedMockMyIDPrivateKey;

    public static SigningPrivateKey getMockMyIDPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (cachedMockMyIDPrivateKey == null) {
            cachedMockMyIDPrivateKey = DSACryptoImplementation.createPrivateKey(MOCKMYID_x, MOCKMYID_p, MOCKMYID_q, MOCKMYID_g);
        }
        return cachedMockMyIDPrivateKey;
    }

    public String createMockMyIDCertificate(VerifyingPublicKey verifyingPublicKey, String string2, long l, long l2) throws Exception {
        if (!string2.endsWith("@mockmyid.com")) {
            string2 = string2 + "@mockmyid.com";
        }
        SigningPrivateKey signingPrivateKey = MockMyIDTokenFactory.getMockMyIDPrivateKey();
        return JSONWebTokenUtils.createCertificate(verifyingPublicKey, string2, "mockmyid.com", l, l2, signingPrivateKey);
    }

    public String createMockMyIDCertificate(VerifyingPublicKey verifyingPublicKey, String string2) throws Exception {
        long l = System.currentTimeMillis();
        long l2 = l + 3600000L;
        return this.createMockMyIDCertificate(verifyingPublicKey, string2, l, l2);
    }

    public String createMockMyIDAssertion(BrowserIDKeyPair browserIDKeyPair, String string2, String string3, long l, long l2, Long l3, long l4) throws Exception {
        String string4 = this.createMockMyIDCertificate(browserIDKeyPair.getPublic(), string2, l, l2);
        return JSONWebTokenUtils.createAssertion(browserIDKeyPair.getPrivate(), string4, string3, "127.0.0.1", l3, l4);
    }

    public String createMockMyIDAssertion(BrowserIDKeyPair browserIDKeyPair, String string2, String string3) throws Exception {
        long l = System.currentTimeMillis();
        long l2 = l + 3600000L;
        long l3 = l + 1L;
        long l4 = l3 + 3600000L;
        return this.createMockMyIDAssertion(browserIDKeyPair, string2, string3, l, l2, l3, l4);
    }
}

