/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.db.TabsAccessor;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public class LocalTabsAccessor
implements TabsAccessor {
    private static final String LOGTAG = "GeckoTabsAccessor";
    public static final String[] TABS_PROJECTION_COLUMNS = new String[]{"title", "url", "guid", "name", "last_used", "last_modified", "device_type"};
    public static final String[] CLIENTS_PROJECTION_COLUMNS = new String[]{"guid", "name", "last_modified", "device_type"};
    private static final String REMOTE_CLIENTS_SELECTION = "guid IS NOT NULL";
    private static final String LOCAL_TABS_SELECTION = "client_guid IS NULL";
    private static final String REMOTE_TABS_SELECTION = "client_guid IS NOT NULL";
    private static final String REMOTE_TABS_SORT_ORDER = "last_modified DESC, guid DESC, last_used DESC";
    private static final String LOCAL_CLIENT_SELECTION = "guid IS NULL";
    private static final Pattern FILTERED_URL_PATTERN = Pattern.compile("^(about|chrome|wyciwyg|file):");
    private final Uri clientsRecencyUriWithProfile;
    private final Uri tabsUriWithProfile;
    private final Uri clientsUriWithProfile;

    public LocalTabsAccessor(String string2) {
        this.tabsUriWithProfile = DBUtils.appendProfileWithDefault(string2, BrowserContract.Tabs.CONTENT_URI);
        this.clientsUriWithProfile = DBUtils.appendProfileWithDefault(string2, BrowserContract.Clients.CONTENT_URI);
        this.clientsRecencyUriWithProfile = DBUtils.appendProfileWithDefault(string2, BrowserContract.Clients.CONTENT_RECENCY_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RemoteClient> getClientsWithoutTabsByRecencyFromCursor(Cursor cursor) {
        ArrayList<RemoteClient> arrayList = new ArrayList<RemoteClient>(cursor.getCount());
        int n = cursor.getPosition();
        try {
            if (!cursor.moveToFirst()) {
                ArrayList<RemoteClient> arrayList2 = arrayList;
                return arrayList2;
            }
            int n2 = cursor.getColumnIndex("guid");
            int n3 = cursor.getColumnIndex("name");
            int n4 = cursor.getColumnIndex("last_modified");
            int n5 = cursor.getColumnIndex("device_type");
            while (!cursor.isAfterLast()) {
                String string2 = cursor.getString(n2);
                String string3 = cursor.getString(n3);
                String string4 = cursor.getString(n5);
                long l = cursor.getLong(n4);
                arrayList.add(new RemoteClient(string2, string3, l, string4));
                cursor.moveToNext();
            }
        }
        finally {
            cursor.moveToPosition(n);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RemoteClient> getClientsFromCursor(Cursor cursor) {
        ArrayList<RemoteClient> arrayList = new ArrayList<RemoteClient>();
        int n = cursor.getPosition();
        try {
            if (!cursor.moveToFirst()) {
                ArrayList<RemoteClient> arrayList2 = arrayList;
                return arrayList2;
            }
            int n2 = cursor.getColumnIndex("title");
            int n3 = cursor.getColumnIndex("url");
            int n4 = cursor.getColumnIndex("last_used");
            int n5 = cursor.getColumnIndex("guid");
            int n6 = cursor.getColumnIndex("name");
            int n7 = cursor.getColumnIndex("last_modified");
            int n8 = cursor.getColumnIndex("device_type");
            RemoteClient remoteClient = null;
            while (!cursor.isAfterLast()) {
                String string2;
                String string3 = cursor.getString(n5);
                if (remoteClient == null || !TextUtils.equals((CharSequence)remoteClient.guid, (CharSequence)string3)) {
                    string2 = cursor.getString(n6);
                    long l = cursor.getLong(n7);
                    String string4 = cursor.getString(n8);
                    remoteClient = new RemoteClient(string3, string2, l, string4);
                    arrayList.add(remoteClient);
                }
                string2 = cursor.getString(n2);
                String string5 = cursor.getString(n3);
                long l = cursor.getLong(n4);
                remoteClient.tabs.add(new RemoteTab(string2, string5, l));
                cursor.moveToNext();
            }
        }
        finally {
            cursor.moveToPosition(n);
        }
        return arrayList;
    }

    @Override
    public Cursor getRemoteClientsByRecencyCursor(Context context) {
        Uri uri = this.clientsRecencyUriWithProfile;
        return context.getContentResolver().query(uri, CLIENTS_PROJECTION_COLUMNS, REMOTE_CLIENTS_SELECTION, null, null);
    }

    @Override
    public Cursor getRemoteTabsCursor(Context context) {
        return this.getRemoteTabsCursor(context, -1);
    }

    @Override
    public Cursor getRemoteTabsCursor(Context context, int n) {
        Uri uri = this.tabsUriWithProfile;
        if (n > 0) {
            uri = uri.buildUpon().appendQueryParameter("limit", String.valueOf(n)).build();
        }
        Cursor cursor = context.getContentResolver().query(uri, TABS_PROJECTION_COLUMNS, REMOTE_TABS_SELECTION, null, REMOTE_TABS_SORT_ORDER);
        return cursor;
    }

    @Override
    public void getTabs(Context context, TabsAccessor.OnQueryTabsCompleteListener onQueryTabsCompleteListener) {
        this.getTabs(context, 0, onQueryTabsCompleteListener);
    }

    @Override
    public void getTabs(final Context context, final int n, final TabsAccessor.OnQueryTabsCompleteListener onQueryTabsCompleteListener) {
        if (onQueryTabsCompleteListener == null) {
            return;
        }
        new UIAsyncTask.WithoutParams<List<RemoteClient>>(ThreadUtils.getBackgroundHandler()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<RemoteClient> doInBackground() {
                Cursor cursor = LocalTabsAccessor.this.getRemoteTabsCursor(context, n);
                if (cursor == null) {
                    return null;
                }
                try {
                    List<RemoteClient> list = Collections.unmodifiableList(LocalTabsAccessor.this.getClientsFromCursor(cursor));
                    return list;
                }
                finally {
                    cursor.close();
                }
            }

            protected void onPostExecute(List<RemoteClient> list) {
                onQueryTabsCompleteListener.onQueryTabsComplete(list);
            }
        }.execute();
    }

    private void updateLocalClient(ContentResolver contentResolver) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("last_modified", Long.valueOf(System.currentTimeMillis()));
        contentResolver.update(this.clientsUriWithProfile, contentValues, LOCAL_CLIENT_SELECTION, null);
    }

    private void deleteLocalTabs(ContentResolver contentResolver) {
        contentResolver.delete(this.tabsUriWithProfile, LOCAL_TABS_SELECTION, null);
    }

    private void insertLocalTabs(ContentResolver contentResolver, Iterable<Tab> iterable) {
        JSONArray jSONArray = new JSONArray();
        ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
        int n = 0;
        for (Tab tab : iterable) {
            String string2 = tab.getURL();
            if (string2 == null || tab.isPrivate() || this.isFilteredURL(string2)) continue;
            ContentValues contentValues = new ContentValues();
            contentValues.put("url", string2);
            contentValues.put("title", tab.getTitle());
            contentValues.put("last_used", Long.valueOf(tab.getLastUsed()));
            String string3 = tab.getFaviconURL();
            if (string3 != null) {
                contentValues.put("favicon", string3);
            } else {
                contentValues.putNull("favicon");
            }
            try {
                jSONArray.put(0, (Object)tab.getURL());
                contentValues.put("history", jSONArray.toString());
            }
            catch (JSONException jSONException) {
                Log.w((String)LOGTAG, (String)"JSONException adding URL to tab history array.", (Throwable)jSONException);
            }
            contentValues.put("position", Integer.valueOf(n++));
            contentValues.putNull("client_guid");
            arrayList.add(contentValues);
        }
        ContentValues[] contentValuesArray = arrayList.toArray(new ContentValues[arrayList.size()]);
        contentResolver.bulkInsert(this.tabsUriWithProfile, contentValuesArray);
    }

    @Override
    public synchronized void persistLocalTabs(ContentResolver contentResolver, Iterable<Tab> iterable) {
        this.deleteLocalTabs(contentResolver);
        this.insertLocalTabs(contentResolver, iterable);
        this.updateLocalClient(contentResolver);
    }

    private boolean isFilteredURL(String string2) {
        return FILTERED_URL_PATTERN.matcher(string2).lookingAt();
    }
}

