/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.Intent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractUpdateCredentialsActivity;
import org.mozilla.gecko.fxa.login.State;

public class FxAccountUpdateCredentialsActivity
extends FxAccountAbstractUpdateCredentialsActivity {
    protected static final String LOG_TAG = FxAccountUpdateCredentialsActivity.class.getSimpleName();

    public FxAccountUpdateCredentialsActivity() {
        super(R.layout.fxaccount_update_credentials);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.fxAccount = this.getAndroidFxAccount();
        if (this.fxAccount == null) {
            Logger.warn(LOG_TAG, "Could not get Firefox Account.");
            this.setResult(0);
            this.finish();
            return;
        }
        State state = this.fxAccount.getState();
        if (state.getStateLabel() != State.StateLabel.Separated) {
            Logger.warn(LOG_TAG, "Cannot update credentials from Firefox Account in state: " + (Object)((Object)state.getStateLabel()));
            this.setResult(0);
            this.finish();
            return;
        }
        this.emailEdit.setText((CharSequence)this.fxAccount.getEmail());
    }

    @Override
    public Intent makeSuccessIntent(String string2, FxAccountClient20.LoginResponse loginResponse) {
        return null;
    }
}

