/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.PanelLayout;
import org.mozilla.gecko.home.PanelRecyclerViewAdapter;
import org.mozilla.gecko.home.PanelViewItemHandler;
import org.mozilla.gecko.home.RecyclerViewItemClickListener;
import org.mozilla.gecko.home.SpacingDecoration;

@SuppressLint(value={"ViewConstructor"})
public class PanelRecyclerView
extends RecyclerView
implements PanelLayout.DatasetBacked,
PanelLayout.PanelView,
RecyclerViewItemClickListener.OnClickListener {
    private final PanelRecyclerViewAdapter adapter;
    private final GridLayoutManager layoutManager;
    private final PanelViewItemHandler itemHandler;
    private final float columnWidth;
    private final boolean autoFit;
    private final HomeConfig.ViewConfig viewConfig;
    private PanelLayout.OnItemOpenListener itemOpenListener;
    private HomeContextMenuInfo contextMenuInfo;
    private HomeContextMenuInfo.Factory contextMenuInfoFactory;

    public PanelRecyclerView(Context context, HomeConfig.ViewConfig viewConfig) {
        super(context);
        int n;
        this.viewConfig = viewConfig;
        Resources resources = context.getResources();
        if (viewConfig.getItemType() == HomeConfig.ItemType.ICON) {
            this.autoFit = false;
            n = this.getResources().getInteger(R.integer.panel_icon_grid_view_columns);
        } else {
            this.autoFit = true;
            n = 1;
        }
        this.columnWidth = resources.getDimension(R.dimen.panel_grid_view_column_width);
        this.layoutManager = new GridLayoutManager(context, n);
        this.adapter = new PanelRecyclerViewAdapter(context, viewConfig);
        this.itemHandler = new PanelViewItemHandler();
        this.layoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)new PanelSpanSizeLookup());
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.setAdapter(this.adapter);
        int n2 = (int)resources.getDimension(R.dimen.panel_grid_view_horizontal_spacing);
        int n3 = (int)resources.getDimension(R.dimen.panel_grid_view_vertical_spacing);
        int n4 = (int)resources.getDimension(R.dimen.panel_grid_view_outer_spacing);
        this.addItemDecoration(new SpacingDecoration(n2, n3));
        this.setPadding(n4, n4, n4, n4);
        this.setClipToPadding(false);
        this.addOnItemTouchListener(new RecyclerViewItemClickListener(context, this, this));
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.autoFit) {
            int n3 = (int)Math.max(1.0f, (float)this.getMeasuredWidth() / this.columnWidth);
            this.layoutManager.setSpanCount(n3);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.itemHandler.setOnItemOpenListener(this.itemOpenListener);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.itemHandler.setOnItemOpenListener(null);
    }

    @Override
    public void setDataset(Cursor cursor) {
        this.adapter.swapCursor(cursor);
    }

    @Override
    public void setFilterManager(PanelLayout.FilterManager filterManager) {
        this.adapter.setFilterManager(filterManager);
        this.itemHandler.setFilterManager(filterManager);
    }

    @Override
    public void setOnItemOpenListener(PanelLayout.OnItemOpenListener onItemOpenListener) {
        this.itemOpenListener = onItemOpenListener;
        this.itemHandler.setOnItemOpenListener(onItemOpenListener);
    }

    public HomeContextMenuInfo getContextMenuInfo() {
        return this.contextMenuInfo;
    }

    @Override
    public void setContextMenuInfoFactory(HomeContextMenuInfo.Factory factory) {
        this.contextMenuInfoFactory = factory;
    }

    @Override
    public void onClick(View view, int n) {
        if (this.viewConfig.hasHeaderConfig()) {
            if (n == 0) {
                this.itemOpenListener.onItemOpen(this.viewConfig.getHeaderConfig().getUrl(), null);
                return;
            }
            --n;
        }
        this.itemHandler.openItemAtPosition(this.adapter.getCursor(), n);
    }

    @Override
    public void onLongClick(View view, int n) {
        Cursor cursor = this.adapter.getCursor();
        cursor.moveToPosition(n);
        this.contextMenuInfo = this.contextMenuInfoFactory.makeInfoForCursor(view, n, -1L, cursor);
        this.showContextMenuForChild((View)this);
    }

    private class PanelSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        private PanelSpanSizeLookup() {
        }

        public int getSpanSize(int n) {
            if (n == 0 && PanelRecyclerView.this.viewConfig.hasHeaderConfig()) {
                return PanelRecyclerView.this.layoutManager.getSpanCount();
            }
            return 1;
        }
    }
}

