/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

public class RecyclerViewItemClickListener
implements RecyclerView.OnItemTouchListener,
GestureDetector.OnGestureListener {
    private final OnClickListener clickListener;
    private final GestureDetector gestureDetector;
    private final RecyclerView recyclerView;

    public RecyclerViewItemClickListener(Context context, RecyclerView recyclerView, OnClickListener onClickListener) {
        this.clickListener = onClickListener;
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.recyclerView = recyclerView;
    }

    public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
        return this.gestureDetector.onTouchEvent(motionEvent);
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        View view = this.recyclerView.findChildViewUnder(motionEvent.getX(), motionEvent.getY());
        if (view != null) {
            int n = this.recyclerView.getChildAdapterPosition(view);
            this.clickListener.onClick(view, n);
        }
        return true;
    }

    public void onLongPress(MotionEvent motionEvent) {
        View view = this.recyclerView.findChildViewUnder(motionEvent.getX(), motionEvent.getY());
        if (view != null) {
            int n = this.recyclerView.getChildAdapterPosition(view);
            view.performHapticFeedback(0);
            this.clickListener.onLongClick(view, n);
        }
    }

    public boolean onDown(MotionEvent motionEvent) {
        return false;
    }

    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        return false;
    }

    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        return false;
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public void onTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean bl) {
    }

    public static interface OnClickListener {
        public void onClick(View var1, int var2);

        public void onLongClick(View var1, int var2);
    }
}

