/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.widget.TwoWayView;

public class SearchEngineBar
extends TwoWayView
implements AdapterView.OnItemClickListener {
    private static final String LOGTAG = "Gecko" + SearchEngineBar.class.getSimpleName();
    private static final float ICON_CONTAINER_MIN_WIDTH_DP = 72.0f;
    private static final float LABEL_CONTAINER_WIDTH_DP = 48.0f;
    private static final float DIVIDER_HEIGHT_DP = 1.0f;
    private final SearchEngineAdapter adapter;
    private final Paint dividerPaint = new Paint();
    private final float minIconContainerWidth;
    private final float dividerHeight;
    private final int labelContainerWidth;
    private int iconContainerWidth;
    private OnSearchBarClickListener onSearchBarClickListener;

    public SearchEngineBar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.dividerPaint.setColor(this.getResources().getColor(R.color.divider_light));
        this.dividerPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.minIconContainerWidth = TypedValue.applyDimension((int)1, (float)72.0f, (DisplayMetrics)displayMetrics);
        this.dividerHeight = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)displayMetrics);
        this.labelContainerWidth = (int)TypedValue.applyDimension((int)1, (float)48.0f, (DisplayMetrics)displayMetrics);
        this.iconContainerWidth = (int)this.minIconContainerWidth;
        this.adapter = new SearchEngineAdapter();
        this.setAdapter((ListAdapter)this.adapter);
        this.setOnItemClickListener(this);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        if (this.onSearchBarClickListener == null) {
            throw new IllegalStateException(OnSearchBarClickListener.class.getSimpleName() + " is not initialized");
        }
        if (n == 0) {
            return;
        }
        SearchEngine searchEngine = this.adapter.getItem(n);
        this.onSearchBarClickListener.onSearchBarClickListener(searchEngine);
    }

    protected void setOnSearchBarClickListener(OnSearchBarClickListener onSearchBarClickListener) {
        this.onSearchBarClickListener = onSearchBarClickListener;
    }

    protected void setSearchEngines(List<SearchEngine> list) {
        this.adapter.setSearchEngines(list);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        double d;
        int n3;
        int n4;
        super.onMeasure(n, n2);
        int n5 = this.adapter.getCount() - 1;
        if (n5 > 0 && (n4 = (int)((double)n3 / (d = (float)n5 * this.minIconContainerWidth <= (float)(n3 = this.getMeasuredWidth() - this.labelContainerWidth) ? (double)n5 : Math.floor((float)n3 / this.minIconContainerWidth) - 0.5))) != this.iconContainerWidth) {
            this.iconContainerWidth = n4;
            this.adapter.notifyDataSetChanged();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), this.dividerHeight, this.dividerPaint);
    }

    public class SearchEngineAdapter
    extends BaseAdapter {
        private static final int VIEW_TYPE_SEARCH_ENGINE = 0;
        private static final int VIEW_TYPE_LABEL = 1;
        List<SearchEngine> searchEngines = new ArrayList<SearchEngine>();

        public void setSearchEngines(List<SearchEngine> list) {
            this.searchEngines = list;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.searchEngines.size() + 1;
        }

        public SearchEngine getItem(int n) {
            return n == 0 ? null : this.searchEngines.get(n - 1);
        }

        public long getItemId(int n) {
            return n;
        }

        public int getItemViewType(int n) {
            return n == 0 ? 1 : 0;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            if (n == 0) {
                return this.getLabelView(view, viewGroup);
            }
            return this.getSearchEngineView(n, view, viewGroup);
        }

        private View getLabelView(View view, ViewGroup viewGroup) {
            if (view == null) {
                view = LayoutInflater.from((Context)SearchEngineBar.this.getContext()).inflate(R.layout.search_engine_bar_label, viewGroup, false);
            }
            Drawable drawable2 = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)viewGroup.getContext(), (int)R.drawable.search_icon_active).mutate());
            DrawableCompat.setTint((Drawable)drawable2, (int)SearchEngineBar.this.getResources().getColor(R.color.disabled_grey));
            ImageView imageView = (ImageView)view.findViewById(R.id.search_engine_label);
            imageView.setImageDrawable(drawable2);
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            return view;
        }

        private View getSearchEngineView(int n, View view, ViewGroup viewGroup) {
            if (view == null) {
                view = LayoutInflater.from((Context)SearchEngineBar.this.getContext()).inflate(R.layout.search_engine_bar_item, viewGroup, false);
            }
            TwoWayView.LayoutParams layoutParams = (TwoWayView.LayoutParams)view.getLayoutParams();
            layoutParams.width = SearchEngineBar.this.iconContainerWidth;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ImageView imageView = (ImageView)view.findViewById(R.id.search_engine_icon);
            SearchEngine searchEngine = this.getItem(n);
            imageView.setImageBitmap(searchEngine.getIcon());
            String string2 = SearchEngineBar.this.getResources().getString(R.string.search_bar_item_desc, new Object[]{searchEngine.getEngineIdentifier()});
            view.setContentDescription((CharSequence)string2);
            return view;
        }
    }

    public static interface OnSearchBarClickListener {
        public void onSearchBarClickListener(SearchEngine var1);
    }
}

