/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mdns;

import android.annotation.TargetApi;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.mdns.NsdMulticastDNSManager;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.NativeJSObject;

@TargetApi(value=16)
class DiscoveryListener
implements NsdManager.DiscoveryListener {
    private static final String LOGTAG = "GeckoMDNSManager";
    private final NsdManager nsdManager;
    private EventCallback mStartCallback = null;
    private EventCallback mStopCallback = null;

    DiscoveryListener(NsdManager nsdManager) {
        this.nsdManager = nsdManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverServices(String string2, EventCallback eventCallback) {
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            if (this.mStartCallback != null) {
                throw new RuntimeException("Previous operation is not finished");
            }
            this.mStartCallback = eventCallback;
        }
        this.nsdManager.discoverServices(string2, 1, (NsdManager.DiscoveryListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceDiscovery(EventCallback eventCallback) {
        DiscoveryListener discoveryListener = this;
        synchronized (discoveryListener) {
            if (this.mStopCallback != null) {
                throw new RuntimeException("Previous operation is not finished");
            }
            this.mStopCallback = eventCallback;
        }
        this.nsdManager.stopServiceDiscovery((NsdManager.DiscoveryListener)this);
    }

    public synchronized void onDiscoveryStarted(String string2) {
        Log.d((String)LOGTAG, (String)("onDiscoveryStarted: " + string2));
        if (this.mStartCallback == null) {
            return;
        }
        this.mStartCallback.sendSuccess((Object)string2);
        this.mStartCallback = null;
    }

    public synchronized void onStartDiscoveryFailed(String string2, int n) {
        Log.e((String)LOGTAG, (String)("onStartDiscoveryFailed: " + string2 + "(" + n + ")"));
        if (this.mStartCallback == null) {
            return;
        }
        this.mStartCallback.sendError((Object)n);
        this.mStartCallback = null;
    }

    public synchronized void onDiscoveryStopped(String string2) {
        Log.d((String)LOGTAG, (String)("onDiscoveryStopped: " + string2));
        if (this.mStopCallback == null) {
            return;
        }
        this.mStopCallback.sendSuccess((Object)string2);
        this.mStopCallback = null;
    }

    public synchronized void onStopDiscoveryFailed(String string2, int n) {
        Log.e((String)LOGTAG, (String)("onStopDiscoveryFailed: " + string2 + "(" + n + ")"));
        if (this.mStopCallback == null) {
            return;
        }
        this.mStopCallback.sendError((Object)n);
        this.mStopCallback = null;
    }

    public void onServiceFound(NsdServiceInfo nsdServiceInfo) {
        Log.d((String)LOGTAG, (String)("onServiceFound: " + nsdServiceInfo.getServiceName()));
        JSONObject jSONObject = null;
        try {
            jSONObject = NsdMulticastDNSManager.toJSON(nsdServiceInfo);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        GeckoAppShell.sendRequestToGecko(new GeckoRequest("NsdManager:ServiceFound", jSONObject){

            public void onResponse(NativeJSObject nativeJSObject) {
            }
        });
    }

    public void onServiceLost(NsdServiceInfo nsdServiceInfo) {
        Log.d((String)LOGTAG, (String)("onServiceLost: " + nsdServiceInfo.getServiceName()));
        JSONObject jSONObject = null;
        try {
            jSONObject = NsdMulticastDNSManager.toJSON(nsdServiceInfo);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        GeckoAppShell.sendRequestToGecko(new GeckoRequest("NsdManager:ServiceLost", jSONObject){

            public void onResponse(NativeJSObject nativeJSObject) {
            }
        });
    }
}

