/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mdns;

import android.annotation.TargetApi;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.util.Log;
import org.json.JSONException;
import org.mozilla.gecko.mdns.NsdMulticastDNSManager;
import org.mozilla.gecko.util.EventCallback;

@TargetApi(value=16)
class ResolveListener
implements NsdManager.ResolveListener {
    private static final String LOGTAG = "GeckoMDNSManager";
    private final NsdManager nsdManager;
    private EventCallback mCallback = null;

    public ResolveListener(NsdManager nsdManager) {
        this.nsdManager = nsdManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveService(String string2, String string3, EventCallback eventCallback) {
        ResolveListener resolveListener = this;
        synchronized (resolveListener) {
            if (this.mCallback != null) {
                throw new RuntimeException("Previous operation is not finished");
            }
            this.mCallback = eventCallback;
        }
        resolveListener = new NsdServiceInfo();
        resolveListener.setServiceName(string2);
        resolveListener.setServiceType(string3);
        this.nsdManager.resolveService((NsdServiceInfo)resolveListener, (NsdManager.ResolveListener)this);
    }

    public synchronized void onResolveFailed(NsdServiceInfo nsdServiceInfo, int n) {
        Log.e((String)LOGTAG, (String)("onResolveFailed: " + nsdServiceInfo.getServiceName() + "(" + n + ")"));
        if (this.mCallback == null) {
            return;
        }
        this.mCallback.sendError((Object)n);
        this.mCallback = null;
    }

    public synchronized void onServiceResolved(NsdServiceInfo nsdServiceInfo) {
        Log.d((String)LOGTAG, (String)("onServiceResolved: " + nsdServiceInfo.getServiceName()));
        if (this.mCallback == null) {
            return;
        }
        try {
            this.mCallback.sendSuccess((Object)NsdMulticastDNSManager.toJSON(nsdServiceInfo));
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        this.mCallback = null;
    }
}

