/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.overlays.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.Arrays;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.Assert;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.overlays.ui.SendTabDeviceListArrayAdapter;
import org.mozilla.gecko.overlays.ui.SendTabTargetSelectedListener;

public class SendTabList
extends ListView {
    private static final String LOGTAG = "GeckoSendTabList";
    public static final int MAXIMUM_INLINE_ELEMENTS = R.integer.number_of_inline_share_devices;
    private SendTabDeviceListArrayAdapter clientListAdapter;
    private SendTabTargetSelectedListener listener;
    private final State currentState = State.LOADING;

    public SendTabList(Context context) {
        super(context);
    }

    public SendTabList(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void setAdapter(ListAdapter listAdapter) {
        Assert.isTrue(listAdapter instanceof SendTabDeviceListArrayAdapter);
        this.clientListAdapter = (SendTabDeviceListArrayAdapter)listAdapter;
        super.setAdapter(listAdapter);
    }

    public void setSendTabTargetSelectedListener(SendTabTargetSelectedListener sendTabTargetSelectedListener) {
        this.listener = sendTabTargetSelectedListener;
    }

    public void switchState(State state) {
        if (state == this.currentState) {
            return;
        }
        this.clientListAdapter.switchState(state);
        if (state == State.SHOW_DEVICES) {
            this.clientListAdapter.setDialog(this.getDialog());
        }
    }

    public void setSyncClients(RemoteClient[] remoteClientArray) {
        RemoteClient[] remoteClientArray2 = remoteClientArray == null ? new RemoteClient[]{} : remoteClientArray;
        this.clientListAdapter.setRemoteClientsList(Arrays.asList(remoteClientArray2));
    }

    public AlertDialog getDialog() {
        Context context = this.getContext();
        AlertDialog.Builder builder = AppConstants.Versions.feature11Plus ? new AlertDialog.Builder(context, R.style.Gecko_Dialog) : new AlertDialog.Builder(context);
        final RemoteClient[] remoteClientArray = this.clientListAdapter.toArray();
        CharSequence[] charSequenceArray = new String[remoteClientArray.length];
        for (int i = 0; i < remoteClientArray.length; ++i) {
            charSequenceArray[i] = remoteClientArray[i].name;
        }
        builder.setTitle(R.string.overlay_share_select_device).setItems(charSequenceArray, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                SendTabList.this.listener.onSendTabTargetSelected(remoteClientArray[n].guid);
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                Telemetry.sendUIEvent(TelemetryContract.Event.CANCEL, TelemetryContract.Method.SHARE_OVERLAY, "device_selection_cancel");
            }
        });
        return builder.create();
    }

    public static enum State {
        NONE,
        LOADING,
        LIST,
        SHOW_DEVICES;

    }
}

