/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.tabs.TabStripView;
import org.mozilla.gecko.widget.ThemedImageButton;
import org.mozilla.gecko.widget.ThemedLinearLayout;

public class TabStrip
extends ThemedLinearLayout
implements BrowserApp.Refreshable {
    private static final String LOGTAG = "GeckoTabStrip";
    private final TabStripView tabStripView;
    private final ThemedImageButton addTabButton;
    private final TabsListener tabsListener;

    public TabStrip(Context context) {
        this(context, null);
    }

    public TabStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        LayoutInflater.from((Context)context).inflate(R.layout.tab_strip, (ViewGroup)this);
        this.tabStripView = (TabStripView)this.findViewById(R.id.tab_strip);
        this.addTabButton = (ThemedImageButton)this.findViewById(R.id.add_tab);
        this.addTabButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs tabs = Tabs.getInstance();
                if (TabStrip.this.isPrivateMode()) {
                    tabs.addPrivateTab();
                } else {
                    tabs.addTab();
                }
            }
        });
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                TabStrip.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                Rect rect = new Rect();
                rect.left = TabStrip.this.addTabButton.getRight();
                rect.right = TabStrip.this.getWidth();
                rect.top = 0;
                rect.bottom = TabStrip.this.getHeight();
                TabStrip.this.setTouchDelegate(new TouchDelegate(rect, (View)TabStrip.this.addTabButton));
                return true;
            }
        });
        this.tabsListener = new TabsListener();
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Tabs.registerOnTabsChangedListener(this.tabsListener);
        this.tabStripView.refreshTabs();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Tabs.unregisterOnTabsChangedListener(this.tabsListener);
        this.tabStripView.clearTabs();
    }

    @Override
    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.addTabButton.setPrivateMode(bl);
    }

    @Override
    public void refresh() {
        this.tabStripView.refresh();
    }

    @Override
    public void onLightweightThemeChanged() {
        Drawable drawable2 = this.getTheme().getDrawable((View)this);
        if (drawable2 == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.text_and_tabs_tray_grey));
        stateListDrawable.addState(EMPTY_STATE_SET, drawable2);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        int n = this.getResources().getColor(R.color.text_and_tabs_tray_grey);
        this.setBackgroundColor(n);
    }

    private class TabsListener
    implements Tabs.OnTabsChangedListener {
        private TabsListener() {
        }

        @Override
        public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
            switch (tabEvents) {
                case RESTORED: {
                    TabStrip.this.tabStripView.restoreTabs();
                    break;
                }
                case ADDED: {
                    TabStrip.this.tabStripView.addTab(tab);
                    break;
                }
                case CLOSED: {
                    TabStrip.this.tabStripView.removeTab(tab);
                    break;
                }
                case SELECTED: {
                    TabStrip.this.tabStripView.selectTab(tab);
                    TabStrip.this.setPrivateMode(tab.isPrivate());
                }
                case UNSELECTED: 
                case TITLE: 
                case FAVICON: 
                case RECORDING_CHANGE: {
                    TabStrip.this.tabStripView.updateTab(tab);
                }
            }
        }
    }
}

