/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.UUID;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final String LOGTAG = "GeckoCrashHandler";
    private static final Thread MAIN_THREAD = Thread.currentThread();
    private static final String DEFAULT_SERVER_URL = "https://crash-reports.mozilla.com/submit?id=%1$s&version=%2$s&buildid=%3$s";
    protected final Context appContext;
    protected final Thread handlerThread;
    protected final Thread.UncaughtExceptionHandler systemUncaughtHandler;
    protected boolean crashing;
    protected boolean unregistered;

    public static Throwable getRootException(Throwable throwable) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            throwable = throwable2;
        }
        return throwable;
    }

    public static String getExceptionStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public static void terminateProcess() {
        Process.killProcess((int)Process.myPid());
    }

    public CrashHandler() {
        this((Context)null);
    }

    public CrashHandler(Context context) {
        this.appContext = context;
        this.handlerThread = null;
        this.systemUncaughtHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public CrashHandler(Thread thread) {
        this(thread, null);
    }

    public CrashHandler(Thread thread, Context context) {
        this.appContext = context;
        this.handlerThread = thread;
        this.systemUncaughtHandler = thread.getUncaughtExceptionHandler();
        thread.setUncaughtExceptionHandler(this);
    }

    public void unregister() {
        this.unregistered = true;
        if (this.handlerThread != null) {
            if (this.handlerThread.getUncaughtExceptionHandler() == this) {
                this.handlerThread.setUncaughtExceptionHandler(this.systemUncaughtHandler);
            }
        } else if (Thread.getDefaultUncaughtExceptionHandler() == this) {
            Thread.setDefaultUncaughtExceptionHandler(this.systemUncaughtHandler);
        }
    }

    protected void logException(Thread thread, Throwable throwable) {
        try {
            Log.e((String)LOGTAG, (String)(">>> REPORTING UNCAUGHT EXCEPTION FROM THREAD " + thread.getId() + " (\"" + thread.getName() + "\")"), (Throwable)throwable);
            if (MAIN_THREAD != thread) {
                Log.e((String)LOGTAG, (String)("Main thread (" + MAIN_THREAD.getId() + ") stack:"));
                for (StackTraceElement stackTraceElement : MAIN_THREAD.getStackTrace()) {
                    Log.e((String)LOGTAG, (String)("    " + stackTraceElement.toString()));
                }
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private static long getCrashTime() {
        return System.currentTimeMillis() / 1000L;
    }

    private static long getStartupTime() {
        long l = new File("/proc/self/cmdline").lastModified();
        if (l == 0L) {
            return CrashHandler.getCrashTime();
        }
        return l / 1000L;
    }

    private static String getJavaPackageName() {
        return CrashHandler.class.getPackage().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getAppPackageName() {
        Context context = this.getAppContext();
        if (context != null) {
            return context.getPackageName();
        }
        try {
            char[] cArray = new char[64];
            try (FileReader fileReader = new FileReader("/proc/self/cmdline");){
                if (fileReader.read(cArray) <= 0) return CrashHandler.getJavaPackageName();
                int n = Arrays.asList(new char[][]{cArray}).indexOf(Character.valueOf('\u0000'));
                String string2 = new String(cArray, 0, n < 0 ? cArray.length : n).trim();
                return string2;
            }
        }
        catch (IOException iOException) {
            Log.i((String)LOGTAG, (String)"Error reading package name", (Throwable)iOException);
        }
        return CrashHandler.getJavaPackageName();
    }

    protected Context getAppContext() {
        return this.appContext;
    }

    protected Bundle getCrashExtras(Thread thread, Throwable throwable) {
        Context context = this.getAppContext();
        Bundle bundle = new Bundle();
        String string2 = this.getAppPackageName();
        bundle.putString("ProductName", string2);
        bundle.putLong("CrashTime", CrashHandler.getCrashTime());
        bundle.putLong("StartupTime", CrashHandler.getStartupTime());
        if (context != null) {
            PackageManager packageManager = context.getPackageManager();
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(string2, 0);
                bundle.putString("Version", packageInfo.versionName);
                bundle.putInt("BuildID", packageInfo.versionCode);
                bundle.putLong("InstallTime", packageInfo.lastUpdateTime / 1000L);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.i((String)LOGTAG, (String)"Error getting package info", (Throwable)nameNotFoundException);
            }
        }
        bundle.putString("JavaStackTrace", CrashHandler.getExceptionStackTrace(throwable));
        return bundle;
    }

    protected byte[] getCrashDump(Thread thread, Throwable throwable) {
        return new byte[0];
    }

    protected static String normalizeUrlString(String string2) {
        if (string2 == null) {
            return "";
        }
        return Uri.encode((String)string2);
    }

    protected String getServerUrl(Bundle bundle) {
        return String.format(DEFAULT_SERVER_URL, CrashHandler.normalizeUrlString(bundle.getString("ProductID")), CrashHandler.normalizeUrlString(bundle.getString("Version")), CrashHandler.normalizeUrlString(bundle.getString("BuildID")));
    }

    protected boolean launchCrashReporter(String string2, String string3) {
        try {
            Context context = this.getAppContext();
            String string4 = CrashHandler.getJavaPackageName();
            String string5 = this.getAppPackageName();
            String string6 = string4 + ".CrashReporter";
            String string7 = string4 + ".reportCrash";
            if (context != null) {
                Intent intent = new Intent(string7);
                intent.setComponent(new ComponentName(string5, string6));
                intent.putExtra("minidumpPath", string2);
                context.startActivity(intent);
                return true;
            }
            ProcessBuilder processBuilder = Build.VERSION.SDK_INT < 17 ? new ProcessBuilder("/system/bin/am", "start", "-a", string7, "-n", string5 + '/' + string6, "--es", "minidumpPath", string2) : new ProcessBuilder("/system/bin/am", "start", "--user", "-3", "-a", string7, "-n", string5 + '/' + string6, "--es", "minidumpPath", string2);
            processBuilder.start().waitFor();
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error launching crash reporter", (Throwable)iOException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            Log.i((String)LOGTAG, (String)"Interrupted while waiting to launch crash reporter", (Throwable)interruptedException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reportException(Thread thread, Throwable throwable) {
        Object object;
        Object object2;
        Context context = this.getAppContext();
        String string2 = UUID.randomUUID().toString();
        File file = context != null ? context.getCacheDir() : new File("/data/data/" + this.getAppPackageName() + "/cache");
        file.mkdirs();
        if (!file.exists()) {
            return false;
        }
        File file2 = new File(file, string2 + ".dmp");
        File file3 = new File(file, string2 + ".extra");
        try {
            object2 = this.getCrashDump(thread, throwable);
            object = new FileOutputStream(file2);
            try {
                ((FileOutputStream)object).write((byte[])object2);
            }
            finally {
                ((FileOutputStream)object).close();
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error writing minidump file", (Throwable)iOException);
            return false;
        }
        try {
            object2 = this.getCrashExtras(thread, throwable);
            object = this.getServerUrl((Bundle)object2);
            object2.putString("ServerURL", (String)object);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));){
                for (String string3 : object2.keySet()) {
                    bufferedWriter.write(string3);
                    bufferedWriter.write(61);
                    bufferedWriter.write(String.valueOf(object2.get(string3)).replace("\n", "\\n"));
                    bufferedWriter.write(10);
                }
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error writing extra file", (Throwable)iOException);
            return false;
        }
        return this.launchCrashReporter(file2.getAbsolutePath(), file3.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.crashing) {
            return;
        }
        if (thread == null) {
            thread = Thread.currentThread();
        }
        try {
            if (!this.unregistered) {
                this.crashing = true;
                throwable = CrashHandler.getRootException(throwable);
                this.logException(thread, throwable);
                if (this.reportException(thread, throwable)) {
                    return;
                }
            }
            if (this.systemUncaughtHandler != null) {
                this.systemUncaughtHandler.uncaughtException(thread, throwable);
            }
        }
        finally {
            CrashHandler.terminateProcess();
        }
    }

    public static CrashHandler createDefaultCrashHandler(Context context) {
        return new CrashHandler(context){

            @Override
            protected Bundle getCrashExtras(Thread thread, Throwable throwable) {
                Bundle bundle = super.getCrashExtras(thread, throwable);
                bundle.putString("ProductName", "Fennec");
                bundle.putString("ProductID", "{aa3c5121-dab2-40e2-81ca-7ea25febc110}");
                bundle.putString("Version", "42.0a1");
                bundle.putString("BuildID", "20150730030208");
                bundle.putString("Vendor", "Mozilla");
                bundle.putString("ReleaseChannel", "nightly");
                return bundle;
            }

            @Override
            public boolean reportException(Thread thread, Throwable throwable) {
                return super.reportException(thread, throwable);
            }
        };
    }
}

