/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import java.io.IOException;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoJavaSampler;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoThread
extends Thread
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoThread";
    private static final AtomicReference<LaunchState> sLaunchState = new AtomicReference<LaunchState>(LaunchState.Launching);
    private static final Queue<GeckoEvent> PENDING_EVENTS = new ConcurrentLinkedQueue<GeckoEvent>();
    private static GeckoThread sGeckoThread;
    private final String mArgs;
    private final String mAction;
    private final String mUri;
    private final boolean mDebugging;

    GeckoThread(String string2, String string3, String string4, boolean bl) {
        this.mArgs = string2;
        this.mAction = string3;
        this.mUri = string4;
        this.mDebugging = bl;
        this.setName("Gecko");
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Gecko:Ready");
    }

    public static boolean ensureInit(String string2, String string3, String string4) {
        return GeckoThread.ensureInit(string2, string3, string4, false);
    }

    public static boolean ensureInit(String string2, String string3, String string4, boolean bl) {
        ThreadUtils.assertOnUiThread();
        if (GeckoThread.checkLaunchState(LaunchState.Launching) && sGeckoThread == null) {
            sGeckoThread = new GeckoThread(string2, string3, string4, bl);
            return true;
        }
        return false;
    }

    public static boolean launch() {
        ThreadUtils.assertOnUiThread();
        if (GeckoThread.checkAndSetLaunchState(LaunchState.Launching, LaunchState.Launched)) {
            sGeckoThread.start();
            return true;
        }
        return false;
    }

    public static boolean isLaunched() {
        return !GeckoThread.checkLaunchState(LaunchState.Launching);
    }

    private String initGeckoEnvironment() {
        String[] stringArray;
        Object object;
        Locale locale = Locale.getDefault();
        Context context = GeckoAppShell.getContext();
        GeckoLoader.loadMozGlue((Context)context);
        Resources resources = context.getResources();
        if (locale.toString().equalsIgnoreCase("zh_hk")) {
            object = Locale.TRADITIONAL_CHINESE;
            Locale.setDefault((Locale)object);
            stringArray = resources.getConfiguration();
            stringArray.locale = object;
            resources.updateConfiguration((Configuration)stringArray, null);
        }
        object = "";
        stringArray = null;
        try {
            stringArray = GeckoAppShell.getPluginDirectories();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Caught exception getting plugin dirs.", (Throwable)exception);
        }
        object = context.getPackageResourcePath();
        GeckoLoader.setupGeckoEnvironment((Context)context, (String[])stringArray, (String)context.getFilesDir().getPath());
        GeckoLoader.loadSQLiteLibs((Context)context, (String)object);
        GeckoLoader.loadNSSLibs((Context)context, (String)object);
        GeckoLoader.loadGeckoLibs((Context)context, (String)object);
        GeckoJavaSampler.setLibsLoaded();
        return object;
    }

    private String getTypeFromAction(String string2) {
        if ("org.mozilla.gecko.BOOKMARK".equals(string2)) {
            return "-bookmark";
        }
        return null;
    }

    private String addCustomProfileArg(String string2) {
        String string3 = "";
        String string4 = "";
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoProfile geckoProfile = GeckoAppShell.getGeckoInterface().getProfile();
            if (geckoProfile.inGuestMode()) {
                try {
                    string3 = " -profile " + geckoProfile.getDir().getCanonicalPath();
                }
                catch (IOException iOException) {
                    Log.e((String)LOGTAG, (String)"error getting guest profile path", (Throwable)iOException);
                }
                if (string2 == null || !string2.contains("--guest")) {
                    string4 = " --guest";
                }
            } else if (!GeckoProfile.sIsUsingCustomProfile) {
                string3 = " -P " + geckoProfile.forceCreate().getName();
            }
        }
        return (string2 != null ? string2 : "") + string3 + string4;
    }

    @Override
    public void run() {
        Looper.prepare();
        ThreadUtils.sGeckoThread = this;
        ThreadUtils.sGeckoHandler = new Handler();
        if (this.mDebugging) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String string2 = this.initGeckoEnvironment();
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoAppShell.registerJavaUiThread();
            }
        });
        Log.w((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - runGecko"));
        String string3 = this.addCustomProfileArg(this.mArgs);
        String string4 = this.getTypeFromAction(this.mAction);
        GeckoAppShell.runGecko(string2, string3, this.mUri, string4);
        GeckoThread.setLaunchState(LaunchState.GeckoExited);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("type", (Object)"Gecko:Exited");
            EventDispatcher.getInstance().dispatchEvent(jSONObject, null);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"unable to dispatch event", (Throwable)jSONException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPendingEvent(GeckoEvent geckoEvent) {
        Queue<GeckoEvent> queue = PENDING_EVENTS;
        synchronized (queue) {
            if (GeckoThread.checkLaunchState(LaunchState.GeckoRunning)) {
                GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
                geckoEvent.recycle();
            } else {
                PENDING_EVENTS.add(geckoEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(String string2, JSONObject jSONObject) {
        if ("Gecko:Ready".equals(string2)) {
            EventDispatcher.getInstance().unregisterGeckoThreadListener(this, string2);
            Queue<GeckoEvent> queue = PENDING_EVENTS;
            synchronized (queue) {
                GeckoEvent geckoEvent;
                while ((geckoEvent = PENDING_EVENTS.poll()) != null) {
                    GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
                    geckoEvent.recycle();
                }
                GeckoThread.setLaunchState(LaunchState.GeckoRunning);
            }
        }
    }

    @RobocopTarget
    public static boolean checkLaunchState(LaunchState launchState) {
        return sLaunchState.get() == launchState;
    }

    static void setLaunchState(LaunchState launchState) {
        sLaunchState.set(launchState);
    }

    static boolean checkAndSetLaunchState(LaunchState launchState, LaunchState launchState2) {
        return sLaunchState.compareAndSet(launchState, launchState2);
    }

    @RobocopTarget
    public static enum LaunchState {
        Launching,
        Launched,
        GeckoRunning,
        GeckoExiting,
        GeckoExited;

    }
}

