/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.ReadingListAccessor;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public final class ReadingListHelper
implements NativeEventListener {
    private static final String LOGTAG = "GeckoReadingListHelper";
    protected final Context context;
    private final BrowserDB db;
    private final ReadingListAccessor readingListAccessor;
    private final ContentObserver contentObserver;
    private final OnReadingListEventListener onReadingListEventListener;
    volatile boolean fetchInBackground = true;

    public ReadingListHelper(Context context, GeckoProfile geckoProfile, OnReadingListEventListener onReadingListEventListener) {
        this.context = context;
        this.db = geckoProfile.getDB();
        this.readingListAccessor = this.db.getReadingListAccessor();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Reader:AddToList", "Reader:UpdateList", "Reader:FaviconRequest", "Reader:ListStatusRequest", "Reader:RemoveFromList");
        this.contentObserver = new ContentObserver(null){

            public void onChange(boolean bl) {
                if (ReadingListHelper.this.fetchInBackground) {
                    ReadingListHelper.this.fetchContent();
                }
            }
        };
        this.readingListAccessor.registerContentObserver(context, this.contentObserver);
        this.onReadingListEventListener = onReadingListEventListener;
    }

    public void uninit() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Reader:AddToList", "Reader:UpdateList", "Reader:FaviconRequest", "Reader:ListStatusRequest", "Reader:RemoveFromList");
        this.context.getContentResolver().unregisterContentObserver(this.contentObserver);
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        switch (string2) {
            case "Reader:AddToList": {
                this.handleAddToList(eventCallback, nativeJSObject);
                break;
            }
            case "Reader:UpdateList": {
                this.handleUpdateList(nativeJSObject);
                break;
            }
            case "Reader:FaviconRequest": {
                this.handleReaderModeFaviconRequest(eventCallback, nativeJSObject.getString("url"));
                break;
            }
            case "Reader:RemoveFromList": {
                this.handleRemoveFromList(nativeJSObject.getString("url"));
                break;
            }
            case "Reader:ListStatusRequest": {
                this.handleReadingListStatusRequest(eventCallback, nativeJSObject.getString("url"));
            }
        }
    }

    private void handleAddToList(final EventCallback eventCallback, NativeJSObject nativeJSObject) {
        final ContentResolver contentResolver = this.context.getContentResolver();
        final String string2 = nativeJSObject.getString("url");
        final ContentValues contentValues = this.getContentValues(nativeJSObject);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ReadingListHelper.this.readingListAccessor.isReadingListItem(contentResolver, string2)) {
                    ReadingListHelper.this.handleEvent(ReadingListEvent.ALREADY_EXISTS, string2);
                    eventCallback.sendError((Object)("URL already in reading list: " + string2));
                } else {
                    ReadingListHelper.this.readingListAccessor.addReadingListItem(contentResolver, contentValues);
                    ReadingListHelper.this.handleEvent(ReadingListEvent.ADDED, string2);
                    eventCallback.sendSuccess((Object)string2);
                }
            }
        });
    }

    private void handleUpdateList(NativeJSObject nativeJSObject) {
        final ContentResolver contentResolver = this.context.getContentResolver();
        final ContentValues contentValues = this.getContentValues(nativeJSObject);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ReadingListHelper.this.readingListAccessor.updateReadingListItem(contentResolver, contentValues);
            }
        });
    }

    private ContentValues getContentValues(NativeJSObject nativeJSObject) {
        ContentValues contentValues = new ContentValues();
        if (nativeJSObject.has("id")) {
            contentValues.put("_id", Integer.valueOf(nativeJSObject.getInt("id")));
        }
        String string2 = null;
        if (nativeJSObject.has("url")) {
            string2 = nativeJSObject.getString("url");
            contentValues.put("url", string2);
        }
        String string3 = null;
        if (nativeJSObject.has("title")) {
            string3 = nativeJSObject.getString("title");
            contentValues.put("title", string3);
        }
        if (nativeJSObject.has("word_count")) {
            contentValues.put("word_count", Integer.valueOf(nativeJSObject.getInt("word_count")));
        }
        if (nativeJSObject.has("excerpt")) {
            contentValues.put("excerpt", nativeJSObject.getString("excerpt"));
        }
        if (nativeJSObject.has("status")) {
            int n = nativeJSObject.getInt("status");
            contentValues.put("content_status", Integer.valueOf(n));
            if (n == 4) {
                if (nativeJSObject.has("resolved_title")) {
                    contentValues.put("resolved_title", nativeJSObject.getString("resolved_title"));
                } else if (string3 != null) {
                    contentValues.put("resolved_title", string3);
                }
                if (nativeJSObject.has("resolved_url")) {
                    contentValues.put("resolved_url", nativeJSObject.getString("resolved_url"));
                } else if (string2 != null) {
                    contentValues.put("resolved_url", string2);
                }
            }
        }
        return contentValues;
    }

    private void handleReaderModeFaviconRequest(final EventCallback eventCallback, final String string2) {
        new UIAsyncTask.WithoutParams<String>(ThreadUtils.getBackgroundHandler()){

            public String doInBackground() {
                return Favicons.getFaviconURLForPageURL(ReadingListHelper.this.db, ReadingListHelper.this.context.getContentResolver(), string2);
            }

            public void onPostExecute(String string22) {
                JSONObject jSONObject = new JSONObject();
                if (string22 != null) {
                    try {
                        jSONObject.put("url", (Object)string2);
                        jSONObject.put("faviconUrl", (Object)string22);
                    }
                    catch (JSONException jSONException) {
                        Log.w((String)ReadingListHelper.LOGTAG, (String)"Error building JSON favicon arguments.", (Throwable)jSONException);
                    }
                }
                eventCallback.sendSuccess((Object)jSONObject.toString());
            }
        }.execute();
    }

    private void handleRemoveFromList(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ReadingListHelper.this.readingListAccessor.removeReadingListItemWithURL(ReadingListHelper.this.context.getContentResolver(), string2);
                ReadingListHelper.this.handleEvent(ReadingListEvent.REMOVED, string2);
            }
        });
    }

    private void handleReadingListStatusRequest(final EventCallback eventCallback, final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n = ReadingListHelper.this.readingListAccessor.isReadingListItem(ReadingListHelper.this.context.getContentResolver(), string2) ? 1 : 0;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("url", (Object)string2);
                    jSONObject.put("inReadingList", n);
                }
                catch (JSONException jSONException) {
                    Log.e((String)ReadingListHelper.LOGTAG, (String)"JSON error - failed to return inReadingList status", (Throwable)jSONException);
                }
                eventCallback.sendSuccess((Object)jSONObject.toString());
            }
        });
    }

    private void handleEvent(final ReadingListEvent readingListEvent, final String string2) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                switch (readingListEvent) {
                    case ADDED: {
                        ReadingListHelper.this.onReadingListEventListener.onAddedToReadingList(string2);
                        break;
                    }
                    case REMOVED: {
                        ReadingListHelper.this.onReadingListEventListener.onRemovedFromReadingList(string2);
                        break;
                    }
                    case ALREADY_EXISTS: {
                        ReadingListHelper.this.onReadingListEventListener.onAlreadyInReadingList(string2);
                    }
                }
            }
        });
    }

    private void fetchContent() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    Cursor cursor = ReadingListHelper.this.readingListAccessor.getReadingListUnfetched(ReadingListHelper.this.context.getContentResolver());
                    block5: while (true) {
                        while (cursor.moveToNext()) {
                            JSONObject jSONObject = new JSONObject();
                            try {
                                jSONObject.put("id", cursor.getInt(cursor.getColumnIndexOrThrow("_id")));
                                jSONObject.put("url", (Object)cursor.getString(cursor.getColumnIndexOrThrow("url")));
                                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:FetchContent", jSONObject.toString()));
                                continue block5;
                            }
                            catch (JSONException jSONException) {
                                Log.e((String)ReadingListHelper.LOGTAG, (String)"Failed to fetch reading list content for item");
                            }
                        }
                        break block7;
                        {
                            continue block5;
                            break;
                        }
                        break;
                    }
                    finally {
                        cursor.close();
                    }
                }
            }
        });
    }

    @RobocopTarget
    public void disableBackgroundFetches() {
        this.fetchInBackground = false;
    }

    private static enum ReadingListEvent {
        ADDED,
        REMOVED,
        ALREADY_EXISTS;

    }

    public static interface OnReadingListEventListener {
        public void onAddedToReadingList(String var1);

        public void onRemovedFromReadingList(String var1);

        public void onAlreadyInReadingList(String var1);
    }
}

