/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserManager;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;

@RobocopTarget
public class RestrictedProfiles {
    private static final String LOGTAG = "GeckoRestrictedProfiles";
    private static volatile Boolean inGuest = null;
    private static final List<String> BANNED_SCHEMES = new ArrayList<String>(){
        {
            this.add("file");
            this.add("chrome");
            this.add("resource");
            this.add("jar");
            this.add("wyciwyg");
        }
    };
    private static final String ABOUT_ADDONS = "about:addons";
    private static final List<String> BANNED_URLS = new ArrayList<String>(){
        {
            this.add("about:config");
        }
    };
    static List<Restriction> GUEST_RESTRICTIONS = Arrays.asList(Restriction.DISALLOW_DOWNLOADS, Restriction.DISALLOW_INSTALL_EXTENSION, Restriction.DISALLOW_INSTALL_APPS, Restriction.DISALLOW_BROWSE_FILES, Restriction.DISALLOW_SHARE, Restriction.DISALLOW_BOOKMARK, Restriction.DISALLOW_ADD_CONTACTS, Restriction.DISALLOW_SET_IMAGE, Restriction.DISALLOW_MODIFY_ACCOUNTS, Restriction.DISALLOW_REMOTE_DEBUGGING, Restriction.DISALLOW_IMPORT_SETTINGS);
    static List<Restriction> RESTRICTED_PROFILE_RESTRICTIONS = Arrays.asList(Restriction.DISALLOW_INSTALL_EXTENSION, Restriction.DISALLOW_INSTALL_APPS, Restriction.DISALLOW_TOOLS_MENU, Restriction.DISALLOW_REPORT_SITE_ISSUE, Restriction.DISALLOW_IMPORT_SETTINGS);

    public static void initWithProfile(GeckoProfile geckoProfile) {
        inGuest = geckoProfile.inGuestMode();
    }

    private static boolean getInGuest() {
        if (inGuest == null) {
            inGuest = GeckoAppShell.getGeckoInterface().getProfile().inGuestMode();
        }
        return inGuest;
    }

    private static Restriction geckoActionToRestriction(int n) {
        for (Restriction restriction : Restriction.values()) {
            if (restriction.id != n) continue;
            return restriction;
        }
        throw new IllegalArgumentException("Unknown action " + n);
    }

    @TargetApi(value=18)
    private static Bundle getRestrictions(Context context) {
        UserManager userManager = (UserManager)context.getSystemService("user");
        return userManager.getUserRestrictions();
    }

    @TargetApi(value=18)
    private static Bundle getAppRestrictions(Context context) {
        UserManager userManager = (UserManager)context.getSystemService("user");
        return userManager.getApplicationRestrictions(context.getPackageName());
    }

    private static boolean getRestriction(Context context, Restriction restriction) {
        if (AppConstants.Versions.preJBMR2) {
            return false;
        }
        if (!RestrictedProfiles.isUserRestricted(context)) {
            return false;
        }
        return RestrictedProfiles.getAppRestrictions(context).getBoolean(restriction.name, RESTRICTED_PROFILE_RESTRICTIONS.contains((Object)restriction));
    }

    private static boolean canLoadUrl(Context context, String string2) {
        if (string2 == null) {
            return true;
        }
        try {
            if (!RestrictedProfiles.getInGuest() && !RestrictedProfiles.getRestriction(context, Restriction.DISALLOW_BROWSE_FILES)) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.i((String)LOGTAG, (String)"Invalid action", (Throwable)illegalArgumentException);
        }
        Uri uri = Uri.parse((String)string2);
        String string3 = uri.getScheme();
        if (BANNED_SCHEMES.contains(string3)) {
            return false;
        }
        for (String string4 : BANNED_URLS) {
            if (!string2.startsWith(string4)) continue;
            return false;
        }
        return true;
    }

    @WrapElementForJNI
    public static boolean isUserRestricted() {
        return RestrictedProfiles.isUserRestricted(GeckoAppShell.getContext());
    }

    public static boolean isUserRestricted(Context context) {
        if (RestrictedProfiles.getInGuest()) {
            return true;
        }
        if (AppConstants.Versions.preJBMR2) {
            return false;
        }
        Bundle bundle = RestrictedProfiles.getRestrictions(context);
        for (String string2 : bundle.keySet()) {
            if (!bundle.getBoolean(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllowed(Context context, Restriction restriction) {
        return RestrictedProfiles.isAllowed(context, restriction, null);
    }

    @WrapElementForJNI
    public static boolean isAllowed(int n, String string2) {
        return RestrictedProfiles.isAllowed(GeckoAppShell.getContext(), n, string2);
    }

    private static boolean isAllowed(Context context, int n, String string2) {
        Restriction restriction;
        try {
            restriction = RestrictedProfiles.geckoActionToRestriction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)LOGTAG, (String)("Unknown action " + n + "; check calling code."));
            return false;
        }
        return RestrictedProfiles.isAllowed(context, restriction, string2);
    }

    private static boolean isAllowed(Context context, Restriction restriction, String string2) {
        if (RestrictedProfiles.getInGuest()) {
            if (Restriction.DISALLOW_BROWSE_FILES == restriction) {
                return RestrictedProfiles.canLoadUrl(context, string2);
            }
            return !GUEST_RESTRICTIONS.contains((Object)restriction);
        }
        if (restriction == Restriction.DISALLOW_BROWSE_FILES && string2.toLowerCase().startsWith(ABOUT_ADDONS) && !RestrictedProfiles.isAllowed(context, Restriction.DISALLOW_INSTALL_EXTENSION)) {
            return false;
        }
        return !RestrictedProfiles.getRestriction(context, restriction);
    }

    @WrapElementForJNI
    public static String getUserRestrictions() {
        return RestrictedProfiles.getUserRestrictions(GeckoAppShell.getContext());
    }

    private static String getUserRestrictions(Context context) {
        if (RestrictedProfiles.getInGuest()) {
            StringBuilder stringBuilder = new StringBuilder("{ ");
            for (Restriction restriction : Restriction.values()) {
                stringBuilder.append("\"" + restriction.name + "\": true, ");
            }
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
        if (AppConstants.Versions.preJBMR2) {
            return "{}";
        }
        JSONObject jSONObject = new JSONObject();
        Bundle bundle = RestrictedProfiles.getRestrictions(context);
        Set set = bundle.keySet();
        for (String string2 : set) {
            try {
                jSONObject.put(string2, bundle.get(string2));
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject.toString();
    }

    public static enum Restriction {
        DISALLOW_DOWNLOADS(1, "no_download_files", 0, 0),
        DISALLOW_BROWSE_FILES(4, "no_browse_files", 0, 0),
        DISALLOW_SHARE(5, "no_share", 0, 0),
        DISALLOW_BOOKMARK(6, "no_bookmark", 0, 0),
        DISALLOW_ADD_CONTACTS(7, "no_add_contacts", 0, 0),
        DISALLOW_SET_IMAGE(8, "no_set_image", 0, 0),
        DISALLOW_MODIFY_ACCOUNTS(9, "no_modify_accounts", 0, 0),
        DISALLOW_REMOTE_DEBUGGING(10, "no_remote_debugging", 0, 0),
        DISALLOW_INSTALL_EXTENSION(2, "no_install_extensions", R.string.restriction_disallow_addons_title, R.string.restriction_disallow_addons_description),
        DISALLOW_INSTALL_APPS(3, "no_install_apps", R.string.restriction_disallow_apps_title, R.string.restriction_disallow_apps_description),
        DISALLOW_IMPORT_SETTINGS(11, "no_report_site_issue", R.string.restriction_disallow_import_settings_title, R.string.restriction_disallow_import_settings_description),
        DISALLOW_TOOLS_MENU(12, "no_tools_menu", R.string.restriction_disallow_tools_menu_title, R.string.restriction_disallow_tools_menu_description),
        DISALLOW_REPORT_SITE_ISSUE(13, "no_report_site_issue", R.string.restriction_disallow_report_site_issue_title, R.string.restriction_disallow_report_site_issue_description);

        public final int id;
        public final String name;
        public final int titleResource;
        public final int descriptionResource;

        private Restriction(int n2, String string3, int n3, int n4) {
            this.id = n2;
            this.name = string3;
            this.titleResource = n3;
            this.descriptionResource = n4;
        }

        public String getTitle(Context context) {
            if (this.titleResource == 0) {
                return this.toString();
            }
            return context.getResources().getString(this.titleResource);
        }

        public String getDescription(Context context) {
            if (this.descriptionResource == 0) {
                return this.name;
            }
            return context.getResources().getString(this.descriptionResource);
        }
    }
}

