/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa.oauth;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.mozilla.gecko.background.fxa.oauth.FxAccountAbstractClientException;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncResponse;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public abstract class FxAccountAbstractClient {
    protected static final String LOG_TAG = FxAccountAbstractClient.class.getSimpleName();
    protected static final String ACCEPT_HEADER = "application/json;charset=utf-8";
    protected static final String AUTHORIZATION_RESPONSE_TYPE = "token";
    public static final String JSON_KEY_ERROR = "error";
    public static final String JSON_KEY_MESSAGE = "message";
    public static final String JSON_KEY_CODE = "code";
    public static final String JSON_KEY_ERRNO = "errno";
    protected static final String[] requiredErrorStringFields = new String[]{"error", "message"};
    protected static final String[] requiredErrorLongFields = new String[]{"code", "errno"};
    protected final String serverURI;
    protected final Executor executor;

    public FxAccountAbstractClient(String string2, Executor executor) {
        if (string2 == null) {
            throw new IllegalArgumentException("Must provide a server URI.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must provide a non-null executor.");
        }
        String string3 = this.serverURI = string2.endsWith("/") ? string2 : string2 + "/";
        if (!this.serverURI.endsWith("/")) {
            throw new IllegalArgumentException("Constructed serverURI must end with a trailing slash: " + this.serverURI);
        }
        this.executor = executor;
    }

    public static int validateResponse(HttpResponse httpResponse) throws FxAccountAbstractClientException.FxAccountAbstractClientRemoteException {
        String string2;
        String string3;
        int n;
        int n2;
        ExtendedJSONObject extendedJSONObject;
        int n3 = httpResponse.getStatusLine().getStatusCode();
        if (n3 == 200) {
            return n3;
        }
        try {
            extendedJSONObject = new SyncStorageResponse(httpResponse).jsonObjectBody();
            extendedJSONObject.throwIfFieldsMissingOrMisTyped(requiredErrorStringFields, String.class);
            extendedJSONObject.throwIfFieldsMissingOrMisTyped(requiredErrorLongFields, Long.class);
            n2 = extendedJSONObject.getLong(JSON_KEY_CODE).intValue();
            n = extendedJSONObject.getLong(JSON_KEY_ERRNO).intValue();
            string3 = extendedJSONObject.getString(JSON_KEY_ERROR);
            string2 = extendedJSONObject.getString(JSON_KEY_MESSAGE);
        }
        catch (Exception exception) {
            throw new FxAccountAbstractClientException.FxAccountAbstractClientMalformedResponseException(httpResponse);
        }
        throw new FxAccountAbstractClientException.FxAccountAbstractClientRemoteException(httpResponse, n2, n, string3, string2, extendedJSONObject);
    }

    protected <T> void invokeHandleError(final RequestDelegate<T> requestDelegate, final Exception exception) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                requestDelegate.handleError(exception);
            }
        });
    }

    protected <T> void post(BaseResource baseResource, ExtendedJSONObject extendedJSONObject, RequestDelegate<T> requestDelegate) {
        try {
            if (extendedJSONObject == null) {
                baseResource.post((HttpEntity)null);
            } else {
                baseResource.post(extendedJSONObject);
            }
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
    }

    protected abstract class ResourceDelegate<T>
    extends BaseResourceDelegate {
        protected final RequestDelegate<T> delegate;

        protected abstract void handleSuccess(int var1, HttpResponse var2, ExtendedJSONObject var3);

        public ResourceDelegate(Resource resource, RequestDelegate<T> requestDelegate) {
            super(resource);
            this.delegate = requestDelegate;
        }

        @Override
        public AuthHeaderProvider getAuthHeaderProvider() {
            return super.getAuthHeaderProvider();
        }

        @Override
        public String getUserAgent() {
            return "Firefox-Android-FxAccounts/42.0a1 (Nightly)";
        }

        @Override
        public void handleHttpResponse(HttpResponse httpResponse) {
            try {
                int n = FxAccountAbstractClient.validateResponse(httpResponse);
                this.invokeHandleSuccess(n, httpResponse);
            }
            catch (FxAccountAbstractClientException.FxAccountAbstractClientRemoteException fxAccountAbstractClientRemoteException) {
                this.invokeHandleFailure(fxAccountAbstractClientRemoteException);
            }
        }

        protected void invokeHandleFailure(final FxAccountAbstractClientException.FxAccountAbstractClientRemoteException fxAccountAbstractClientRemoteException) {
            FxAccountAbstractClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ResourceDelegate.this.delegate.handleFailure(fxAccountAbstractClientRemoteException);
                }
            });
        }

        protected void invokeHandleSuccess(final int n, final HttpResponse httpResponse) {
            FxAccountAbstractClient.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExtendedJSONObject extendedJSONObject = new SyncResponse(httpResponse).jsonObjectBody();
                        ResourceDelegate.this.handleSuccess(n, httpResponse, extendedJSONObject);
                    }
                    catch (Exception exception) {
                        ResourceDelegate.this.delegate.handleError(exception);
                    }
                }
            });
        }

        @Override
        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            FxAccountAbstractClient.this.invokeHandleError(this.delegate, (Exception)clientProtocolException);
        }

        @Override
        public void handleHttpIOException(IOException iOException) {
            FxAccountAbstractClient.this.invokeHandleError(this.delegate, iOException);
        }

        @Override
        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            FxAccountAbstractClient.this.invokeHandleError(this.delegate, generalSecurityException);
        }

        @Override
        public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
            super.addHeaders(httpRequestBase, defaultHttpClient);
            Locale locale = Locale.getDefault();
            httpRequestBase.addHeader("Accept-Language", Utils.getLanguageTag(locale));
            httpRequestBase.addHeader("Accept", FxAccountAbstractClient.ACCEPT_HEADER);
        }
    }

    public static interface RequestDelegate<T> {
        public void handleError(Exception var1);

        public void handleFailure(FxAccountAbstractClientException.FxAccountAbstractClientRemoteException var1);

        public void handleSuccess(T var1);
    }
}

