/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.SharedBrowserDatabaseProvider;

public class TabsProvider
extends SharedBrowserDatabaseProvider {
    static final String TABLE_TABS = "tabs";
    static final String TABLE_CLIENTS = "clients";
    static final int TABS = 600;
    static final int TABS_ID = 601;
    static final int CLIENTS = 602;
    static final int CLIENTS_ID = 603;
    static final int CLIENTS_RECENCY = 604;
    static final String DEFAULT_TABS_SORT_ORDER = "last_modified DESC, last_used DESC";
    static final String DEFAULT_CLIENTS_SORT_ORDER = "last_modified DESC";
    static final String DEFAULT_CLIENTS_RECENCY_SORT_ORDER = "COALESCE(MAX(last_used), last_modified) DESC";
    static final String INDEX_TABS_GUID = "tabs_guid_index";
    static final String INDEX_TABS_POSITION = "tabs_position_index";
    static final String INDEX_CLIENTS_GUID = "clients_guid_index";
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    static final Map<String, String> TABS_PROJECTION_MAP;
    static final Map<String, String> CLIENTS_PROJECTION_MAP;
    static final Map<String, String> CLIENTS_RECENCY_PROJECTION_MAP;

    private static final String projectColumn(String string2, String string3) {
        return string2 + "." + string3;
    }

    private static final String selectColumn(String string2, String string3) {
        return TabsProvider.projectColumn(string2, string3) + " = ?";
    }

    public String getType(Uri uri) {
        int n = URI_MATCHER.match(uri);
        TabsProvider.trace("Getting URI type: " + uri);
        switch (n) {
            case 600: {
                TabsProvider.trace("URI is TABS: " + uri);
                return "vnd.android.cursor.dir/tab";
            }
            case 601: {
                TabsProvider.trace("URI is TABS_ID: " + uri);
                return "vnd.android.cursor.item/tab";
            }
            case 602: {
                TabsProvider.trace("URI is CLIENTS: " + uri);
                return "vnd.android.cursor.dir/client";
            }
            case 603: {
                TabsProvider.trace("URI is CLIENTS_ID: " + uri);
                return "vnd.android.cursor.item/client";
            }
        }
        TabsProvider.debug("URI has unrecognized type: " + uri);
        return null;
    }

    @Override
    public int deleteInTransaction(Uri uri, String string2, String[] stringArray) {
        TabsProvider.trace("Calling delete in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        int n2 = 0;
        switch (n) {
            case 603: {
                TabsProvider.trace("Delete on CLIENTS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_CLIENTS, "rowid"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 602: {
                TabsProvider.trace("Delete on CLIENTS: " + uri);
                this.deleteValues(uri, string2, stringArray, TABLE_TABS);
                n2 = this.deleteValues(uri, string2, stringArray, TABLE_CLIENTS);
                break;
            }
            case 601: {
                TabsProvider.trace("Delete on TABS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_TABS, "_id"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 600: {
                TabsProvider.trace("Deleting on TABS: " + uri);
                n2 = this.deleteValues(uri, string2, stringArray, TABLE_TABS);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown delete URI " + uri);
            }
        }
        TabsProvider.debug("Deleted " + n2 + " rows for URI: " + uri);
        return n2;
    }

    @Override
    public Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        TabsProvider.trace("Calling insert in transaction on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = URI_MATCHER.match(uri);
        long l = -1L;
        switch (n) {
            case 602: {
                String string2 = contentValues.getAsString("guid");
                TabsProvider.debug("Inserting client in database with GUID: " + string2);
                l = sQLiteDatabase.insertOrThrow(TABLE_CLIENTS, "guid", contentValues);
                break;
            }
            case 600: {
                String string3 = contentValues.getAsString("url");
                TabsProvider.debug("Inserting tab in database with URL: " + string3);
                l = sQLiteDatabase.insertOrThrow(TABLE_TABS, "title", contentValues);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert URI " + uri);
            }
        }
        TabsProvider.debug("Inserted ID in database: " + l);
        if (l >= 0L) {
            return ContentUris.withAppendedId((Uri)uri, (long)l);
        }
        return null;
    }

    @Override
    public int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        TabsProvider.trace("Calling update in transaction on URI: " + uri);
        int n = URI_MATCHER.match(uri);
        int n2 = 0;
        switch (n) {
            case 603: {
                TabsProvider.trace("Update on CLIENTS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_CLIENTS, "rowid"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 602: {
                TabsProvider.trace("Update on CLIENTS: " + uri);
                n2 = this.updateValues(uri, contentValues, string2, stringArray, TABLE_CLIENTS);
                break;
            }
            case 601: {
                TabsProvider.trace("Update on TABS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_TABS, "_id"));
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 600: {
                TabsProvider.trace("Update on TABS: " + uri);
                n2 = this.updateValues(uri, contentValues, string2, stringArray, TABLE_TABS);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        TabsProvider.debug("Updated " + n2 + " rows for URI: " + uri);
        return n2;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(uri);
        int n = URI_MATCHER.match(uri);
        String string4 = null;
        SQLiteQueryBuilder sQLiteQueryBuilder = new SQLiteQueryBuilder();
        String string5 = uri.getQueryParameter("limit");
        switch (n) {
            case 601: {
                TabsProvider.trace("Query is on TABS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_TABS, "_id"));
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 600: {
                TabsProvider.trace("Query is on TABS: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_TABS_SORT_ORDER;
                } else {
                    TabsProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(TABS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables("tabs LEFT OUTER JOIN clients ON (tabs.client_guid = clients.guid)");
                break;
            }
            case 603: {
                TabsProvider.trace("Query is on CLIENTS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, TabsProvider.selectColumn(TABLE_CLIENTS, "rowid"));
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 602: {
                TabsProvider.trace("Query is on CLIENTS: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_CLIENTS_SORT_ORDER;
                } else {
                    TabsProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(CLIENTS_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables(TABLE_CLIENTS);
                break;
            }
            case 604: {
                TabsProvider.trace("Query is on CLIENTS_RECENCY: " + uri);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = DEFAULT_CLIENTS_RECENCY_SORT_ORDER;
                } else {
                    TabsProvider.debug("Using sort order " + string3 + ".");
                }
                sQLiteQueryBuilder.setProjectionMap(CLIENTS_RECENCY_PROJECTION_MAP);
                sQLiteQueryBuilder.setTables("clients LEFT OUTER JOIN tabs ON (" + TabsProvider.projectColumn(TABLE_CLIENTS, "guid") + " = " + TabsProvider.projectColumn(TABLE_TABS, "client_guid") + ")");
                string4 = TabsProvider.projectColumn(TABLE_CLIENTS, "guid");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri);
            }
        }
        TabsProvider.trace("Running built query.");
        Cursor cursor = sQLiteQueryBuilder.query(sQLiteDatabase, stringArray, string2, stringArray2, string4, null, string3, string5);
        cursor.setNotificationUri(this.getContext().getContentResolver(), BrowserContract.TABS_AUTHORITY_URI);
        return cursor;
    }

    int updateValues(Uri uri, ContentValues contentValues, String string2, String[] stringArray, String string3) {
        TabsProvider.trace("Updating tabs on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        return sQLiteDatabase.update(string3, contentValues, string2, stringArray);
    }

    int deleteValues(Uri uri, String string2, String[] stringArray, String string3) {
        TabsProvider.debug("Deleting tabs for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        this.beginWrite(sQLiteDatabase);
        return sQLiteDatabase.delete(string3, string2, stringArray);
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", TABLE_TABS, 600);
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", "tabs/#", 601);
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", TABLE_CLIENTS, 602);
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", "clients/#", 603);
        URI_MATCHER.addURI("org.mozilla.fennec.db.tabs", "clients_recency", 604);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("_id", "_id");
        hashMap.put("title", "title");
        hashMap.put("url", "url");
        hashMap.put("history", "history");
        hashMap.put("favicon", "favicon");
        hashMap.put("last_used", "last_used");
        hashMap.put("position", "position");
        hashMap.put("guid", "guid");
        hashMap.put("name", "name");
        hashMap.put("last_modified", "last_modified");
        hashMap.put("device_type", "device_type");
        TABS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put("guid", "guid");
        hashMap.put("name", "name");
        hashMap.put("last_modified", "last_modified");
        hashMap.put("device_type", "device_type");
        CLIENTS_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put("guid", TabsProvider.projectColumn(TABLE_CLIENTS, "guid") + " AS guid");
        hashMap.put("name", TabsProvider.projectColumn(TABLE_CLIENTS, "name") + " AS name");
        hashMap.put("last_modified", TabsProvider.projectColumn(TABLE_CLIENTS, "last_modified") + " AS last_modified");
        hashMap.put("device_type", TabsProvider.projectColumn(TABLE_CLIENTS, "device_type") + " AS device_type");
        hashMap.put("last_used", "COALESCE(MAX(" + TabsProvider.projectColumn(TABLE_TABS, "last_used") + "), " + TabsProvider.projectColumn(TABLE_CLIENTS, "last_modified") + ") AS last_used");
        CLIENTS_RECENCY_PROJECTION_MAP = Collections.unmodifiableMap(hashMap);
    }
}

