/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mdns;

import android.annotation.TargetApi;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.util.Log;
import java.util.Map;
import org.json.JSONException;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.mdns.NsdMulticastDNSManager;
import org.mozilla.gecko.util.EventCallback;

@TargetApi(value=16)
class RegistrationListener
implements NsdManager.RegistrationListener {
    private static final String LOGTAG = "GeckoMDNSManager";
    private final NsdManager nsdManager;
    private EventCallback mStartCallback = null;
    private EventCallback mStopCallback = null;

    RegistrationListener(NsdManager nsdManager) {
        this.nsdManager = nsdManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(int n, String string2, String string3, Map<String, String> map, EventCallback eventCallback) {
        Log.d((String)LOGTAG, (String)("registerService: " + string2 + "." + string3 + ":" + n));
        RegistrationListener registrationListener = this;
        synchronized (registrationListener) {
            if (this.mStartCallback != null) {
                throw new RuntimeException("Previous operation is not finished");
            }
            this.mStartCallback = eventCallback;
        }
        registrationListener = new NsdServiceInfo();
        registrationListener.setPort(n);
        registrationListener.setServiceName(string2);
        registrationListener.setServiceType(string3);
        this.setAttributes((NsdServiceInfo)registrationListener, map);
        this.nsdManager.registerService((NsdServiceInfo)registrationListener, 1, (NsdManager.RegistrationListener)this);
    }

    @TargetApi(value=21)
    private void setAttributes(NsdServiceInfo nsdServiceInfo, Map<String, String> map) {
        if (map == null || !AppConstants.Versions.feature21Plus) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            nsdServiceInfo.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(EventCallback eventCallback) {
        Log.d((String)LOGTAG, (String)"unregisterService");
        RegistrationListener registrationListener = this;
        synchronized (registrationListener) {
            if (this.mStopCallback != null) {
                throw new RuntimeException("Previous operation is not finished");
            }
            this.mStopCallback = eventCallback;
        }
        this.nsdManager.unregisterService((NsdManager.RegistrationListener)this);
    }

    public synchronized void onServiceRegistered(NsdServiceInfo nsdServiceInfo) {
        Log.d((String)LOGTAG, (String)("onServiceRegistered: " + nsdServiceInfo.getServiceName()));
        if (this.mStartCallback == null) {
            return;
        }
        try {
            this.mStartCallback.sendSuccess((Object)NsdMulticastDNSManager.toJSON(nsdServiceInfo));
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        this.mStartCallback = null;
    }

    public synchronized void onRegistrationFailed(NsdServiceInfo nsdServiceInfo, int n) {
        Log.e((String)LOGTAG, (String)("onRegistrationFailed: " + nsdServiceInfo.getServiceName() + "(" + n + ")"));
        if (this.mStartCallback == null) {
            return;
        }
        this.mStartCallback.sendError((Object)n);
        this.mStartCallback = null;
    }

    public synchronized void onServiceUnregistered(NsdServiceInfo nsdServiceInfo) {
        Log.d((String)LOGTAG, (String)("onServiceUnregistered: " + nsdServiceInfo.getServiceName()));
        if (this.mStopCallback == null) {
            return;
        }
        try {
            this.mStopCallback.sendSuccess((Object)NsdMulticastDNSManager.toJSON(nsdServiceInfo));
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        this.mStopCallback = null;
    }

    public synchronized void onUnregistrationFailed(NsdServiceInfo nsdServiceInfo, int n) {
        Log.e((String)LOGTAG, (String)("onUnregistrationFailed: " + nsdServiceInfo.getServiceName() + "(" + n + ")"));
        if (this.mStopCallback == null) {
            return;
        }
        this.mStopCallback.sendError((Object)n);
        this.mStopCallback = null;
    }
}

